/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.syncData.service;

import com.coraltele.db.telephony.main.entity.SyncLog;
import com.coraltele.db.telephony.main.repository.SyncLogRepository;
import com.coraltele.db.telephony.pbx.entity.NodeConfiguration;
import com.coraltele.db.telephony.pbx.repository.NodeConfigurationRepository;
import com.coraltele.helper.BashCmd;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.syncData.model.RestoreConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

@Component
public class RestoreByClusterService {
    private static final Logger logger = LogManager.getLogger(RestoreByClusterService.class);
    @Autowired
    BashCmd bashCmd;
    @Autowired
    NodeConfigurationRepository nodeConfigurationRepository;
    @Autowired
    SyncLogRepository syncLogRepository;
    private final String BACKUP_BASE_PATH = "/tmp/db/backups";
    @Autowired
    private RestTemplate restTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse restoreToAllServers(long backupVersion) {
        RequestResponse returnValue = new RequestResponse();
        logger.info("Starting restore to all servers...");
        List<RestoreConfig> restoreConfigs = Arrays.asList(new RestoreConfig("users", false, null), new RestoreConfig("switch", false, null), new RestoreConfig("coralapps", true, Arrays.asList("agents", "members", "tiers")));
        logger.info("List of Target Servers to Sync:{}", (Object)this.getBackupServers());
        for (String serverIp : this.getBackupServers()) {
            logger.info("Restoring to server: {}", (Object)serverIp);
            for (RestoreConfig config : restoreConfigs) {
                String dbName = config.getDbName();
                Optional syncLog = this.syncLogRepository.findByVersionAndDbName(Long.valueOf(backupVersion), dbName);
                if (!syncLog.isPresent()) {
                    logger.error("No SyncLog found for DB {} and version {}", (Object)dbName, (Object)backupVersion);
                    continue;
                }
                try {
                    logger.info("Starting restore for DB: {} (Partial: {})", (Object)config.getDbName(), (Object)config.isPartial());
                    boolean checkDbBlock = this.callBlockConnectionApi(serverIp, dbName);
                    if (!checkDbBlock) {
                        returnValue.setStatus(Constants.Error.ERROR);
                        returnValue.setMessage("Db block process failed at remote");
                        RequestResponse requestResponse = returnValue;
                        return requestResponse;
                    }
                    String backupPath = this.getLatestBackupPath(config.getDbName());
                    logger.info("Latest backup path for {}: {}", (Object)config.getDbName(), (Object)backupPath);
                    RequestResponse result = this.restoreFileByInternal(config.getDbName(), backupPath, config.isPartial(), config.getTables(), serverIp);
                    if (Constants.Error.OK == result.getStatus()) {
                        this.syncLogRepository.updateSyncLogFields(((SyncLog)syncLog.get()).getId(), this.getSourceServer(), serverIp, "Restore Complete");
                        logger.info("Restore completed successfully for DB: {} on {}", (Object)config.getDbName(), (Object)serverIp);
                        returnValue.setStatus(Constants.Error.OK);
                        returnValue.setMessage("Restore completed successfully");
                        continue;
                    }
                    this.syncLogRepository.updateSyncLogFields(((SyncLog)syncLog.get()).getId(), this.getSourceServer(), serverIp, "Restore failed");
                    logger.info("Restore failed for DB: {} on {}", (Object)config.getDbName(), (Object)serverIp);
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("Restore failed");
                }
                catch (Exception ex) {
                    ((SyncLog)syncLog.get()).setStatus("Restore Failed");
                    this.syncLogRepository.updateSyncLogFields(((SyncLog)syncLog.get()).getId(), this.getSourceServer(), serverIp, "Restore Failed");
                    logger.error("Restore failed for DB: {} on {}", (Object)config.getDbName(), (Object)serverIp, (Object)ex);
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("Restore failed");
                }
                finally {
                    try {
                        this.callUnBlockConnectionApi(serverIp, config.getDbName());
                    }
                    catch (Exception e) {
                        logger.error("Failed to unblock connections for DB: {} on {}", (Object)config.getDbName(), (Object)serverIp, (Object)e);
                    }
                }
            }
        }
        logger.info("Restore process finished for all servers.");
        return returnValue;
    }

    public List<String> getBackupServers() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            List ipList = this.nodeConfigurationRepository.findAll();
            if (ipList != null && !ipList.isEmpty()) {
                for (NodeConfiguration data : ipList) {
                    if (data.getServerCode().equals(this.getServerCode())) continue;
                    list.add(data.getVirtualIp());
                    logger.info("Target server for restore: {}", (Object)data.getVirtualIp());
                }
            } else {
                logger.warn("No node configurations found.");
            }
        }
        catch (Exception e) {
            logger.error("Error fetching node configurations", (Throwable)e);
        }
        return list;
    }

    public String getSourceServer() {
        Optional ipList = this.nodeConfigurationRepository.findByServerCode(this.getServerCode());
        if (ipList.isPresent()) {
            return ((NodeConfiguration)ipList.get()).getVirtualIp();
        }
        return "";
    }

    public RequestResponse blockNewConnections(String dbName) {
        RequestResponse returnValue = new RequestResponse();
        try {
            String blockCmd = String.format("sudo -u postgres PGPASSWORD=Pgadmin@123 psql -U postgres -d %s -c 'ALTER DATABASE %s CONNECTION LIMIT 0;'", dbName, dbName);
            boolean checkCmd = this.runCmd(blockCmd);
            if (checkCmd) {
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Block db connection Successful");
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Block db connection UnSuccessful");
                returnValue.setMessageDetail("Check the log properly");
            }
            logger.info("Blocked new connections to DB {}", (Object)dbName);
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to execute Command");
            returnValue.setMessageDetail("Check the log properly: " + e.getMessage());
        }
        return returnValue;
    }

    public RequestResponse unBlockDbConnections(String dbName) {
        RequestResponse returnValue = new RequestResponse();
        try {
            String unblockCmd = String.format("sudo -u postgres PGPASSWORD=Pgadmin@123 psql -U postgres -d %s -c 'ALTER DATABASE %s CONNECTION LIMIT -1;'", dbName, dbName);
            boolean checkCmd = this.runCmd(unblockCmd);
            if (checkCmd) {
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("UnBlock db connection Successful");
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("UnBlock db connection UnSuccessful");
                returnValue.setMessageDetail("Check the log properly");
            }
            logger.info("UnBlocked new connections to DB {}", (Object)dbName);
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to execute Command");
            returnValue.setMessageDetail("Check the log properly");
        }
        return returnValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getServerCode() {
        Properties prop = new Properties();
        String fileName = "/etc/coraltelecom/callserver.manager.conf";
        try (FileInputStream input = new FileInputStream(fileName);){
            prop.load(input);
            String serverCode = prop.getProperty("servercode", "").trim();
            if (!serverCode.isEmpty()) {
                logger.info("Current ServerCode: {}", (Object)serverCode);
                String string = serverCode;
                return string;
            }
            logger.warn("ServerCode not found in config");
            return "";
        }
        catch (Exception e) {
            logger.error("Unable to load ServerCode from config", (Throwable)e);
        }
        return "";
    }

    public boolean runCmd(String command) {
        StringBuilder output = new StringBuilder();
        ArrayList<String> outputLines = new ArrayList<String>();
        try {
            logger.info("Executing command: {}", (Object)command);
            ProcessBuilder pb = new ProcessBuilder("bash", "-c", "sudo " + command);
            pb.redirectErrorStream(true);
            Process process = pb.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line2;
                while ((line2 = reader.readLine()) != null) {
                    outputLines.add(line2);
                    output.append(line2).append("\n");
                }
            }
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                logger.info("Command executed successfully:\n{}", (Object)output);
                return true;
            }
            boolean containsOnlyWarnings = outputLines.stream().allMatch(line -> line.contains("pg_restore: warning: errors ignored on restore:") || line.contains("unrecognized configuration parameter \"transaction_timeout\"") || line.contains("Command was: SET transaction_timeout = 0;") || line.contains("could not execute query: ERROR:  unrecognized configuration parameter") || line.trim().isEmpty());
            if (containsOnlyWarnings) {
                logger.warn("Command executed with non-critical warnings:\n{}", (Object)output);
                return true;
            }
            logger.error("Command execution failed with exit code {}:\n{}", (Object)exitCode, (Object)output);
            return false;
        }
        catch (Exception e) {
            logger.error("Exception while executing command: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    private String getLatestBackupPath(String dbName) {
        try {
            return Files.list(Paths.get("/tmp/db/backups", dbName)).filter(f -> f.toString().endsWith(".backup")).sorted((f1, f2) -> Long.compare(f2.toFile().lastModified(), f1.toFile().lastModified())).map(f -> f.toAbsolutePath().toString()).findFirst().orElseThrow(() -> new RuntimeException("No backup found for " + dbName));
        }
        catch (Exception e) {
            logger.error("Error fetching latest backup for DB: {}", (Object)dbName, (Object)e);
            throw new RuntimeException("Error fetching backup for " + dbName, e);
        }
    }

    public RequestResponse saveFile(MultipartFile file, String path) {
        RequestResponse response = new RequestResponse();
        try {
            boolean dirsCreated;
            File destination = new File(path);
            File parentDir = destination.getParentFile();
            if (parentDir != null && !parentDir.exists() && !(dirsCreated = parentDir.mkdirs())) {
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("Failed to create directories for path: " + parentDir.getAbsolutePath());
                return response;
            }
            file.transferTo(destination);
            response.setStatus(Constants.Error.OK);
            response.setMessage("File saved successfully at: " + destination.getAbsolutePath());
            return response;
        }
        catch (IOException e) {
            logger.error("Failed to save file: {}", (Object)e.getMessage());
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Error saving file: " + e.getMessage());
            return response;
        }
    }

    public boolean saveFileToRemote(String remoteIp, File file, String path) {
        try {
            String remoteUrl = String.format("http://%s/services/api/v2/sync/saveFile", remoteIp);
            HttpHeaders headers = new HttpHeaders();
            headers.set("Authorization", "Cluster " + Constants.CLUSTER_KEY);
            headers.setContentType(MediaType.MULTIPART_FORM_DATA);
            FileSystemResource fileResource = new FileSystemResource(file);
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            body.add((Object)"file", (Object)fileResource);
            body.add((Object)"path", (Object)path);
            HttpEntity requestEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
            RestTemplate restTemplate = new RestTemplate();
            ResponseEntity response = restTemplate.exchange(remoteUrl, HttpMethod.POST, requestEntity, RequestResponse.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK && response.getBody() != null && Constants.Error.OK.equals((Object)((RequestResponse)response.getBody()).getStatus())) {
                logger.info("File restore API succeeded on server: {}", (Object)remoteIp);
                return true;
            }
            logger.error("File restore API failed on server: {}, Status: {}, Response: {}", (Object)remoteIp, (Object)response.getStatusCode(), response.getBody());
        }
        catch (Exception e) {
            logger.error("Exception during restore file API call to {}: {}", (Object)remoteIp, (Object)e.getMessage());
        }
        return false;
    }

    public boolean callUnBlockConnectionApi(String remoteIp, String dbName) {
        try {
            String remoteUrl = String.format("http://%s/services/api/v2/sync/unBlockDbConnection/%s", remoteIp, dbName);
            HttpHeaders headers = new HttpHeaders();
            headers.set("Authorization", "Cluster " + Constants.CLUSTER_KEY);
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            RestTemplate restTemplate = new RestTemplate();
            ResponseEntity response = restTemplate.exchange(remoteUrl, HttpMethod.POST, requestEntity, RequestResponse.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK && response.getBody() != null && Constants.Error.OK.equals((Object)((RequestResponse)response.getBody()).getStatus())) {
                logger.info("File restore API succeeded on server: {}", (Object)remoteIp);
                return true;
            }
            logger.error("File restore API failed on server: {}, Status: {}, Response: {}", (Object)remoteIp, (Object)response.getStatusCode(), response.getBody());
        }
        catch (Exception e) {
            logger.error("Exception during restore file API call to {}: {}", (Object)remoteIp, (Object)e.getMessage());
        }
        return false;
    }

    public boolean callBlockConnectionApi(String remoteIp, String dbName) {
        try {
            String remoteUrl = String.format("http://%s/services/api/v2/sync/blockDbConnection/%s", remoteIp, dbName);
            HttpHeaders headers = new HttpHeaders();
            headers.set("Authorization", "Cluster " + Constants.CLUSTER_KEY);
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            RestTemplate restTemplate = new RestTemplate();
            ResponseEntity response = restTemplate.exchange(remoteUrl, HttpMethod.POST, requestEntity, RequestResponse.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK && response.getBody() != null && Constants.Error.OK.equals((Object)((RequestResponse)response.getBody()).getStatus())) {
                logger.info("File restore API succeeded on server: {}", (Object)remoteIp);
                return true;
            }
            logger.error("File restore API failed on server: {}, Status: {}, Response: {}", (Object)remoteIp, (Object)response.getStatusCode(), response.getBody());
        }
        catch (Exception e) {
            logger.error("Exception during block db connection API call to {}: {}", (Object)remoteIp, (Object)e.getMessage());
        }
        return false;
    }

    public RequestResponse restoreFileByInternal(String dbName, String localBackupPath, boolean dbIsPartial, List<String> tableName, String remoteServerIp) {
        RequestResponse response = new RequestResponse();
        try {
            File fileToSend = new File(localBackupPath);
            if (!fileToSend.exists()) {
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("Backup file does not exist at path: " + localBackupPath);
                return response;
            }
            boolean fileSent = this.saveFileToRemote(remoteServerIp, fileToSend, localBackupPath);
            if (!fileSent) {
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("Failed to send file to remote server.");
                return response;
            }
            boolean dbCreated = this.createDropDbToRemote(remoteServerIp, dbName, dbIsPartial, tableName, localBackupPath);
            if (!dbCreated) {
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("Failed to drop/create DB on remote server.");
                return response;
            }
            response.setStatus(Constants.Error.OK);
            response.setMessage("File transfer and DB restore completed successfully.");
        }
        catch (Exception e) {
            logger.error("Exception in restoreFileByInternal: {}", (Object)e.getMessage(), (Object)e);
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Error occurred while restoring file internally: " + e.getMessage());
        }
        return response;
    }

    public RequestResponse dropCreateDbCmd(String dbName, boolean isPartial, List<String> tables, String localBackupPath) {
        RequestResponse returnValue = new RequestResponse();
        try {
            logger.info("dropCreateDbCmd:: values:: {} {} {}", (Object)dbName, (Object)isPartial, tables);
            String cmd = this.buildDropCommand(dbName, isPartial, tables);
            logger.info("cmd to create/Drop database/Table: {}", (Object)cmd);
            boolean checkCmd = this.runCmd(cmd);
            if (checkCmd) {
                String restoreDatabase = this.restoreCommand(dbName, localBackupPath, isPartial, tables);
                boolean runRestore = this.runCmd(restoreDatabase);
                if (runRestore) {
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("Database dropBuild Successful");
                } else {
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("fail process at restore");
                    returnValue.setMessageDetail("Restore failed at remote");
                }
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("DropBuild Database UnSuccessful");
                returnValue.setMessageDetail("Check the log properly");
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to execute Command");
            returnValue.setMessageDetail("Check the log properly");
        }
        return returnValue;
    }

    private String buildDropCommand(String dbName, boolean isPartial, List<String> tables) {
        logger.info("Values for drop and create db:{} {} {}", (Object)dbName, (Object)isPartial, tables);
        if (isPartial && tables != null && !tables.isEmpty()) {
            StringBuilder sb = new StringBuilder("sudo -u postgres sh -c '");
            for (int i = 0; i < tables.size(); ++i) {
                sb.append(String.format("PGPASSWORD=\"Pgadmin@123\" psql -U postgres -d %s -c \"DROP TABLE IF EXISTS %s CASCADE;\"", dbName, tables.get(i)));
                if (i >= tables.size() - 1) continue;
                sb.append(" && ");
            }
            sb.append("'");
            return sb.toString();
        }
        return String.format("sudo -u postgres bash -c 'if PGPASSWORD=Pgadmin@123 psql -U postgres -tAc \"SELECT 1 FROM pg_database WHERE datname = '\\''%s'\\''\" | grep -q 1; then PGPASSWORD=Pgadmin@123 psql -U postgres -d postgres -c \"SELECT pg_terminate_backend(pid) FROM pg_stat_activity WHERE datname = '\\''%s'\\'' AND pid <> pg_backend_pid();\" && PGPASSWORD=Pgadmin@123 dropdb -U postgres %s && PGPASSWORD=Pgadmin@123 createdb -U postgres %s; else PGPASSWORD=Pgadmin@123 createdb -U postgres %s; fi'", dbName, dbName, dbName, dbName, dbName);
    }

    private String restoreCommand(String dbName, String backupPath, boolean isPartial, List<String> tables) {
        StringBuilder tableOptions = new StringBuilder();
        if (isPartial && tables != null && !tables.isEmpty()) {
            for (String t : tables) {
                tableOptions.append(" -t ").append("\"").append(t).append("\"");
            }
        }
        return String.format("sudo -u postgres bash -c 'PGPASSWORD=Pgadmin@123 pg_restore -h 127.0.0.1 -p 5432 -U postgres -d %s %s %s'", dbName, tableOptions.toString().trim(), backupPath);
    }

    public boolean createDropDbToRemote(String remoteIp, String dbName, boolean isPartial, List<String> tables, String localBackupPath) {
        try {
            HttpEntity requestEntity;
            RestTemplate restTemplate;
            ResponseEntity response;
            String remoteUrl = String.format("http://%s/services/api/v2/sync/createDropDb", remoteIp);
            HttpHeaders headers = new HttpHeaders();
            headers.set("Authorization", "Cluster " + Constants.CLUSTER_KEY);
            headers.setContentType(MediaType.MULTIPART_FORM_DATA);
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            body.add((Object)"dbName", (Object)dbName);
            body.add((Object)"isPartial", (Object)String.valueOf(isPartial));
            body.add((Object)"localBackupPath", (Object)localBackupPath);
            if (tables != null) {
                for (String table : tables) {
                    body.add((Object)"tables", (Object)table);
                }
            }
            if ((response = (restTemplate = new RestTemplate()).exchange(remoteUrl, HttpMethod.POST, requestEntity = new HttpEntity((Object)body, (MultiValueMap)headers), RequestResponse.class, new Object[0])).getStatusCode() == HttpStatus.OK && response.getBody() != null) {
                logger.info("Create/drop DB API succeeded on server: {}", (Object)remoteIp);
                return true;
            }
            logger.error("Create/drop DB API failed on server: {}, Status: {}, Response: {}", (Object)remoteIp, (Object)response.getStatusCode(), response.getBody());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Exception during createDropDb API call to {}: {}", (Object)remoteIp, (Object)e.getMessage());
        }
        return false;
    }
}

