/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.billing.main.fax.service;

import com.coraltele.db.billing.main.entity.SendFaxProgress;
import com.coraltele.db.billing.main.repository.FaxRepository;
import com.coraltele.db.billing.main.repository.SendFaxProgressRepository;
import com.coraltele.db.billing.main.specification.FaxViewSpecification;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.telephony.uc.entity.SendFaxDetails;
import com.coraltele.db.telephony.uc.repository.SendFaxDetailsRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.IVRUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.helper.Telephony;
import com.coraltele.helper.TelephonyCommand;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.billing.main.fax.model.FaxTransferDetailsModel;
import com.coraltele.service.billing.main.uc_notification.service.UcNotificationService;
import com.coraltele.service.pbx.controlRluServer.service.ControlRluServerService;
import com.coraltele.service.pbx.emailDetail.model.CustomEmailDetailModel;
import com.coraltele.service.pbx.emailDetail.service.EmailDetailService;
import com.coraltele.service.pbx.extension.service.ExtensionsService;
import com.coraltele.service.pbx.sendfaxprogress.service.SendFaxProgressService;
import com.coraltele.service.uc.service.CustomerAccountService;
import com.coraltele.service.uc.service.UCService;
import com.coraltele.service.uc.service.VMTransferDetailsService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class FaxService {
    private static final Logger logger = LogManager.getLogger(FaxService.class);
    private static String faxFile = "/etc/coraltelecom/app.config";
    String coralPath = "/etc/default/coral";
    String location = null;
    @Autowired
    UCService ucService;
    @Autowired
    private FaxRepository faxRepository;
    @Autowired
    VMTransferDetailsService vmTransferDetailsService;
    @Autowired
    CustomerAccountService customerAccountService;
    @Autowired
    private IVRUtility iVRUtility;
    @Autowired
    private ExtensionsService extensionService;
    @Autowired
    TelephonyCommand telephonyCommand;
    @Autowired
    SendFaxDetailsRepository sendFaxDetailsRepository;
    @Autowired
    SendFaxProgressService sendFaxProgressService;
    @Autowired
    EmailDetailService emailDetailService;
    @Autowired
    UcNotificationService ucNotificationService;
    @Autowired
    private ControlRluServerService controlRluServerService;
    @Autowired
    SendFaxProgressRepository sendFaxProgressRepository;
    @Autowired
    ExtensionsRepository extensionsRepository;

    public RequestResponse getFaxUserData(Authentication authentication, SearchRequest searchRequestData) {
        this.ucNotificationService.updateNotificationForFax(authentication);
        RequestResponse returnValue = new RequestResponse();
        Specification filters = FaxViewSpecification.generateFilters((SearchRequest)searchRequestData, (String)authentication.getName());
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "recordDate" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "recordDate" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.faxRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.faxRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessageDetail("filtered list");
        logger.info(returnValue.getMessageDetail());
        return returnValue;
    }

    public RequestResponse getUnLoggedUser(String userName) {
        RequestResponse returnValue = new RequestResponse();
        RequestResponse getRequestResponse = this.customerAccountService.getUnLoggedUser(userName, "softfax");
        returnValue.setStatus(getRequestResponse.getStatus());
        returnValue.setMessage(getRequestResponse.getMessage());
        returnValue.setMessageDetail(getRequestResponse.getMessageDetail());
        returnValue.setData(getRequestResponse.getData());
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public String fetchLocation(String fileName) {
        File retrieveFile = new File(fileName);
        if (retrieveFile.exists()) {
            try (Stream<String> stream = Files.lines(Paths.get(faxFile, new String[0]));){
                stream.filter(line -> line.contains("location.uploadfax=")).forEach(line -> {
                    int index = line.indexOf(61);
                    if (index != -1) {
                        this.location = line.substring(index + 1).trim();
                    }
                });
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        } else {
            this.location = "/mnt/upload";
        }
        return this.location;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getSBCUserPort() {
        String sbcUserPort = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(this.coralPath));){
            String line = null;
            block11: while ((line = reader.readLine()) != null) {
                if (!line.startsWith("[CLUSTER")) continue;
                while ((line = reader.readLine()) != null) {
                    if (!line.startsWith("SBC_USERS_PORT =")) continue;
                    sbcUserPort = line.substring(line.indexOf("=") + 1).trim();
                    continue block11;
                }
            }
            String string = sbcUserPort;
            return string;
        }
        catch (IOException e) {
            logger.error("Error While Reading SBC_USERS_PORT From File", (Throwable)e);
            return sbcUserPort;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String getIPFeatureServer(String rluCode) {
        String ipFeatureServer = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(this.coralPath));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (rluCode == null) {
                    if (!line.startsWith("[CSCF-1")) continue;
                    while ((line = reader.readLine()) != null) {
                        if (!line.startsWith("IP-FEATURE-SERVER =") && !line.startsWith("IP-FEATURE-SERVER=")) continue;
                        String string = ipFeatureServer = line.substring(line.indexOf("=") + 1).trim();
                        return string;
                    }
                    continue;
                }
                if (!line.contains("NAME = " + rluCode)) continue;
                while ((line = reader.readLine()) != null) {
                    if (!line.startsWith("IP-FEATURE-SERVER =") && !line.startsWith("IP-FEATURE-SERVER=")) continue;
                    String string = ipFeatureServer = line.substring(line.indexOf("=") + 1).trim();
                    return string;
                }
            }
        }
        catch (IOException e) {
            logger.error("Error While Reading IP-FEATURE-SERVER From File", (Throwable)e);
        }
        return ipFeatureServer;
    }

    public RequestResponse faxInitiation(MultipartFile file, String username, String[] extensions) {
        logger.debug("upload file : {}", (Object)file);
        RequestResponse returnValue = new RequestResponse();
        String caller_phone = this.extensionService.getExtension(username, "phone");
        String caller_softFax = this.extensionService.getExtension(username, "softfax");
        String port = "";
        port = Constants.FEATURE_USERS_PORT.isEmpty() ? "5060" : Constants.FEATURE_USERS_PORT;
        String filename = null;
        String command = null;
        try {
            this.location = this.fetchLocation(faxFile);
            String pathToUpload = this.location + "/";
            if (file.getContentType().equals("image/tiff") && returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                returnValue = this.iVRUtility.uploadImage(file, pathToUpload);
                filename = (String)returnValue.getData();
                if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                    if (Constants.BACKWARD_COMPATIBILITY.booleanValue()) {
                        String rluCode = this.controlRluServerService.getRluCodeFinal(caller_softFax);
                        String sofiaProfile = this.controlRluServerService.getProfileName(caller_softFax);
                        logger.info("sofiaProfile : {} rluCode : {} caller_softFax:{}", (Object)sofiaProfile, (Object)rluCode, (Object)caller_softFax);
                        for (String callie_softFax : extensions) {
                            logger.info("Send fax Caller Phone : {} Caller Soft Fax : {} Callee Soft Fax : {} Profile : {} ipFeatureServer : {} sbcUserPort : {} location : {} filename : {}", (Object)caller_phone, (Object)caller_softFax, (Object)callie_softFax, (Object)sofiaProfile, (Object)Constants.IP_FEATURE_SERVER, (Object)port, (Object)this.location, (Object)filename);
                            command = "fs_cli -x \"bgapi originate {origination_caller_id_number=" + caller_phone + ",coral_uc_callerid=" + caller_phone + ",coral_uc_calleeid=" + callie_softFax + ",coral_app=SendFax,fax_ident=" + caller_softFax + ",fax_header=softfax,absolute_codec_string='PCMU,PCMA'}sofia/" + sofiaProfile + "/" + callie_softFax.trim() + "@" + Constants.IP_FEATURE_SERVER + ":" + port + " &txfax(" + this.location + "/" + filename.trim() + ")\"";
                            SendFaxDetails sendFaxDetails = new SendFaxDetails();
                            sendFaxDetails.setFromUser(caller_softFax);
                            sendFaxDetails.setCreatedOn(LocalDateTime.now());
                            sendFaxDetails.setCreatedBy(username);
                            sendFaxDetails.setToUser(this.extensionService.getAssignedUser(callie_softFax));
                            sendFaxDetails.setFileName(file.getOriginalFilename());
                            sendFaxDetails.setFileLocation(this.location);
                            sendFaxDetails.setFileType("image/tiff");
                            sendFaxDetails.setFullFilePath(this.location + "/" + filename + ".tif");
                            sendFaxDetails.setFileId(filename.substring(0, filename.lastIndexOf(".tif")));
                            sendFaxDetails.setLastStatus("");
                            sendFaxDetails.setCurrentStatus("");
                            this.sendFaxDetailsRepository.save((Object)sendFaxDetails);
                            Telephony.makeCallBackCall((String)command);
                            if (!returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                                returnValue.setStatus(returnValue.getStatus());
                                returnValue.setMessage(returnValue.getMessage());
                                returnValue.setMessageDetail(returnValue.getMessageDetail());
                                logger.error(returnValue.getMessageDetail());
                                return returnValue;
                            }
                            returnValue.setStatus(Constants.Error.OK);
                            returnValue.setMessage(" SuccessFul Initiation");
                            returnValue.setMessageDetail("Fax Has Been Initiated Successfully");
                            returnValue.setData((Object)filename);
                            logger.info(returnValue.getMessageDetail());
                            logger.info(" user: {}, Command Initiated Successfully: {}", (Object)callie_softFax, (Object)command);
                        }
                    } else {
                        String rluCode = this.controlRluServerService.getRluCodeFinal(caller_phone);
                        String sofiaProfile = this.controlRluServerService.getProfileName(caller_phone);
                        String ipFeatureServer = this.controlRluServerService.getFeatureServerIp(rluCode);
                        for (String callie_softFax : extensions) {
                            logger.info("Send fax Caller Phone : {} Caller Soft Fax : {} Callee Soft Fax : {} Profile : {} ipFeatureServer : {} sbcUserPort : {} location : {} filename : {}", (Object)caller_phone, (Object)caller_softFax, (Object)callie_softFax, (Object)sofiaProfile, (Object)ipFeatureServer, (Object)port, (Object)this.location, (Object)filename);
                            command = "originate {origination_caller_id_number=" + caller_phone + ",coral_uc_callerid=" + caller_phone + ",coral_uc_calleeid=" + callie_softFax + ",coral_app=SendFax,fax_ident=" + caller_softFax + ",fax_header=softfax,absolute_codec_string='PCMU,PCMA'}sofia/" + sofiaProfile + "/" + callie_softFax.trim() + "@" + ipFeatureServer + ":" + port + " &txfax(" + this.location + "/" + filename.trim() + ")";
                            SendFaxDetails sendFaxDetails = new SendFaxDetails();
                            sendFaxDetails.setFromUser(caller_softFax);
                            sendFaxDetails.setCreatedOn(LocalDateTime.now());
                            sendFaxDetails.setCreatedBy(username);
                            sendFaxDetails.setToUser(this.extensionService.getAssignedUser(callie_softFax));
                            sendFaxDetails.setFileName(file.getOriginalFilename());
                            sendFaxDetails.setFileLocation(this.location);
                            sendFaxDetails.setFileType("image/tiff");
                            sendFaxDetails.setFullFilePath(this.location + "/" + filename + ".tif");
                            sendFaxDetails.setFileId(filename.substring(0, filename.lastIndexOf(".tif")));
                            sendFaxDetails.setLastStatus("");
                            sendFaxDetails.setCurrentStatus("");
                            this.sendFaxDetailsRepository.save((Object)sendFaxDetails);
                            this.telephonyCommand.executeCommandAndReturnStatus("freeswitch.api", "bgapi", command);
                            if (!returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                                returnValue.setStatus(returnValue.getStatus());
                                returnValue.setMessage(returnValue.getMessage());
                                returnValue.setMessageDetail(returnValue.getMessageDetail());
                                logger.error(returnValue.getMessageDetail());
                                return returnValue;
                            }
                            returnValue.setStatus(Constants.Error.OK);
                            returnValue.setMessage(" SuccessFul Initiation");
                            returnValue.setMessageDetail("Fax Has Been Initiated Successfully");
                            returnValue.setData((Object)filename);
                            logger.info(returnValue.getMessageDetail());
                            logger.info(" user: {}, Command Initiated Successfully: {}", (Object)callie_softFax, (Object)command);
                        }
                    }
                }
            } else {
                returnValue.setStatus(Constants.Error.BAD_INPUT_DATA);
                returnValue.setMessage("Can Not Upload The Image");
                returnValue.setMessageDetail(" Image Must Be Of Type 'tiff' ");
                logger.error(returnValue.getMessageDetail());
            }
        }
        catch (NullPointerException e) {
            returnValue.setStatus(Constants.Error.BAD_INPUT_DATA);
            returnValue.setMessage("File Can Not Be Empty");
            returnValue.setMessageDetail("kindly upload the 'tiff' Image");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable To Process");
            returnValue.setMessageDetail("Please Contact Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse emailTransfer(CustomEmailDetailModel attachment, Authentication authentication) {
        RequestResponse returnValue = new RequestResponse();
        String type = "fax";
        String fileId = attachment.getFileName().replace(".tif", "");
        fileId = this.sendFaxProgressService.getFileId(fileId);
        returnValue = this.emailDetailService.createEmailDetail(attachment, fileId, type, authentication);
        returnValue.setStatus(returnValue.getStatus());
        returnValue.setMessage(returnValue.getMessage());
        returnValue.setMessageDetail(returnValue.getMessageDetail());
        returnValue.setData(returnValue.getData());
        return returnValue;
    }

    public RequestResponse readFax(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<SendFaxProgress> addValue = new ArrayList<SendFaxProgress>();
        logger.info("list of message updated {}", (Object)data.getId());
        for (Long row : data.getId()) {
            Optional currentRecord = this.sendFaxProgressRepository.findById(row.intValue());
            if (!currentRecord.isPresent()) continue;
            SendFaxProgress dataToSave = (SendFaxProgress)currentRecord.get();
            dataToSave.setIsRead(Boolean.valueOf(true));
            addValue.add(dataToSave);
        }
        this.sendFaxProgressRepository.saveAll(addValue);
        returnValue.setMessage("Message Read");
        returnValue.setMessageDetail("successfully updated");
        logger.info(returnValue.getMessage(), (Object)returnValue.getMessageDetail());
        return returnValue;
    }

    public RequestResponse createFaxTransferDetailNew(FaxTransferDetailsModel data, Authentication authentication) {
        RequestResponse returnValue = new RequestResponse();
        List extensions = data.getExtension();
        ArrayList<String> ucUsers = new ArrayList<String>();
        if (extensions.size() == 0 || extensions.isEmpty() || data.getId() == null) {
            returnValue.setStatus(Constants.Error.BAD_INPUT_DATA);
            returnValue.setMessage("Data Can Not Be Transferred");
            returnValue.setMessageDetail("Users Must Be Selected For Transferring The fax ");
            logger.info(returnValue.getMessageDetail());
            return returnValue;
        }
        for (String destination : extensions) {
            SendFaxProgress sendFaxProgress = new SendFaxProgress();
            Optional currentFaxRecord = this.sendFaxProgressRepository.findById((Object)data.getId());
            if (currentFaxRecord.isPresent()) {
                Optional extension = this.extensionsRepository.findByExtension(destination);
                sendFaxProgress.setVariableCoralApp(((SendFaxProgress)currentFaxRecord.get()).getVariableCoralApp());
                sendFaxProgress.setVariableOtherLoopbackLegUuid(((SendFaxProgress)currentFaxRecord.get()).getVariableOtherLoopbackLegUuid());
                sendFaxProgress.setVariableLoopbackLeg(((SendFaxProgress)currentFaxRecord.get()).getVariableLoopbackLeg());
                sendFaxProgress.setVariableCallUuid(((SendFaxProgress)currentFaxRecord.get()).getVariableCallUuid());
                sendFaxProgress.setVariableCurrentApplication(((SendFaxProgress)currentFaxRecord.get()).getVariableCurrentApplication());
                sendFaxProgress.setVariableCurrentApplicationData(((SendFaxProgress)currentFaxRecord.get()).getVariableCurrentApplicationData());
                sendFaxProgress.setVariableFaxFilename(((SendFaxProgress)currentFaxRecord.get()).getVariableFaxFilename());
                sendFaxProgress.setFaxSuccess(((SendFaxProgress)currentFaxRecord.get()).getFaxSuccess());
                sendFaxProgress.setFaxResultCode(((SendFaxProgress)currentFaxRecord.get()).getFaxResultCode());
                sendFaxProgress.setFaxResultText(((SendFaxProgress)currentFaxRecord.get()).getFaxResultText());
                sendFaxProgress.setFaxDocumentTransferredPages(((SendFaxProgress)currentFaxRecord.get()).getFaxDocumentTransferredPages());
                sendFaxProgress.setFaxDocumentTotalPages(((SendFaxProgress)currentFaxRecord.get()).getFaxDocumentTotalPages());
                sendFaxProgress.setFaxImageResolution(((SendFaxProgress)currentFaxRecord.get()).getFaxImageResolution());
                sendFaxProgress.setFaxImageSize(((SendFaxProgress)currentFaxRecord.get()).getFaxImageSize());
                sendFaxProgress.setFaxBadRows(((SendFaxProgress)currentFaxRecord.get()).getFaxBadRows());
                sendFaxProgress.setFaxTransferRate(((SendFaxProgress)currentFaxRecord.get()).getFaxTransferRate());
                sendFaxProgress.setRemarks1(data.getRemarks());
                sendFaxProgress.setRemarks2(((SendFaxProgress)currentFaxRecord.get()).getRemarks2());
                sendFaxProgress.setFileId(((SendFaxProgress)currentFaxRecord.get()).getFileId());
                sendFaxProgress.setMailSent(((SendFaxProgress)currentFaxRecord.get()).getMailSent());
                sendFaxProgress.setNoOfTry(((SendFaxProgress)currentFaxRecord.get()).getNoOfTry());
                sendFaxProgress.setSourceUser(authentication.getName());
                if (extension.isPresent()) {
                    sendFaxProgress.setDestinationUser(((Extension)extension.get()).getAssignedUser());
                }
                sendFaxProgress.setIsNotified(Boolean.valueOf(false));
                sendFaxProgress.setIsRead(Boolean.valueOf(false));
                sendFaxProgress.setCreatedBy(((SendFaxProgress)currentFaxRecord.get()).getCreatedBy());
                sendFaxProgress.setCreatedOn(((SendFaxProgress)currentFaxRecord.get()).getCreatedOn());
                sendFaxProgress.setSwitchIpV4(((SendFaxProgress)currentFaxRecord.get()).getSwitchIpV4());
                sendFaxProgress.setEventDateLocal(LocalDateTime.now());
                sendFaxProgress.setEventDateTimestamp(((SendFaxProgress)currentFaxRecord.get()).getEventDateTimestamp());
                sendFaxProgress.setChannelCallUuid(UUID.randomUUID().toString());
                sendFaxProgress.setCallerOrigCallerIdNumber(((SendFaxProgress)currentFaxRecord.get()).getCallerOrigCallerIdNumber());
                sendFaxProgress.setCallerCalleeIdNumber(((SendFaxProgress)currentFaxRecord.get()).getCallerCalleeIdNumber());
                sendFaxProgress.setCallerAni(((SendFaxProgress)currentFaxRecord.get()).getCallerAni());
                sendFaxProgress.setCallerDestinationNumber(((SendFaxProgress)currentFaxRecord.get()).getCallerDestinationNumber());
                sendFaxProgress.setCallerUniqueId(((SendFaxProgress)currentFaxRecord.get()).getCallerUniqueId());
                sendFaxProgress.setCallerContext(((SendFaxProgress)currentFaxRecord.get()).getCallerContext());
                this.sendFaxProgressRepository.save((Object)sendFaxProgress);
                ucUsers.add(((Extension)extension.get()).getAssignedUser());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("FaxTransferDetails Created");
                returnValue.setMessageDetail("Fax Transferred Successfully");
                logger.info(returnValue.getMessageDetail());
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("selected records Not present");
            }
            this.ucNotificationService.updateFaxCount(ucUsers);
        }
        return returnValue;
    }

    public RequestResponse deleteNotification(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Long ids : data.getId()) {
            Optional currentRecord = this.sendFaxProgressRepository.findById(ids.intValue());
            if (!currentRecord.isPresent()) continue;
            addValue.add(currentRecord.get());
        }
        this.sendFaxProgressRepository.deleteAll(addValue);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("message deleted");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

