/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.config;

import com.coraltele.db.telemetry.coralnms.entity.Location;
import com.coraltele.db.telemetry.main.entity.CategoryService;
import com.coraltele.db.telemetry.main.entity.MonitorService;
import java.util.HashMap;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(basePackages={"com.coraltele.db.telemetry.coralnms.repository", "com.coraltele.db.telemetry.main.repository"}, entityManagerFactoryRef="telemetryEntityManagerFactory", transactionManagerRef="telemetryTransactionManager")
public class TelemetryDataSourceConfiguration {
    @Bean
    @ConfigurationProperties(value="spring.datasource.telemetry")
    public DataSourceProperties telemetryDataSourceProperties() {
        return new DataSourceProperties();
    }

    @Bean
    public DataSource telemetryDataSource(@Qualifier(value="telemetryDataSourceProperties") DataSourceProperties telemetryDataSourceProperties) {
        return this.telemetryDataSourceProperties().initializeDataSourceBuilder().build();
    }

    @Bean(name={"telemetryEntityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean telemetryEntityManagerFactory(@Qualifier(value="telemetryDataSource") DataSource telemetryDataSource, EntityManagerFactoryBuilder builder) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("hibernate.dialect", "org.hibernate.spatial.dialect.postgis.PostgisDialect");
        properties.put("hibernate.hbm2ddl.auto", "none");
        properties.put("hibernate.show_sql", "true");
        return builder.dataSource(telemetryDataSource).packages(new Class[]{Location.class, MonitorService.class, CategoryService.class}).properties(properties).build();
    }

    @Bean
    public PlatformTransactionManager telemetryTransactionManager(@Qualifier(value="telemetryEntityManagerFactory") LocalContainerEntityManagerFactoryBean entityManagerFactory) {
        return new JpaTransactionManager(entityManagerFactory.getObject());
    }

    @Bean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

    @Bean(name={"telemetryJdbcTemplate"})
    public JdbcTemplate telemetryJdbcTemplate(@Qualifier(value="telemetryDataSource") DataSource telemetryDataSource) {
        return new JdbcTemplate(telemetryDataSource);
    }
}

