/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.user.model.MultiUserRoleModel;
import com.coraltele.service.user.model.UserRoleModel;
import com.coraltele.service.user.service.UserRoleService;
import java.security.Principal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/userRole"})
@RestController
public class UserRoleController {
    @Autowired
    private UserRoleService userRoleService;

    @PostMapping(value={"/user/{id}"})
    public ResponseEntity<RequestResponse> getUserRole(@PathVariable(value="id") int userId) {
        RequestResponse returnValue = this.userRoleService.rolesAgainstUser(userId);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/role/{id}"})
    public ResponseEntity<RequestResponse> getRoleUsers(@PathVariable(value="id") int roleId) {
        RequestResponse returnValue = this.userRoleService.usersAgainstRole(roleId);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> addUserRole(@RequestBody UserRoleModel data, Principal principal) {
        RequestResponse returnValue = this.userRoleService.createUserRole(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/multiCreate"})
    public ResponseEntity<RequestResponse> createMultiple(@RequestBody MultiUserRoleModel data, Principal principal) {
        RequestResponse returnValue = this.userRoleService.createMultipleUserRole(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllUserRoleByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.userRoleService.getAllUserRoleByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteUser(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.userRoleService.deleteUserRole(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll/taskManager"})
    public ResponseEntity<RequestResponse> getAllTaskManager() {
        RequestResponse returnValue = this.userRoleService.getAllTaskManager();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll/user"})
    public ResponseEntity<RequestResponse> getAllUserRole() {
        RequestResponse returnValue = this.userRoleService.getAllUserRole();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll/users"})
    public ResponseEntity<RequestResponse> getUsersExcludingAdmin() {
        RequestResponse returnValue = this.userRoleService.getAllUsersExcludingRoleAdmin();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

