/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.uc.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.billing.main.notification.service.NotificationService;
import com.coraltele.service.billing.main.voicemail_msgs.model.VoicemailTransferModel;
import com.coraltele.service.pbx.emailDetail.model.CustomEmailDetailModel;
import com.coraltele.service.uc.service.UCService;
import com.coraltele.service.uc.service.VoicemailService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.MessageFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/voicemail"})
@RestController
public class VoicemailController {
    private static final Logger logger = LogManager.getLogger(VoicemailController.class);
    private static final String CONTROLLER_NAME = "Voicemail";
    @Autowired
    UCService ucService;
    @Autowired
    VoicemailService voicemailService;
    @Autowired
    NotificationService notificationService;

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getList(Authentication authentication, @RequestBody SearchRequest searchRequest) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String dataReceived = objectMapper.writeValueAsString((Object)searchRequest);
            String message = MessageFormat.format("{1} create : {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            RequestResponse returnValue = this.voicemailService.getAllVoiceMail(searchRequest, authentication);
            if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                message = MessageFormat.format("{1} data processed successfully for getting list : {0}", CONTROLLER_NAME, dataReceived);
                logger.info(message);
                return ResponseEntity.ok((Object)returnValue);
            }
            message = MessageFormat.format("{1} unable to process data for getting list: {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (JsonProcessingException e) {
            RequestResponse returnValue = new RequestResponse();
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Invalid json data");
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/transfer"})
    public ResponseEntity<RequestResponse> createVMTransferDetails(Authentication authentication, @RequestBody VoicemailTransferModel data) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String dataReceived = objectMapper.writeValueAsString((Object)data);
            String message = MessageFormat.format("{1} create : {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            RequestResponse returnValue = this.voicemailService.voiceMailTransfer(data, authentication);
            if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                message = MessageFormat.format("{1} data processed successfully for creation : {0}", CONTROLLER_NAME, dataReceived);
                logger.info(message);
                return ResponseEntity.ok((Object)returnValue);
            }
            message = MessageFormat.format("{1} unable to process data for creation: {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (JsonProcessingException e) {
            RequestResponse returnValue = new RequestResponse();
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Invalid json data");
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateNotification(@RequestBody InputIdModel data) {
        RequestResponse returnValue = this.voicemailService.readVoicemail(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteData(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.voicemailService.deleteVoicemail(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/unLoggedUser/list"})
    public ResponseEntity<RequestResponse> getUnLoggedUser(Authentication authentication) {
        RequestResponse returnValue = this.voicemailService.getUnLoggedUser(authentication.getName());
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/mailTransfer"})
    public ResponseEntity<RequestResponse> create(@RequestBody CustomEmailDetailModel data, Authentication authentication) {
        RequestResponse returnValue = this.voicemailService.emailTransfer(data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

