/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.userWidget.master.service;

import com.coraltele.db.telemetry.coralnms.entity.WidgetType;
import com.coraltele.db.telemetry.coralnms.repository.WidgetTypeRepository;
import com.coraltele.db.telemetry.main.entity.UserWidget;
import com.coraltele.db.telemetry.main.repository.UserWidgetRepository;
import com.coraltele.db.telemetry.main.specification.UserWidgetSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.userWidget.master.model.UserWidgetModel;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class UserWidgetService {
    private static final Logger logger = LogManager.getLogger(UserWidgetService.class);
    @Autowired
    UserWidgetRepository userWidgetRepository;
    @Autowired
    WidgetTypeRepository widgetTypeRepository;

    public RequestResponse createData(UserWidgetModel data, Principal principal) {
        logger.debug("Create New userWidget : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            UserWidget userWidget = new UserWidget();
            userWidget.setApiURL(data.getApiURL());
            userWidget.setChartType(data.getChartType());
            userWidget.setLegendField(data.getLegendField());
            userWidget.setLegendFieldDataType(data.getLegendFieldDataType());
            userWidget.setName(data.getName());
            userWidget.setRefreshInterval(data.getRefreshInterval());
            userWidget.setSensorAttribute(data.getSensorAttribute());
            userWidget.setValueField(data.getValueField());
            userWidget.setValueFieldDataType(data.getValueFieldDataType());
            userWidget.setHasWebSocketUpdate(data.getHasWebSocketUpdate());
            if (data.getWidgetType() != null) {
                userWidget.setWidgetType(this.getWidgetType(data.getWidgetType()));
            }
            userWidget.setMetricsDataDuration(data.getMetricsDataDuration());
            userWidget.setMetricsName(data.getMetricsName());
            userWidget.setCategory(data.getCategory());
            userWidget.setUuid(UUID.randomUUID().toString());
            userWidget.setCreatedBy(principal.getName());
            userWidget.setCreatedOn(LocalDateTime.now());
            userWidget.setEnabled(Boolean.valueOf(data.getEnabled() != null ? data.getEnabled() : false));
            userWidget.setDashboardLayout(data.getDashboardLayout());
            List username = this.userWidgetRepository.findByCreatedBy(principal.getName());
            if (!username.isEmpty()) {
                for (UserWidget code : username) {
                    if (!code.getCode().equals(data.getCode())) {
                        userWidget.setCode(data.getCode());
                        continue;
                    }
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("Code Already Present For The Current User");
                    returnValue.setMessageDetail("Please Enter Different Code");
                    return returnValue;
                }
            }
            this.userWidgetRepository.save((Object)userWidget);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("UserWidget created successfully");
            returnValue.setData((Object)userWidget.getUuid());
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create UserWidget");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(UserWidgetModel data, Principal principal) {
        logger.debug("Update UserWidget {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional userWidget = this.userWidgetRepository.findById((Object)data.getId());
        if (!userWidget.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not found");
            returnValue.setMessageDetail("UserWidget Not Found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getApiURL() != null) {
            ((UserWidget)userWidget.get()).setApiURL(data.getApiURL());
        }
        if (data.getCategory() != null) {
            ((UserWidget)userWidget.get()).setCategory(data.getCategory());
        }
        if (data.getChartType() != null) {
            ((UserWidget)userWidget.get()).setChartType(data.getChartType());
        }
        if (data.getHasWebSocketUpdate() != null) {
            ((UserWidget)userWidget.get()).setHasWebSocketUpdate(data.getHasWebSocketUpdate());
        }
        if (data.getLegendField() != null) {
            ((UserWidget)userWidget.get()).setLegendField(data.getLegendField());
        }
        if (data.getLegendFieldDataType() != null) {
            ((UserWidget)userWidget.get()).setLegendFieldDataType(data.getLegendFieldDataType());
        }
        if (data.getMetricsDataDuration() != null) {
            ((UserWidget)userWidget.get()).setMetricsDataDuration(data.getMetricsDataDuration());
        }
        if (data.getMetricsName() != null) {
            ((UserWidget)userWidget.get()).setMetricsName(data.getMetricsName());
        }
        if (data.getName() != null) {
            ((UserWidget)userWidget.get()).setName(data.getName());
        }
        if (data.getRefreshInterval() != null) {
            ((UserWidget)userWidget.get()).setRefreshInterval(data.getRefreshInterval());
        }
        if (data.getSensorAttribute() != null) {
            ((UserWidget)userWidget.get()).setSensorAttribute(data.getSensorAttribute());
        }
        if (data.getValueField() != null) {
            ((UserWidget)userWidget.get()).setValueField(data.getValueField());
        }
        if (data.getValueFieldDataType() != null) {
            ((UserWidget)userWidget.get()).setValueFieldDataType(data.getValueFieldDataType());
        }
        if (data.getDashboardLayout() != null) {
            ((UserWidget)userWidget.get()).setDashboardLayout(data.getDashboardLayout());
        }
        if (data.getWidgetType() != null) {
            ((UserWidget)userWidget.get()).setWidgetType(this.getWidgetType(data.getWidgetType()));
        }
        if (data.getEnabled() != null) {
            ((UserWidget)userWidget.get()).setEnabled(data.getEnabled());
        }
        if (data.getCode() != null) {
            List existingUserWidgets = this.userWidgetRepository.findByCodeAndCreatedBy(data.getCode(), principal.getName());
            existingUserWidgets.removeIf(widget -> widget.getId().equals(data.getId()));
            if (!existingUserWidgets.isEmpty()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Code Already Present For The Current User");
                returnValue.setMessageDetail("Please Enter Different Code");
                return returnValue;
            }
            ((UserWidget)userWidget.get()).setCode(data.getCode());
        }
        this.userWidgetRepository.save(userWidget.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("UserWidget Updated Successfully");
        returnValue.setData((Object)((UserWidget)userWidget.get()).getUuid());
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteUserWidgetById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional userWidget = this.userWidgetRepository.findById((Object)ids);
            if (userWidget.isPresent()) {
                addValue.add(userWidget.get());
                this.userWidgetRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllUserWidgetByFilter(SearchRequest searchRequestData, String currentUser) {
        RequestResponse returnValue = new RequestResponse();
        Optional widgetTypeData = this.widgetTypeRepository.findById(Integer.valueOf(9));
        Specification filters = UserWidgetSpecification.generateFilters((SearchRequest)searchRequestData, (String)currentUser, (WidgetType)((WidgetType)widgetTypeData.get()));
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.userWidgetRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.userWidgetRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<UserWidgetModel> entityToModelConversion(List<UserWidget> userWidget) {
        ArrayList<UserWidgetModel> addValue = new ArrayList<UserWidgetModel>();
        for (UserWidget row : userWidget) {
            UserWidgetModel data = new UserWidgetModel();
            data.setId(row.getId());
            data.setApiURL(row.getApiURL());
            data.setChartType(row.getChartType());
            data.setLegendField(row.getLegendField());
            data.setLegendFieldDataType(row.getLegendFieldDataType());
            data.setName(row.getName());
            data.setRefreshInterval(row.getRefreshInterval());
            data.setSensorAttribute(row.getSensorAttribute());
            data.setValueFieldDataType(row.getValueFieldDataType());
            data.setValueField(row.getValueField());
            data.setCode(row.getCode());
            data.setHasWebSocketUpdate(row.getHasWebSocketUpdate());
            data.setWidgetType(row.getWidgetType().getId());
            data.setMetricsName(row.getMetricsName());
            data.setMetricsDataDuration(row.getMetricsDataDuration());
            data.setCategory(row.getCategory());
            data.setUuid(row.getUuid());
            data.setCreatedBy(row.getCreatedBy());
            data.setCreatedOn(row.getCreatedOn());
            data.setDashboardLayout(row.getDashboardLayout());
            data.setEnabled(row.getEnabled());
            addValue.add(data);
        }
        return addValue;
    }

    public WidgetType getWidgetType(Integer id) {
        Optional widgetTypeData = this.widgetTypeRepository.findById(id);
        if (widgetTypeData.isPresent()) {
            return (WidgetType)widgetTypeData.get();
        }
        return null;
    }
}

