/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.taskDetails.controller;

import com.coraltele.db.telemetry.main.entity.TaskDetails;
import com.coraltele.db.telemetry.main.repository.TaskDetailsRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.telemetry.main.taskDetails.model.TaskDetailsCreateModel;
import com.coraltele.service.telemetry.main.taskDetails.model.TaskDetailsModel;
import com.coraltele.service.telemetry.main.taskDetails.service.TaskDetailsService;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/taskDetails"})
public class TaskDetailsController {
    private static final Logger logger = LogManager.getLogger(TaskDetailsController.class);
    @Autowired
    private TaskDetailsService taskDetailsService;
    @Autowired
    private TaskDetailsRepository taskDetailsRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    private static final Map<String, String> columnMappings = new HashMap();
    private static final List<String> COLUMN_ORDER;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> createTaskDetail(@RequestBody TaskDetailsCreateModel taskDetailsModel, Principal principal) {
        RequestResponse returnValue = this.taskDetailsService.createTaskDetail(taskDetailsModel, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getAllTaskDetails() {
        RequestResponse returnValue = this.taskDetailsService.getAllTaskDetails();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll/{taskId}"})
    public ResponseEntity<RequestResponse> getByTaskId(@PathVariable(value="taskId") Integer taskId) {
        RequestResponse returnValue = this.taskDetailsService.getByTaskId(taskId);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateTaskDetails(@RequestBody TaskDetailsModel taskDetailsModel, Principal principal) {
        RequestResponse returnValue = this.taskDetailsService.updateTaskDetails(taskDetailsModel, principal);
        return returnValue.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)returnValue) : new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteTaskDetails(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.taskDetailsService.deleteTaskDetails(id);
        return returnValue.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)returnValue) : new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getFilterTaskDetails(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.taskDetailsService.getFilterTaskDetails(searchRequest);
        return returnValue.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)returnValue) : new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSV/{taskId}"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSVForCallerCall(@PathVariable(value="taskId") Integer taskId) {
        try {
            logger.info("CSV file download started for TaskId: {}", (Object)taskId);
            List filteredData = this.taskDetailsRepository.findByTaskId(taskId);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                List headers = COLUMN_ORDER.stream().map(columnMappings::get).collect(Collectors.toList());
                csvPrinter.printRecord(headers);
                for (TaskDetails task : filteredData) {
                    ArrayList<String> values = new ArrayList<String>();
                    for (String column : COLUMN_ORDER) {
                        values.add(this.getColumnValueForCallerCall(task, column));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            byte[] csvBytes = stringWriter.toString().getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "task_" + taskId + ".csv");
            logger.info("CSV generated successfully for TaskId: {}", (Object)taskId);
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            logger.error("Error while downloading CSV for TaskId {}", (Object)taskId, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private String getColumnValueForCallerCall(TaskDetails task, String columnName) {
        switch (columnName) {
            case "taskStats": {
                return this.checkNull((Object)task.getTaskStats());
            }
            case "statusUpdatedBy": {
                return this.checkNull((Object)task.getStatusUpdatedBy());
            }
            case "statusUpdatedOn": {
                return this.checkNull((Object)DateFormatUtility.epochToLocalDateTimeAsStringToHandleNull((Long)task.getStatusUpdatedOn()));
            }
            case "changedCompletionOn": {
                return this.checkNull((Object)task.getChangedCompletionOn());
            }
            case "remarks": {
                return this.checkNull((Object)task.getRemarks());
            }
        }
        return "";
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }

    static {
        columnMappings.put("taskStats", "Task Status");
        columnMappings.put("statusUpdatedBy", "Status Updated By");
        columnMappings.put("statusUpdatedOn", "Status Updated On");
        columnMappings.put("changedCompletionOn", "Changed Date");
        columnMappings.put("remarks", "Remarks");
        COLUMN_ORDER = Arrays.asList("taskStats", "statusUpdatedBy", "statusUpdatedOn", "changedCompletionOn", "remarks");
    }
}

