/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.taskType.service;

import com.coraltele.db.telemetry.coralnms.repository.CategoryRepository;
import com.coraltele.db.telephony.pbx.entity.TaskType;
import com.coraltele.db.telephony.pbx.repository.TaskTypeRepository;
import com.coraltele.db.telephony.pbx.specification.TaskTypeSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.taskType.model.TaskTypeModel;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class TaskTypeService {
    private static final Logger logger = LogManager.getLogger(TaskTypeService.class);
    @Autowired
    TaskTypeRepository taskTypeRepository;
    @Autowired
    CategoryRepository categoryRepository;

    public RequestResponse createTaskType(TaskTypeModel data, Principal principal) {
        logger.debug("Creating new task type: {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            TaskType taskType = new TaskType();
            taskType.setTaskType(data.getTaskType());
            taskType.setCreatedOn(LocalDateTime.now());
            taskType.setCreatedBy(principal.getName());
            this.taskTypeRepository.save((Object)taskType);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Task type registered successfully");
            logger.info("Task type saved: {}", (Object)returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to create task type");
            returnValue.setMessageDetail("Contact the administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getAllTaskType() {
        List list = (List)this.taskTypeRepository.findAll();
        List categories = this.categoryRepository.findAll();
        ArrayList<TaskTypeModel> addValue = new ArrayList<TaskTypeModel>();
        RequestResponse returnValue = new RequestResponse();
        Integer serialId = 1;
        for (TaskType taskType : list) {
            TaskTypeModel data = new TaskTypeModel();
            Integer n = serialId;
            Integer n2 = serialId = Integer.valueOf(serialId + 1);
            data.setId(n);
            data.setTaskType(taskType.getTaskType());
            data.setCreatedBy(taskType.getCreatedBy());
            data.setCreatedOn(taskType.getCreatedOn());
            data.setUpdatedBy(taskType.getUpdatedBy());
            data.setUpdatedOn(taskType.getUpdatedOn());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Size of list:" + addValue.size());
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteTaskType(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional task = this.taskTypeRepository.findById((Object)ids);
            if (task.isPresent()) {
                addValue.add(task.get());
                this.taskTypeRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessage("Record Not Found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateTaskType(TaskTypeModel data, Principal principal) {
        logger.debug("Updating TaskType: {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional taskTypeOptional = this.taskTypeRepository.findById((Object)data.getId());
            if (taskTypeOptional.isPresent()) {
                TaskType taskType = (TaskType)taskTypeOptional.get();
                if (data.getTaskType() != null) {
                    taskType.setTaskType(data.getTaskType());
                }
                taskType.setUpdatedBy(principal.getName());
                taskType.setUpdatedOn(LocalDateTime.now());
                this.taskTypeRepository.save((Object)taskType);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Task type updated successfully");
                returnValue.setMessageDetail("Task type details updated successfully");
                logger.info("Task type updated successfully: {}", (Object)data.getId());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Task type not found");
                returnValue.setMessageDetail("No task type found with the given ID");
                logger.info("No task type found with ID: {}", (Object)data.getId());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to update task type");
            returnValue.setMessageDetail("Please contact the administrator");
            logger.error("Error while updating task type.", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getFilterTaskTypes(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = TaskTypeSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.taskTypeRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.taskTypeRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

