/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.pForkExtension.service;

import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.entity.PForkExtension;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.telephony.pbx.repository.PForkExtensionRepository;
import com.coraltele.db.telephony.pbx.specification.PForkExtensionSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.extension.model.ExtensionCreateModel;
import com.coraltele.service.pbx.fwdExtension.model.FwdExtConversionModel;
import com.coraltele.service.pbx.fwdExtension.model.FwdExtDExtDayWiseModel;
import com.coraltele.service.pbx.fwdExtension.model.FwdExtModel;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PForkExtensionService {
    private static final Logger logger = LogManager.getLogger(PForkExtensionService.class);
    @Autowired
    PForkExtensionRepository pForkExtensionRepository;
    @Autowired
    private ExtensionsRepository extensionsRepository;

    public RequestResponse createData(FwdExtModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        if (!StringUtils.hasText((String)data.getExtension()) || !StringUtils.hasText((String)data.getForwardExtension()) || data.getFromTime().equals("null")) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Improper data on creation");
            returnValue.setMessageDetail("Missing parameter either extension or fwdExtension or time");
            logger.error(returnValue.getMessageDetail());
            return returnValue;
        }
        if (data.getExtension().equals(data.getForwardExtension())) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Both extension have same");
            returnValue.setMessageDetail("Select different extension for call forward");
            logger.error(returnValue.getMessageDetail());
            return returnValue;
        }
        try {
            if (!this.checkExistingData(data)) {
                PForkExtension record = new PForkExtension();
                record.setCreatedBy(principal.getName());
                record.setCreatedOn(LocalDateTime.now());
                record.setExtension(data.getExtension());
                record.setMonday(Integer.valueOf(data.getMonday() != null ? 1 : 0));
                record.setTuesday(Integer.valueOf(data.getTuesday() != null ? 1 : 0));
                record.setThursday(Integer.valueOf(data.getThursday() != null ? 1 : 0));
                record.setWednesday(Integer.valueOf(data.getWednesday() != null ? 1 : 0));
                record.setFriday(Integer.valueOf(data.getFriday() != null ? 1 : 0));
                record.setSaturday(Integer.valueOf(data.getSaturday() != null ? 1 : 0));
                record.setSunday(Integer.valueOf(data.getSunday() != null ? 1 : 0));
                record.setFromTime(data.getFromTime());
                record.setToTime(data.getToTime());
                record.setForwardExtension(data.getForwardExtension());
                this.pForkExtensionRepository.save((Object)record);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("OK");
                returnValue.setMessageDetail("New fwdExtension Created Successfully");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("selected extension of same day and time already exist");
                returnValue.setMessageDetail("select different time or day");
                logger.error(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create data");
            returnValue.setMessageDetail("Contact With administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public boolean checkExistingData(FwdExtModel data) {
        List records = new ArrayList();
        if (data.getMonday() != null && data.getMonday().equals(1)) {
            records = this.pForkExtensionRepository.findByExtensionAndMonday(data.getExtension(), Integer.valueOf(1));
        } else if (data.getTuesday() != null && data.getTuesday().equals(1)) {
            records = this.pForkExtensionRepository.findByExtensionAndTuesday(data.getExtension(), Integer.valueOf(1));
        } else if (data.getWednesday() != null && data.getWednesday().equals(1)) {
            records = this.pForkExtensionRepository.findByExtensionAndWednesday(data.getExtension(), Integer.valueOf(1));
        } else if (data.getThursday() != null && data.getThursday().equals(1)) {
            records = this.pForkExtensionRepository.findByExtensionAndThursday(data.getExtension(), Integer.valueOf(1));
        } else if (data.getFriday() != null && data.getFriday().equals(1)) {
            records = this.pForkExtensionRepository.findByExtensionAndFriday(data.getExtension(), Integer.valueOf(1));
        } else if (data.getSaturday() != null && data.getSaturday().equals(1)) {
            records = this.pForkExtensionRepository.findByExtensionAndSaturday(data.getExtension(), Integer.valueOf(1));
        } else if (data.getSunday() != null && data.getSunday().equals(1)) {
            records = this.pForkExtensionRepository.findByExtensionAndSunday(data.getExtension(), Integer.valueOf(1));
        }
        for (PForkExtension row : records) {
            if (!data.getFromTime().equals(row.getFromTime()) && !data.getFromTime().equals(row.getToTime()) && !data.getToTime().equals(row.getFromTime()) && !data.getToTime().equals(row.getToTime()) && (!data.getFromTime().isBefore(row.getToTime()) || !data.getToTime().isAfter(row.getFromTime()))) continue;
            return true;
        }
        return false;
    }

    public RequestResponse update(FwdExtModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        Optional fwdExt = this.pForkExtensionRepository.findById((Object)data.getId());
        if (!fwdExt.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("Data Not Found");
            logger.error(returnValue.getMessage());
            return returnValue;
        }
        if (data.getForwardExtension() != null) {
            ((PForkExtension)fwdExt.get()).setForwardExtension(data.getForwardExtension());
        }
        if (data.getFromTime() != null) {
            ((PForkExtension)fwdExt.get()).setFromTime(data.getFromTime());
        }
        if (data.getToTime() != null) {
            ((PForkExtension)fwdExt.get()).setToTime(data.getToTime());
        }
        ((PForkExtension)fwdExt.get()).setUpdatedBy(principal.getName());
        ((PForkExtension)fwdExt.get()).setUpdatedOn(LocalDateTime.now());
        this.pForkExtensionRepository.save(fwdExt.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("Updated Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getListByDayAndExt(String day, String extension) {
        List fwdExt;
        RequestResponse returnValue = new RequestResponse();
        ArrayList<FwdExtDExtDayWiseModel> response = new ArrayList<FwdExtDExtDayWiseModel>();
        if (day.equalsIgnoreCase("Sunday")) {
            fwdExt = this.pForkExtensionRepository.findByExtensionAndSunday(extension, Integer.valueOf(1));
        } else if (day.equalsIgnoreCase("Monday")) {
            fwdExt = this.pForkExtensionRepository.findByExtensionAndMonday(extension, Integer.valueOf(1));
        } else if (day.equalsIgnoreCase("Tuesday")) {
            fwdExt = this.pForkExtensionRepository.findByExtensionAndTuesday(extension, Integer.valueOf(1));
        } else if (day.equalsIgnoreCase("Wednesday")) {
            fwdExt = this.pForkExtensionRepository.findByExtensionAndWednesday(extension, Integer.valueOf(1));
        } else if (day.equalsIgnoreCase("Thursday")) {
            fwdExt = this.pForkExtensionRepository.findByExtensionAndThursday(extension, Integer.valueOf(1));
        } else if (day.equalsIgnoreCase("Friday")) {
            fwdExt = this.pForkExtensionRepository.findByExtensionAndFriday(extension, Integer.valueOf(1));
        } else if (day.equalsIgnoreCase("Saturday")) {
            fwdExt = this.pForkExtensionRepository.findByExtensionAndSaturday(extension, Integer.valueOf(1));
        } else {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid Day");
            returnValue.setMessageDetail("The provided day is not valid.");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (fwdExt.isEmpty()) {
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("No Data Found");
            returnValue.setMessageDetail("No Forward Extensions found for the given day and extension.");
            returnValue.setData(Collections.emptyList());
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        for (PForkExtension row : fwdExt) {
            FwdExtDExtDayWiseModel data = new FwdExtDExtDayWiseModel();
            data.setId(row.getId());
            data.setFromTime(row.getFromTime());
            data.setToTime(row.getToTime());
            data.setForwardExtension(row.getForwardExtension());
            response.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("list of records");
        returnValue.setData(response);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional fwdData = this.pForkExtensionRepository.findById((Object)ids);
            if (fwdData.isPresent()) {
                addValue.add(fwdData.get());
                this.pForkExtensionRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAcdPickUpGroup(List<String> extTypeList) {
        RequestResponse returnValue = new RequestResponse();
        logger.info("get list of extension by extensionType:{}", extTypeList);
        List list = this.extensionsRepository.findByExtensionTypeIn(extTypeList);
        ArrayList<ExtensionCreateModel> addValue = new ArrayList<ExtensionCreateModel>();
        for (Extension data : list) {
            ExtensionCreateModel extension = new ExtensionCreateModel();
            extension.setId(data.getId());
            extension.setABarTimeout(data.getABarTimeout());
            extension.setAccountCode(data.getAccountCode());
            extension.setAcdCallback(data.getAcdCallback());
            extension.setAcdPickupGroup(data.getAcdPickupGroup());
            extension.setAlertInfo(data.getAlertInfo());
            extension.setAnonymousCallRejection(data.getAnonymousCallRejection());
            extension.setApplicationId(data.getApplicationId());
            extension.setAutoLift(data.getAutoLift());
            extension.setBrowserExt(data.getBrowserExt());
            extension.setBusyReleaseInterval(data.getBusyReleaseInterval());
            extension.setCFNATime(data.getCFNATime());
            extension.setCallContext(data.getCallContext());
            extension.setCallForwardNumber(data.getCallForwardNumber());
            extension.setCallTrace(data.getCallTrace());
            extension.setCallWaitingStatus(data.getCallWaitingStatus());
            extension.setCallerIdStatus(data.getCallerIdStatus());
            extension.setCallerOverrideToHoldParty(data.getCallerOverrideToHoldParty());
            extension.setCallerStrip(data.getCallerStrip());
            extension.setCampOnHoldMusic(data.getCampOnHoldMusic());
            extension.setCampOnRetryInterval(data.getCampOnRetryInterval());
            extension.setCanBroadcast(data.getCanBroadcast());
            extension.setCanMulticast(data.getCanMulticast());
            extension.setCheckIn(data.getCheckIn());
            extension.setCheckInEpoch(data.getCheckInEpoch());
            extension.setChimeInterval(data.getChimeInterval());
            extension.setChimePath(data.getChimePath());
            extension.setCodeBlueSentSmsConfig(data.getCodeBlueSentSmsConfig());
            extension.setCollaboration(data.getCollaboration());
            extension.setColumn1(data.getColumn1());
            extension.setColumn2(data.getColumn2());
            extension.setColumn3(data.getColumn3());
            extension.setColumn4(data.getColumn4());
            extension.setColumn5(data.getColumn5());
            extension.setColumn6(data.getColumn6());
            extension.setColumn7(data.getColumn7());
            extension.setColumn8(data.getColumn8());
            extension.setColumn9(data.getColumn9());
            extension.setColumn10(data.getColumn10());
            extension.setColumn11(data.getColumn11());
            extension.setColumn12(data.getColumn12());
            extension.setColumn13(data.getColumn13());
            extension.setColumn14(data.getColumn14());
            extension.setColumn15(data.getColumn15());
            extension.setColumn16(data.getColumn16());
            extension.setConfPwd(data.getConfPwd());
            extension.setConferenceMode(data.getConferenceMode());
            extension.setConfigEmailId(data.getConfigEmailId());
            extension.setConfirmationWavFile(data.getConfirmationWavFile());
            extension.setControlName(data.getControlName());
            extension.setCoralAcdCallType(data.getCoralAcdCallType());
            extension.setCurrentChannel(data.getCurrentChannel());
            extension.setCustomeDestination(data.getCustomeDestination());
            extension.setExtension(data.getExtension());
            extension.setExtensionType(data.getExtensionType());
            extension.setName(data.getName());
            extension.setCFNATime(data.getCFNATime());
            extension.setVideoCall(data.getVideoCall());
            extension.setWavFilename(data.getWavFilename());
            extension.setPCMA(data.getPCMA());
            extension.setPCMU(data.getPCMU());
            extension.setG722(data.getG722());
            extension.setG726(data.getG726());
            extension.setG729(data.getG729());
            extension.setG723(data.getG723());
            extension.setOpus(data.getOpus());
            extension.setVp8(data.getVp8());
            extension.setH263(data.getH263());
            extension.setH264(data.getH264());
            extension.setDayInboundCos(data.getDayInboundCos());
            extension.setNightInboundCos(data.getNightInboundCos());
            extension.setDayOutboundCos(data.getDayOutboundCos());
            extension.setNightOutboundCos(data.getNightOutboundCos());
            extension.setSecondaryDayInboundCos(data.getSecondaryDayInboundCos());
            extension.setSecondaryDayOutboundCos(data.getSecondaryDayOutboundCos());
            extension.setSecondaryNightInboundCos(data.getSecondaryNightInboundCos());
            extension.setSecondaryNightOutboundCos(data.getSecondaryNightOutboundCos());
            extension.setPrimaryDayInboundCos(data.getPrimaryDayInboundCos());
            extension.setPrimaryDayOutboundCos(data.getPrimaryDayOutboundCos());
            extension.setIMEINumber(data.getIMEINumber());
            extension.setTimeOutInSecond(data.getTimeOutInSecond());
            extension.setRingTime(data.getRingTime());
            extension.setCompany(data.getCompany());
            extension.setDepartment(data.getDepartment());
            extension.setDesignation(data.getDesignation());
            extension.setSecretary(data.getSecretary());
            extension.setCollaboration(data.getCollaboration());
            extension.setAccountCode(data.getAccountCode());
            extension.setData(data.getData());
            extension.setExtGroupId(data.getExtGroupId());
            extension.setPforkStr(data.getPforkStr());
            extension.setRecord(data.getRecord());
            extension.setEmailId(data.getEmailId());
            extension.setRluCode(data.getRluCode());
            extension.setCallWaitingStatus(data.getCallWaitingStatus());
            extension.setRingBackTone(data.getRingBackTone());
            extension.setGroupCode(data.getGroupCode());
            extension.setIsCampOnMode(data.getIsCampOnMode());
            extension.setCallTransferToVm(data.getCallTransferToVm());
            extension.setWelcomeGreeting(data.getWelcomeGreeting());
            extension.setOverflowToBoss(data.getOverflowToBoss());
            extension.setSplitRecordingFileInMinutes(data.getSplitRecordingFileInMinutes());
            extension.setPhoneStatus(data.getPhoneStatus());
            extension.setDayMode(data.getDayMode());
            extension.setNightMode(data.getNightMode());
            extension.setNonworkingData(data.getNonworkingData());
            extension.setNonworkingApp(data.getNonworkingApp());
            extension.setManufacturerId(data.getManufacturerId());
            extension.setModelDetailId(data.getModelDetailId());
            extension.setPersonalVmGreeting(data.getPersonalVmGreeting());
            extension.setMacId(data.getMacId());
            extension.setSrtP(data.getSrtP());
            extension.setZrtP(data.getZrtP());
            if (data.getDSun() != null && data.getDSun() != 0) {
                extension.setDSun(Boolean.valueOf(true));
            } else {
                extension.setDSun(Boolean.valueOf(false));
            }
            if (data.getDMon() != null && data.getDMon() != 0) {
                extension.setDMon(Boolean.valueOf(true));
            } else {
                extension.setDMon(Boolean.valueOf(false));
            }
            if (data.getDTue() != null && data.getDTue() != 0) {
                extension.setDTue(Boolean.valueOf(true));
            } else {
                extension.setDTue(Boolean.valueOf(false));
            }
            if (data.getDWed() != null && data.getDWed() != 0) {
                extension.setDWed(Boolean.valueOf(true));
            } else {
                extension.setDWed(Boolean.valueOf(false));
            }
            if (data.getDThu() != null && data.getDThu() != 0) {
                extension.setDThu(Boolean.valueOf(true));
            } else {
                extension.setDThu(Boolean.valueOf(false));
            }
            if (data.getDFri() != null && data.getDFri() != 0) {
                extension.setDFri(Boolean.valueOf(true));
            } else {
                extension.setDFri(Boolean.valueOf(false));
            }
            if (data.getDSat() != null && data.getDSat() != 0) {
                extension.setDSat(Boolean.valueOf(true));
            } else {
                extension.setDSat(Boolean.valueOf(false));
            }
            extension.setFromTime(data.getFromTime());
            extension.setToTime(data.getToTime());
            extension.setFriFromTime(data.getFriFromTime());
            extension.setFriToTime(data.getFriToTime());
            extension.setFlexibleTimings(data.getFlexibleTimings());
            extension.setMonFromTime(data.getMonFromTime());
            extension.setMonToTime(data.getMonToTime());
            extension.setTueFromTime(data.getTueFromTime());
            extension.setTueToTime(data.getTueToTime());
            extension.setWedFromTime(data.getWedFromTime());
            extension.setWedToTime(data.getWedToTime());
            extension.setThuFromTime(data.getThuFromTime());
            extension.setThuToTime(data.getThuToTime());
            extension.setSatFromTime(data.getSatFromTime());
            extension.setSatToTime(data.getSatToTime());
            extension.setNightRingTime(data.getNightRingTime());
            extension.setXmpPId(data.getXmpPId());
            extension.setAssignedUser(data.getAssignedUser());
            extension.setSmsText(data.getSmsText());
            extension.setIsSent(data.getIsSent());
            extension.setNoOfRetry(data.getNoOfRetry());
            extension.setUrl(data.getUrl());
            extension.setDialNumber(data.getDialNumber());
            extension.setSmsNumber(data.getSmsNumber());
            extension.setStar(data.getStar());
            extension.setParkExpiryInterval(data.getParkExpiryInterval());
            extension.setDestinationStrip(data.getDestinationStrip());
            extension.setOutboundGatewayGroup(data.getOutboundGatewayGroup());
            extension.setMaxChannel(data.getMaxChannel());
            extension.setIsCliBaseRouting(data.getIsCliBaseRouting());
            extension.setIsCallCenterBased(data.getIsCallCenterBased());
            extension.setStrategy(data.getStrategy());
            extension.setRestrictFeatureAccess(data.getRestrictFeatureAccess());
            extension.setVoicemail(data.getVoicemail());
            extension.setQueryOn(data.getQueryOn());
            extension.setRetryVoiceMessage(data.getRetryVoiceMessage());
            extension.setGatewayControllerCode(data.getGatewayControllerCode());
            extension.setDenyPwdPrompt(data.getDenyPwdPrompt());
            extension.setTpi(data.getTpi());
            extension.setRingReady(data.getRingReady());
            extension.setOverrideMoh(data.getOverrideMoh());
            extension.setIsExtensionBasedAcd(data.getIsExtensionBasedAcd());
            extension.setDniBasedRouting(data.getDniBasedRouting());
            extension.setSide(data.getSide());
            extension.setPhysicalPlayerName(data.getPhysicalPlayerName());
            extension.setLogicalPlayerName(data.getLogicalPlayerName());
            extension.setTransferToAgentRingBack(data.getTransferToAgentRingBack());
            extension.setRadioNetCode(data.getRadioNetCode());
            extension.setHandleIsDnCause(data.getHandleIsDnCause());
            extension.setNetType(data.getNetType());
            extension.setRemoteUserIp(data.getRemoteUserIp());
            extension.setRemoteUserType(data.getRemoteUserType());
            extension.setNoAnsSmsTry(data.getNoAnsSmsTry());
            extension.setDialType(data.getDialType());
            extension.setEnableVideoCall(data.getEnableVideoCall());
            extension.setMasterCli(data.getMasterCli());
            extension.setUNma(data.getUNma());
            extension.setHomeRluCode(data.getHomeRluCode());
            extension.setSgwUser(data.getSgwUser());
            extension.setRegisterState(data.getRegisterState());
            extension.setIvrGroup(data.getIvrGroup());
            extension.setHotelLevel(data.getLevel());
            extension.setMissCallRedial(data.getMissCallRedial());
            extension.setMissCallDialDestination(data.getMissCallDialDestination());
            extension.setVmDiskQuota(data.getVmDiskQuota());
            extension.setWebApi(data.getWebApi());
            extension.setNoAnswerOverflowToBoss(data.getNoAnswerOverflowToBoss());
            extension.setPassword(data.getPassword());
            extension.setSipPassword(data.getSipPassword());
            extension.setVmPassword(data.getVmPassword());
            extension.setZone(data.getZone());
            extension.setExtensionIp(data.getExtensionIp());
            extension.setExtensionPort(data.getExtensionPort());
            extension.setModelCode(data.getModelCode());
            extension.setTimezone(data.getTimezone());
            extension.setSunFromTime(data.getSunFromTime());
            extension.setSunToTime(data.getSunToTime());
            extension.setExtensionSubtype(data.getExtensionSubtype());
            extension.setIMSI(data.getIMSI());
            extension.setKValue(data.getKValue());
            extension.setOPopc(data.getOPopc());
            extension.setMsiSdn(data.getMsiSdn());
            extension.setPremiumCustomer(data.getPremiumCustomer());
            extension.setGroupType(data.getGroupType());
            extension.setUuid(data.getUuid());
            extension.setIsFeedBack(data.getIsFeedBack());
            extension.setExtGroupCode(data.getExtGroupCode());
            extension.setPrimaryNightInboundCos(data.getPrimaryNightInboundCos());
            extension.setPrimaryNightOutboundCos(data.getPrimaryNightOutboundCos());
            extension.setXmpPPassword(data.getXmpPPassword());
            extension.setCfa(data.getCfa());
            extension.setECfa(data.getECfa());
            extension.setCfb(data.getCfb());
            extension.setECfb(data.getECfb());
            extension.setCFna(data.getCFna());
            extension.setECFna(data.getECFna());
            extension.setIsd(data.getIsd());
            extension.setStd(data.getStd());
            extension.setLocal(data.getLocal());
            extension.setIntercom(data.getIntercom());
            extension.setVm(data.getVm());
            extension.setFm(data.getFm());
            extension.setDnd(data.getDnd());
            extension.setDid(data.getDidNumber());
            extension.setDod(data.getDodNumber());
            extension.setCfaNumber(data.getCfaNumber());
            extension.setECfaNumber(data.getECfaNumber());
            extension.setCfbNumber(data.getCfbNumber());
            extension.setECfbNumber(data.getECfbNumber());
            extension.setCFnaNumber(data.getCFnaNumber());
            extension.setECfNaNumber(data.getECfNaNumber());
            addValue.add(extension);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("list of extension by ExtensionType");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessageDetail());
        return returnValue;
    }

    public RequestResponse getAllFwdExtensionByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = PForkExtensionSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extension" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extension" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.pForkExtensionRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.pForkExtensionRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<FwdExtConversionModel> entityToModelConversion(List<PForkExtension> fwdExt) {
        ArrayList<FwdExtConversionModel> addValue = new ArrayList<FwdExtConversionModel>();
        for (PForkExtension row : fwdExt) {
            FwdExtConversionModel data = new FwdExtConversionModel();
            data.setCreatedOn(row.getCreatedOn());
            data.setExtension(row.getExtension());
            data.setId(row.getId());
            data.setCreatedBy(row.getCreatedBy());
            data.setFromTime(row.getFromTime());
            data.setToTime(row.getToTime());
            if (row.getSunday() != null && row.getSunday() == 1) {
                data.setSunday("Yes");
            } else {
                data.setSunday("No");
            }
            if (row.getMonday() != null && row.getMonday() == 1) {
                data.setMonday("Yes");
            } else {
                data.setMonday("No");
            }
            if (row.getTuesday() != null && row.getTuesday() == 1) {
                data.setTuesday("Yes");
            } else {
                data.setTuesday("No");
            }
            if (row.getWednesday() != null && row.getWednesday() == 1) {
                data.setWednesday("Yes");
            } else {
                data.setWednesday("No");
            }
            if (row.getThursday() != null && row.getThursday() == 1) {
                data.setThursday("Yes");
            } else {
                data.setThursday("No");
            }
            if (row.getFriday() != null && row.getFriday() == 1) {
                data.setFriday("Yes");
            } else {
                data.setFriday("No");
            }
            if (row.getSaturday() != null && row.getSaturday() == 1) {
                data.setSaturday("Yes");
            } else {
                data.setSaturday("No");
            }
            data.setForwardExtension(row.getForwardExtension());
            data.setUpdatedBy(row.getUpdatedBy());
            data.setUpdatedOn(data.getUpdatedOn());
            addValue.add(data);
        }
        return addValue;
    }
}

