/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.groupMaster.service;

import com.coraltele.db.telephony.pbx.entity.GroupMaster;
import com.coraltele.db.telephony.pbx.repository.GroupMasterRepository;
import com.coraltele.db.telephony.pbx.specification.GroupMasterSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.groupMaster.model.GroupMasterModel;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class GroupMasterService {
    private static final Logger logger = LogManager.getLogger(GroupMasterService.class);
    @Autowired
    GroupMasterRepository groupMasterRepository;

    public RequestResponse createGroupMaster(GroupMasterModel data) {
        logger.debug("create new data for groupMaster : {} ==> {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional checkExistence = this.groupMasterRepository.findByGroupCode(data.getGroupCode());
        if (checkExistence.isPresent()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("unable to create groupMaster");
            returnValue.setMessageDetail("Selected GroupCode already exist !");
            logger.error(returnValue.getMessageDetail(), (Object)(":" + data.getId()));
            return returnValue;
        }
        try {
            GroupMaster row = new GroupMaster();
            row.setCreatedOn(LocalDateTime.now());
            row.setGroupCode(data.getGroupCode());
            row.setActive(data.getActive());
            row.setParentGroup(data.getParentGroup());
            row.setCanBroadCast(data.getCanBroadCast());
            row.setCanMultiCast(data.getCanMultiCast());
            row.setGroupName(data.getGroupName());
            this.groupMasterRepository.save((Object)row);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("groupMaster Registered");
            logger.info(" groupMaster saved : {}", (Object)returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("unable to create groupMaster");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getAll() {
        RequestResponse returnValue = new RequestResponse();
        List list = (List)this.groupMasterRepository.findAll();
        if (list.isEmpty()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Empty list present");
            logger.info(returnValue.getMessage());
        } else {
            ArrayList<GroupMasterModel> addValue = new ArrayList<GroupMasterModel>();
            for (GroupMaster groupMaster : list) {
                GroupMasterModel row = new GroupMasterModel();
                row.setId(groupMaster.getId());
                row.setGroupCode(groupMaster.getGroupCode());
                row.setActive(groupMaster.getActive());
                row.setParentGroup(groupMaster.getParentGroup());
                row.setGroupName(groupMaster.getGroupName());
                row.setCanBroadCast(groupMaster.getCanBroadCast());
                row.setCanMultiCast(groupMaster.getCanMultiCast());
                addValue.add(row);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setData(addValue);
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse updateGroupMaster(GroupMasterModel data) {
        logger.debug("Update GroupMasterModel {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional groupMaster = this.groupMasterRepository.findById((Object)data.getId());
            if (groupMaster.isPresent()) {
                if (data.getGroupCode() != null) {
                    Optional checkExistence = this.groupMasterRepository.findByGroupCode(data.getGroupCode());
                    if (checkExistence.isPresent() && !data.getId().equals(((GroupMaster)checkExistence.get()).getId())) {
                        returnValue.setStatus(Constants.Error.ERROR);
                        returnValue.setMessage("unable to create groupMaster");
                        returnValue.setMessageDetail("Selected GroupCode already exist !");
                        logger.error(returnValue.getMessageDetail(), (Object)(":" + data.getId()));
                        return returnValue;
                    }
                    ((GroupMaster)groupMaster.get()).setGroupCode(data.getGroupCode());
                }
                if (data.getActive() != null) {
                    ((GroupMaster)groupMaster.get()).setActive(data.getActive());
                }
                if (data.getParentGroup() != null) {
                    ((GroupMaster)groupMaster.get()).setParentGroup(data.getParentGroup());
                }
                if (data.getCanBroadCast() != null) {
                    ((GroupMaster)groupMaster.get()).setCanBroadCast(data.getCanBroadCast());
                }
                if (data.getCanMultiCast() != null) {
                    ((GroupMaster)groupMaster.get()).setCanMultiCast(data.getCanMultiCast());
                }
                if (data.getGroupName() != null) {
                    ((GroupMaster)groupMaster.get()).setGroupName(data.getGroupName());
                }
                this.groupMasterRepository.save(groupMaster.get());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Updated");
                returnValue.setMessageDetail("groupMaster Updated successfully");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("groupMaster not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to update groupMaster");
            returnValue.setMessageDetail("please Contact to administrator");
            logger.error("error while fetching the data.", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse deleteModelDetail(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        for (Integer ids : data.getIntId()) {
            Optional groupMaster = this.groupMasterRepository.findById((Object)ids);
            if (!groupMaster.isPresent()) continue;
            this.groupMasterRepository.deleteById((Object)ids);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = GroupMasterSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.groupMasterRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.groupMasterRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

