/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.fileConfiguration.defaultConfiguration.service;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.pbx.fileConfiguration.defaultConfiguration.model.DefaultConfigurationModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class DefaultConfigurationService {
    private static final Logger logger = LogManager.getLogger(DefaultConfigurationService.class);
    private static String storePathConfiguration = "/etc/coraltele/conf/default.config";
    private static String retrievePathConfiguration = "/etc/coraltele/conf/app.config";
    private static String sBcUserPortFilePathConfiguration = "/etc/default/coral";

    public String getSipPassword() throws IOException {
        FileInputStream input = null;
        Properties prop = new Properties();
        input = new FileInputStream(retrievePathConfiguration);
        prop.load(input);
        String extSipPassword = prop.getProperty("extsippassword");
        ((InputStream)input).close();
        return extSipPassword;
    }

    public String getSBCUserPort() throws IOException {
        FileInputStream input = null;
        Properties prop = new Properties();
        input = new FileInputStream(sBcUserPortFilePathConfiguration);
        prop.load(input);
        String userPort = prop.getProperty("SBC_USERS_PORT");
        ((InputStream)input).close();
        return userPort;
    }

    public String getDomain() throws IOException {
        FileInputStream input = null;
        Properties prop = new Properties();
        input = new FileInputStream(sBcUserPortFilePathConfiguration);
        prop.load(input);
        String domain = prop.getProperty("DOMAIN");
        ((InputStream)input).close();
        return domain;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getPBXDomain() {
        Properties prop = new Properties();
        String fileName = "/etc/coraltelecom/callserver.manager.conf";
        try (FileInputStream input = new FileInputStream(fileName);){
            prop.load(input);
            String string = prop.getProperty("pbxdomain", "").trim();
            return string;
        }
        catch (Exception e) {
            logger.error("Unable to load ServerCode from config", (Throwable)e);
            return "";
        }
    }

    public RequestResponse storeExtensionFile(DefaultConfigurationModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            File file = new File(storePathConfiguration);
            if (!file.exists()) {
                file.createNewFile();
                logger.info("New File Created Successfully");
            } else {
                logger.info("File Already Exists");
            }
            FileInputStream input = null;
            Properties prop = new Properties();
            input = new FileInputStream(storePathConfiguration);
            prop.load(input);
            ((InputStream)input).close();
            FileOutputStream output = new FileOutputStream(storePathConfiguration);
            if (data.getCallWaitingStatus().equals("0") || data.getCallWaitingStatus().equals("1") || data.getCallWaitingStatus().equals("2")) {
                prop.setProperty("callWaitingStatus", data.getCallWaitingStatus());
                prop.setProperty("id", "1");
                prop.setProperty("isd", String.valueOf(data.isIsd()));
                prop.setProperty("std", String.valueOf(data.isStd()));
                prop.setProperty("local", String.valueOf(data.isLocal()));
                prop.setProperty("ic", String.valueOf(data.isIc()));
                prop.setProperty("vm", String.valueOf(data.isVm()));
                prop.setProperty("dnd", String.valueOf(data.isDnd()));
                prop.setProperty("videoCall", String.valueOf(data.isVideoCall()));
                prop.setProperty("record", String.valueOf(data.isRecord()));
                prop.setProperty("ringTime", String.valueOf(data.getRingTime()));
                prop.setProperty("dayInboundcos", data.getDayInboundcos());
                prop.setProperty("dayOutboundcos", data.getDayOutboundcos());
                prop.setProperty("nightInboundcos", data.getNightInboundcos());
                prop.setProperty("nightOutboundcos", data.getNightOutboundcos());
                prop.setProperty("sipPassword", data.getSipPassword());
                prop.store(output, null);
                output.close();
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Stored ");
                returnValue.setMessageDetail("Data Stored Successfully");
                logger.info("Data Have Been Stored Successfully ");
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("callWaitingStatus Must Be Selected From DropDown");
                returnValue.setMessageDetail("callWaitingStatus Must Be Either 1, 2 Or 0 ");
                logger.error("Error while saving data logs");
            }
        }
        catch (FileNotFoundException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("File Not Found");
            returnValue.setMessageDetail("File Not Present At The Server.");
            logger.error("Error while saving data logs ", (Throwable)e);
        }
        catch (IOException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error while Storing Data Into File. ");
            returnValue.setMessageDetail("Unable To Store Data Into File");
            logger.error("Error while saving data logs::", (Throwable)e);
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed ");
            returnValue.setMessageDetail("Unable To Store Data Into File");
            logger.error("Error while saving data logs", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getExtensionFile() {
        RequestResponse returnValue = new RequestResponse();
        FileInputStream input = null;
        Properties prop = new Properties();
        ArrayList<DefaultConfigurationModel> addValue = new ArrayList<DefaultConfigurationModel>();
        DefaultConfigurationModel returnData = new DefaultConfigurationModel();
        try {
            input = new FileInputStream(storePathConfiguration);
            prop.load(input);
            returnData.setId(prop.getProperty("id").equals("null") ? null : Integer.valueOf(Integer.parseInt(prop.getProperty("id"))));
            returnData.setIsd((prop.getProperty("isd").equals("null") ? null : Boolean.valueOf(prop.getProperty("isd"))).booleanValue());
            returnData.setStd((prop.getProperty("std").equals("null") ? null : Boolean.valueOf(prop.getProperty("std"))).booleanValue());
            returnData.setLocal((prop.getProperty("local").equals("null") ? null : Boolean.valueOf(prop.getProperty("local"))).booleanValue());
            returnData.setIc((prop.getProperty("ic").equals("null") ? null : Boolean.valueOf(prop.getProperty("ic"))).booleanValue());
            returnData.setVm((prop.getProperty("vm").equals("null") ? null : Boolean.valueOf(prop.getProperty("vm"))).booleanValue());
            returnData.setDnd((prop.getProperty("dnd").equals("null") ? null : Boolean.valueOf(prop.getProperty("dnd"))).booleanValue());
            returnData.setVideoCall((prop.getProperty("videoCall").equals("null") ? null : Boolean.valueOf(prop.getProperty("videoCall"))).booleanValue());
            returnData.setRecord((prop.getProperty("record").equals("null") ? null : Boolean.valueOf(prop.getProperty("record"))).booleanValue());
            returnData.setRingTime(prop.getProperty("ringTime").equals("null") ? null : Integer.valueOf(Integer.parseInt(prop.getProperty("ringTime"))));
            returnData.setCallWaitingStatus(prop.getProperty("callWaitingStatus"));
            returnData.setDayInboundcos(prop.getProperty("dayInboundcos"));
            returnData.setDayOutboundcos(prop.getProperty("dayOutboundcos"));
            returnData.setNightInboundcos(prop.getProperty("nightInboundcos"));
            returnData.setNightOutboundcos(prop.getProperty("nightOutboundcos"));
            returnData.setSipPassword(prop.getProperty("sipPassword"));
            addValue.add(returnData);
            ((InputStream)input).close();
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Retrieved ");
            returnValue.setMessageDetail("Data Retrieved Successfully");
            returnValue.setData(addValue);
            logger.info("Data stored successfully");
        }
        catch (FileNotFoundException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed ");
            returnValue.setMessageDetail("File Not Found");
            logger.error("Error while saving data logs", (Throwable)e);
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed ");
            returnValue.setMessageDetail("Unable To Retrieve Data From File");
            logger.error("Error while saving data logs", (Throwable)e);
        }
        return returnValue;
    }
}

