/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.main.service;

import com.coraltele.db.coralapps.main.entity.OperatorTiers;
import com.coraltele.db.coralapps.main.entity.Tiers;
import com.coraltele.db.coralapps.main.repository.OperatorTiersRepository;
import com.coraltele.db.coralapps.main.repository.TiersRepository;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.service.coralApps.main.model.OperatorTiersModel;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class OperatorTiersService {
    private static final Logger logger = LogManager.getLogger(OperatorTiersService.class);
    @Autowired
    UserRepository userRepository;
    @Autowired
    OperatorTiersRepository operatorTiersRepository;
    @Autowired
    TiersRepository tiersRepository;

    public RequestResponse getAllQueueByUsername(Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        try {
            String contactNo;
            List operatorList;
            Optional username = this.userRepository.findByUsername(principal.getName());
            ArrayList<OperatorTiersModel> addValue = new ArrayList<OperatorTiersModel>();
            if (username.isPresent() && StringUtils.hasText((String)((User)username.get()).getContactNo()) && !(operatorList = this.operatorTiersRepository.findByAgent(contactNo = ((User)username.get()).getContactNo())).isEmpty()) {
                Set tiersQueues = this.tiersRepository.findByAgent(contactNo).stream().map(Tiers::getQueue).collect(Collectors.toSet());
                for (OperatorTiers row : operatorList) {
                    OperatorTiersModel data = new OperatorTiersModel();
                    data.setQueue(row.getQueue());
                    data.setActive(tiersQueues.contains(row.getQueue()));
                    if (row.getQueue() != null) {
                        if (row.getQueue().endsWith("_AS")) {
                            data.setName("Answer Station");
                        } else if (row.getQueue().endsWith("_AT")) {
                            data.setName("Answer Trunk");
                        } else if (row.getQueue().endsWith("_AV")) {
                            data.setName("Answer VIP");
                        }
                    }
                    if (row.getQueue() == null || !row.getQueue().endsWith("_AS") && !row.getQueue().endsWith("_AT") && !row.getQueue().endsWith("_AV")) continue;
                    addValue.add(data);
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("OK");
                returnValue.setData(addValue);
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to get operator details");
            returnValue.setMessageDetail("Contact the administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse addAndDeleteQueueInTiers(InputIdModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional username = this.userRepository.findByUsername(principal.getName());
            if (!username.isPresent()) {
                returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
                returnValue.setMessage("Invalid User");
                return returnValue;
            }
            String contactNo = ((User)username.get()).getContactNo();
            List requestedQueues = data.getStringId();
            if (requestedQueues.isEmpty()) {
                List allTiers = this.tiersRepository.findByAgent(contactNo).stream().filter(t -> t.getQueue().endsWith("_AS") || t.getQueue().endsWith("_AV") || t.getQueue().endsWith("_AT")).collect(Collectors.toList());
                if (!allTiers.isEmpty()) {
                    this.tiersRepository.deleteAll(allTiers);
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("OK");
                returnValue.setMessageDetail("All queues deactivated successfully");
                return returnValue;
            }
            String firstQueue = (String)requestedQueues.get(0);
            String baseQueue = firstQueue.contains("_") ? firstQueue.substring(0, firstQueue.lastIndexOf("_")) : firstQueue;
            List<String> allQueues = Arrays.asList(baseQueue + "_AS", baseQueue + "_AV", baseQueue + "_AT");
            HashSet requestedSet = new HashSet(requestedQueues);
            for (String rq : requestedSet) {
                Optional existing = this.tiersRepository.findByQueueAndAgent(rq, contactNo);
                if (existing.isPresent()) continue;
                Tiers newTiers = new Tiers();
                newTiers.setAgent(contactNo);
                newTiers.setQueue(rq);
                newTiers.setLevel(Integer.valueOf(1));
                newTiers.setPosition(Integer.valueOf(1));
                newTiers.setState("Ready");
                this.tiersRepository.save((Object)newTiers);
            }
            if (requestedSet.containsAll(allQueues)) {
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("OK");
                returnValue.setMessageDetail("Queues added successfully");
                return returnValue;
            }
            List toDeleteQueues = allQueues.stream().filter(q -> !requestedSet.contains(q)).collect(Collectors.toList());
            List toDelete = this.tiersRepository.findByAgent(contactNo).stream().filter(t -> toDeleteQueues.contains(t.getQueue())).collect(Collectors.toList());
            if (!toDelete.isEmpty()) {
                this.tiersRepository.deleteAll(toDelete);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Queues Added successfully");
        }
        catch (Exception e) {
            logger.error("Error in deleteTiersById", (Throwable)e);
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to update tiers");
            returnValue.setMessageDetail("Contact administrator");
        }
        return returnValue;
    }
}

