/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.leadSummaryInternalView.service;

import com.coraltele.db.coralapps.callcenter.entity.view.LeadDialingSummaryView;
import com.coraltele.db.coralapps.callcenter.repository.DialOutRepository;
import com.coraltele.db.coralapps.callcenter.repository.LeadDialingSummaryViewRepository;
import com.coraltele.db.coralapps.callcenter.repository.UploadLeadDataRepository;
import com.coraltele.db.coralapps.callcenter.specification.LeadDialingSummaryViewSpecification;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.AdvanceFilter;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class LeadDialingSummaryViewService {
    private static final Logger logger = LogManager.getLogger(LeadDialingSummaryViewService.class);
    @Autowired
    LeadDialingSummaryViewRepository leadDialingSummaryViewRepository;
    @Autowired
    UploadLeadDataRepository uploadLeadDataRepository;
    @Autowired
    DialOutRepository dialOutRepository;

    public RequestResponse getAllLeadDialingSummary(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        List cam = new ArrayList();
        for (AdvanceFilter filter : searchRequestData.advancedFilters) {
            if (!filter.getFieldName().equalsIgnoreCase("campaign")) continue;
            cam = this.getCampaignList(filter.getValue());
        }
        Specification filters = LeadDialingSummaryViewSpecification.generateFilters((SearchRequest)searchRequestData, cam);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startCall" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startCall" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.leadDialingSummaryViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.leadDialingSummaryViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<String> getCampaignList(String campaign) {
        List campaignsList = this.leadDialingSummaryViewRepository.findByCampaign(campaign);
        ArrayList<String> campaigns = new ArrayList<String>();
        if (!campaignsList.isEmpty()) {
            for (LeadDialingSummaryView data : campaignsList) {
                campaigns.add(data.getCampaign());
            }
        }
        return campaigns;
    }
}

