/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.callDispositionLead.service;

import com.coraltele.db.coralapps.callcenter.repository.CallDispositionLeadRepository;
import com.coraltele.db.coralapps.callcenter.specification.CallDispositionLeadSpecification;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.callcenter.callDispositionLead.model.ModelReturn;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.user.service.UserService;
import java.lang.reflect.Field;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class CallDispositionLeadService {
    private static final Logger logger = LogManager.getLogger(CallDispositionLeadService.class);
    @Autowired
    CallDispositionLeadRepository callDispositionLeadRepository;
    @Autowired
    UserService userService;
    @Autowired
    QueueTLService queueTLService;

    public RequestResponse getAllCallDispositionData(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        boolean teamLeaderUser = false;
        if (this.userService.checkRoleTL(principal.getName())) {
            teamLeaderUser = true;
        }
        List queueId = null;
        if (teamLeaderUser) {
            queueId = this.queueTLService.getQueueListByTeamLeaderInt(principal.getName());
        }
        Specification filters = CallDispositionLeadSpecification.generateFilters((SearchRequest)searchRequestData, (boolean)teamLeaderUser, queueId);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "createdOn" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "createdOn" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.callDispositionLeadRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.callDispositionLeadRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse printModelFields(Class<?> clazz) {
        Field[] fields;
        RequestResponse response = new RequestResponse();
        ArrayList<ModelReturn> list = new ArrayList<ModelReturn>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            ModelReturn model = new ModelReturn();
            model.setFieldName(field.getName());
            model.setDataType(field.getType().getSimpleName());
            list.add(model);
        }
        response.setMessage("Retrieved List");
        response.setMessageDetail("Retrieved List");
        response.setData(list);
        return response;
    }
}

