/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.billing.main.billingSummaryView.controller;

import com.coraltele.db.billing.main.entity.view.ViewChannels;
import com.coraltele.db.billing.main.repository.BillingSummaryViewRepository;
import com.coraltele.db.billing.main.repository.ViewChannelsRepository;
import com.coraltele.db.billing.main.specification.ViewChannelsSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.billing.main.billingSummaryView.model.BillingSummaryViewModel;
import com.coraltele.service.billing.main.billingSummaryView.service.BillingSummaryViewService;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/billingSummary"})
@RestController
public class BillingSummaryViewController {
    private static final Logger logger = LogManager.getLogger(BillingSummaryViewService.class);
    @Autowired
    BillingSummaryViewService billingSummaryViewService;
    @Autowired
    BillingSummaryViewRepository billingSummaryViewRepository;
    @Autowired
    ViewChannelsRepository viewChannelsRepository;
    @Autowired
    DownloadPdfService pdfDownloadService;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadServiceTest;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllFilteredData(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.billingSummaryViewService.getAllFilteredData(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData) {
        try {
            logger.info("CSV file download started for billing summary--");
            Specification filters = ViewChannelsSpecification.generateFilters((SearchRequest)searchRequestData);
            List filteredData = this.viewChannelsRepository.findAll(filters);
            List aggregatedData = this.aggregateBillingSummary(filteredData);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (BillingSummaryViewModel item : aggregatedData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String selectedColumn : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, selectedColumn));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for billing summary", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading billing summary CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private List<BillingSummaryViewModel> aggregateBillingSummary(List<ViewChannels> billingSummaryViews) {
        HashMap<String, BillingSummaryViewModel> aggregationMap = new HashMap<String, BillingSummaryViewModel>();
        for (ViewChannels row : billingSummaryViews) {
            String direction = this.mapDirection(row.getDirection());
            BillingSummaryViewModel data = aggregationMap.getOrDefault(direction, new BillingSummaryViewModel());
            data.setDirection(direction);
            data.setTotal(Long.valueOf(data.getTotal() + 1L));
            if (row.getCallType() == null || row.getCallType().isEmpty()) {
                data.setNoCallType(Long.valueOf(data.getNoCallType() + 1L));
            } else if ("LOCAL".equalsIgnoreCase(row.getCallType())) {
                data.setLocal(Long.valueOf(data.getLocal() + 1L));
            } else if ("STD".equalsIgnoreCase(row.getCallType())) {
                data.setStd(Long.valueOf(data.getStd() + 1L));
            } else if ("ISD".equalsIgnoreCase(row.getCallType())) {
                data.setIsd(Long.valueOf(data.getIsd() + 1L));
            }
            aggregationMap.put(direction, data);
        }
        return new ArrayList<BillingSummaryViewModel>(aggregationMap.values());
    }

    private Object getColumnValue(BillingSummaryViewModel item, String columnName) {
        switch (columnName) {
            case "direction": {
                return this.checkNull((Object)item.getDirection());
            }
            case "noCallType": {
                return this.checkNull((Object)item.getNoCallType());
            }
            case "total": {
                return this.checkNull((Object)item.getTotal());
            }
            case "local": {
                return this.checkNull((Object)item.getLocal());
            }
            case "std": {
                return this.checkNull((Object)item.getStd());
            }
            case "isd": {
                return this.checkNull((Object)item.getIsd());
            }
        }
        return null;
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }

    private String mapDirection(String direction) {
        if ("INT".equalsIgnoreCase(direction)) {
            return "Intercom";
        }
        if ("IN".equalsIgnoreCase(direction)) {
            return "Incoming";
        }
        if ("OUT".equalsIgnoreCase(direction)) {
            return "Outgoing";
        }
        return direction;
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadServiceTest.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    static {
        columnMappings.put("direction", "Direction");
        columnMappings.put("noCallType", "NoCallType");
        columnMappings.put("total", "Total");
        columnMappings.put("local", "LOCAL");
        columnMappings.put("std", "STD");
        columnMappings.put("isd", "ISD");
    }
}

