/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.background;

import com.coraltele.db.billing.main.entity.PdfReportFilters;
import com.coraltele.db.billing.main.repository.PdfReportRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.PdfGeneratorService;
import java.security.Principal;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class DynamicPdfThreadService {
    @Autowired
    @Qualifier(value="billingPdf")
    private PdfGeneratorService reportGeneratorService1;
    @Autowired
    @Qualifier(value="alertHistoryPDF")
    private PdfGeneratorService reportGeneratorService2;
    @Autowired
    @Qualifier(value="voicePickerPDF")
    private PdfGeneratorService reportGeneratorService3;
    @Autowired
    @Qualifier(value="campaignSummaryPDF")
    private PdfGeneratorService reportGeneratorService4;
    @Autowired
    @Qualifier(value="callDispositionPDF")
    private PdfGeneratorService reportGeneratorService5;
    @Autowired
    @Qualifier(value="cmsPDF")
    private PdfGeneratorService reportGeneratorService6;
    @Autowired
    @Qualifier(value="dailyReportPdf")
    private PdfGeneratorService reportGeneratorService7;
    @Autowired
    @Qualifier(value="dailyPerformancePDF")
    private PdfGeneratorService reportGeneratorService8;
    @Autowired
    @Qualifier(value="userStatusPdf")
    private PdfGeneratorService reportGeneratorService9;
    @Autowired
    @Qualifier(value="lastNAgentPdf")
    private PdfGeneratorService reportGeneratorService10;
    @Autowired
    @Qualifier(value="customerCDRPdf")
    private PdfGeneratorService reportGeneratorService11;
    @Autowired
    @Qualifier(value="acdSummaryPdf")
    private PdfGeneratorService reportGeneratorService12;
    @Autowired
    @Qualifier(value="missedCallPdf")
    private PdfGeneratorService reportGeneratorService13;
    @Autowired
    @Qualifier(value="dialedCallPdf")
    private PdfGeneratorService reportGeneratorService14;
    @Autowired
    @Qualifier(value="receivedCallPdf")
    private PdfGeneratorService reportGeneratorService15;
    @Autowired
    @Qualifier(value="paCDRPdf")
    private PdfGeneratorService reportGeneratorService16;
    @Autowired
    @Qualifier(value="queuePerformanceSummaryPdf")
    private PdfGeneratorService reportGeneratorService17;
    @Autowired
    @Qualifier(value="extensionProperties")
    private PdfGeneratorService reportGeneratorService18;
    @Autowired
    @Qualifier(value="voiceRecordingPdf")
    private PdfGeneratorService reportGeneratorService19;
    @Autowired
    @Qualifier(value="newComplaint")
    private PdfGeneratorService reportGeneratorService20;
    @Autowired
    @Qualifier(value="complaintEngineer")
    private PdfGeneratorService reportGeneratorService21;
    @Autowired
    @Qualifier(value="closedComplaint")
    private PdfGeneratorService reportGeneratorService22;
    @Autowired
    @Qualifier(value="approvalComplaint")
    private PdfGeneratorService reportGeneratorService23;
    @Autowired
    @Qualifier(value="fwdExtension")
    private PdfGeneratorService reportGeneratorService24;
    @Autowired
    @Qualifier(value="queueAbandoned")
    private PdfGeneratorService reportGeneratorService25;
    @Autowired
    @Qualifier(value="answeredPdf")
    private PdfGeneratorService reportGeneratorService26;
    @Autowired
    @Qualifier(value="dispositionAnalysisQueue")
    private PdfGeneratorService reportGeneratorService27;
    @Autowired
    @Qualifier(value="callerCallDataAnalysis")
    private PdfGeneratorService reportGeneratorService28;
    @Autowired
    @Qualifier(value="agentCallDataAnalysis")
    private PdfGeneratorService reportGeneratorService29;
    @Autowired
    @Qualifier(value="lastAbandonedRecords")
    private PdfGeneratorService reportGeneratorService30;
    @Autowired
    @Qualifier(value="queueTimeIntervalPdf")
    private PdfGeneratorService reportGeneratorService31;
    @Autowired
    @Qualifier(value="queueTimeInterval")
    private PdfGeneratorService reportGeneratorService32;
    @Autowired
    @Qualifier(value="queueTimeIntervalPdfService")
    private PdfGeneratorService reportGeneratorService33;
    @Autowired
    @Qualifier(value="queueTimeIntervalSixty")
    private PdfGeneratorService reportGeneratorService34;
    @Autowired
    @Qualifier(value="leadSummaryPdf")
    private PdfGeneratorService reportGeneratorService35;
    @Autowired
    @Qualifier(value="leadDialSummaryPdf")
    private PdfGeneratorService reportGeneratorService36;
    @Autowired
    @Qualifier(value="agentCdrPdf")
    private PdfGeneratorService reportGeneratorService37;
    @Autowired
    @Qualifier(value="billingCDRSummaryPDF")
    private PdfGeneratorService reportGeneratorService38;
    @Autowired
    @Qualifier(value="billingCDRPdf")
    private PdfGeneratorService reportGeneratorService39;
    @Autowired
    @Qualifier(value="dailyPerformanceSummaryPDF")
    private PdfGeneratorService reportGeneratorService40;
    @Autowired
    @Qualifier(value="queuePerformanceSummariesPdf")
    private PdfGeneratorService reportGeneratorService41;
    @Autowired
    @Qualifier(value="billingSummaryPDF")
    private PdfGeneratorService reportGeneratorService42;
    @Autowired
    @Qualifier(value="taskPDF")
    private PdfGeneratorService reportGeneratorService43;
    @Autowired
    @Qualifier(value="billingPdfV1")
    private PdfGeneratorService reportGeneratorService44;
    @Autowired
    @Qualifier(value="callbackPDF")
    private PdfGeneratorService reportGeneratorService45;
    @Autowired
    @Qualifier(value="skippedNumberPdf")
    private PdfGeneratorService reportGeneratorService46;
    @Autowired
    @Qualifier(value="blasterReportPDF")
    private PdfGeneratorService reportGeneratorService47;
    @Autowired
    @Qualifier(value="feedbackReportPdf")
    private PdfGeneratorService reportGeneratorService48;
    @Autowired
    @Qualifier(value="pForkExtension")
    private PdfGeneratorService reportGeneratorService49;
    @Autowired
    @Qualifier(value="extensionBillingPdf")
    private PdfGeneratorService reportGeneratorService50;
    @Autowired
    @Qualifier(value="extensionBillingInBoundPdf")
    private PdfGeneratorService reportGeneratorService51;
    @Autowired
    @Qualifier(value="extensionBillingOutBoundPdf")
    private PdfGeneratorService reportGeneratorService52;
    @Autowired
    @Qualifier(value="extensionCDRPdf")
    private PdfGeneratorService reportGeneratorService53;
    @Autowired
    @Qualifier(value="NonWorkingHolidayPdf")
    private PdfGeneratorService reportGeneratorService54;
    @Autowired
    @Qualifier(value="extensionSummaryPdf")
    private PdfGeneratorService reportGeneratorService55;
    @Autowired
    @Qualifier(value="extensionDetailSummaryPdf")
    private PdfGeneratorService reportGeneratorService56;
    @Autowired
    @Qualifier(value="gatewayOutBoundSummaryPdf")
    private PdfGeneratorService reportGeneratorService57;
    @Autowired
    @Qualifier(value="gatewayInBoundSummaryPdf")
    private PdfGeneratorService reportGeneratorService58;
    @Autowired
    @Qualifier(value="ExtensionDetailsInPdf")
    private PdfGeneratorService reportGeneratorService59;
    @Autowired
    @Qualifier(value="ExtensionDetailsSummaryInPdf")
    private PdfGeneratorService reportGeneratorService60;
    @Autowired
    @Qualifier(value="OutBoundExtensionSummaryPdf")
    private PdfGeneratorService reportGeneratorService61;
    @Qualifier(value="departmentSummaryPdf")
    private PdfGeneratorService reportGeneratorService62;
    @Autowired
    @Qualifier(value="departmentDetailsPdf")
    private PdfGeneratorService reportGeneratorService63;
    @Autowired
    private PdfReportRepository pdfReportRepository;
    private final int INITIAL_CORE_POOL_SIZE = 1;
    private final int MAX_POOL_SIZE = 100;
    private final long KEEP_ALIVE_TIME = 10L;
    private final TimeUnit TIME_UNIT = TimeUnit.SECONDS;
    private final Map<String, Thread> reportThreads = new ConcurrentHashMap();
    private final ThreadPoolExecutor reportExecutor = new ThreadPoolExecutor(1, 100, 10L, this.TIME_UNIT, new LinkedBlockingQueue<Runnable>());

    @Async
    public CompletableFuture<RequestResponse> startGeneratingReportAsync(String reportType, String id, SearchRequest searchRequestData, String filePath, Principal principal) {
        return CompletableFuture.supplyAsync(() -> {
            RequestResponse response = new RequestResponse();
            try {
                PdfGeneratorService reportGeneratorService;
                this.reportThreads.put(reportType, Thread.currentThread());
                if ("billingPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService1;
                } else if ("alertHistoryPDF".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService2;
                } else if ("voicePickerPDF".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService3;
                } else if ("campaignSummaryPDF".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService4;
                } else if ("callDispositionPDF".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService5;
                } else if ("cmsPDF".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService6;
                } else if ("dailyReportPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService7;
                } else if ("dailyPerformancePDF".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService8;
                } else if ("userStatusPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService9;
                } else if ("lastNAgentPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService10;
                } else if ("customerCDRPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService11;
                } else if ("acdSummaryPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService12;
                } else if ("missedCallPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService13;
                } else if ("dialedCallPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService14;
                } else if ("receivedCallPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService15;
                } else if ("paCDRPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService16;
                } else if ("queuePerformanceSummaryPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService17;
                } else if ("extensionProperties".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService18;
                } else if ("voiceRecordingPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService19;
                } else if ("newComplaint".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService20;
                } else if ("complaintEngineer".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService21;
                } else if ("closedComplaint".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService22;
                } else if ("approvalComplaint".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService23;
                } else if ("fwdExtension".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService24;
                } else if ("queueAbandoned".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService25;
                } else if ("answeredPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService26;
                } else if ("dispositionAnalysisQueue".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService27;
                } else if ("callerCallDataAnalysis".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService28;
                } else if ("agentCallDataAnalysis".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService29;
                } else if ("lastAbandonedRecords".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService30;
                } else if ("queueTimeIntervalPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService31;
                } else if ("queueTimeInterval".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService32;
                } else if ("queueTimeIntervalPdfService".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService33;
                } else if ("queueTimeIntervalSixty".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService34;
                } else if ("leadSummaryPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService35;
                } else if ("leadDialSummaryPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService36;
                } else if ("agentCdrPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService37;
                } else if ("billingCDRSummaryPDF".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService38;
                } else if ("billingCDRPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService39;
                } else if ("dailyPerformanceSummaryPDF".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService40;
                } else if ("queuePerformanceSummariesPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService41;
                } else if ("billingSummaryPDF".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService42;
                } else if ("taskPDF".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService43;
                } else if ("billingPdfV1".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService44;
                } else if ("callbackPDF".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService45;
                } else if ("skippedNumberPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService46;
                } else if ("blasterReportPDF".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService47;
                } else if ("feedbackReportPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService48;
                } else if ("pForkExtension".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService49;
                } else if ("extensionBillingPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService50;
                } else if ("extensionBillingInBoundPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService51;
                } else if ("extensionBillingOutBoundPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService52;
                } else if ("extensionCDRPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService53;
                } else if ("NonWorkingHolidayPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService54;
                } else if ("extensionSummaryPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService55;
                } else if ("extensionDetailSummaryPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService56;
                } else if ("gatewayOutBoundSummaryPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService57;
                } else if ("gatewayInBoundSummaryPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService58;
                } else if ("ExtensionDetailsInPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService59;
                } else if ("ExtensionDetailsSummaryInPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService60;
                } else if ("OutBoundExtensionSummaryPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService61;
                } else if ("departmentSummaryPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService62;
                } else if ("departmentDetailsPdf".equals(reportType)) {
                    reportGeneratorService = this.reportGeneratorService63;
                } else {
                    throw new IllegalArgumentException("Unknown reportType: " + reportType);
                }
                reportGeneratorService.createPdfReportRecord(id, searchRequestData, filePath);
                RequestResponse generatedResponse = reportGeneratorService.generatePdfReport(searchRequestData, filePath, principal);
                if (generatedResponse.getStatus().equals((Object)Constants.Error.OK)) {
                    this.updateStatus(id, "success");
                    generatedResponse.setData((Object)this.pdfReportRepository.findById((Object)id).orElse(new PdfReportFilters()).getPdfLocation());
                } else {
                    this.updateStatus(id, "failed");
                }
                response = generatedResponse;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.updateStatus(id, "failed");
                response = new RequestResponse(Constants.Error.ERROR, "Failed to start report generation. Reason: " + e.getMessage(), null, null);
            }
            finally {
                this.reportThreads.remove(reportType);
            }
            return response;
        }, this.reportExecutor);
    }

    public void updateStatus(String id, String status) {
        Optional pdfStatus = this.pdfReportRepository.findById((Object)id);
        if (pdfStatus.isPresent()) {
            ((PdfReportFilters)pdfStatus.get()).setStatus(status);
            this.pdfReportRepository.save(pdfStatus.get());
        }
    }
}

