/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.uc.service;

import com.coraltele.db.telephony.uc.entity.UserStatus;
import com.coraltele.db.telephony.uc.repository.UserStatusRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.service.uc.model.StatusModel;
import java.time.LocalDateTime;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserStatusService {
    private static final Logger logger = LogManager.getLogger(UserStatusService.class);
    @Autowired
    UserStatusRepository userStatusRepository;

    public RequestResponse createStatus(StatusModel data) {
        logger.debug("create new user status : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            UserStatus dataToSave = new UserStatus();
            dataToSave.setDescription(data.getDescription());
            dataToSave.setStatusId(data.getStatusId());
            dataToSave.setCreatedOn(LocalDateTime.now());
            this.userStatusRepository.save((Object)dataToSave);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("created");
            returnValue.setMessageDetail("new status created successfully");
            logger.info(returnValue.getMessageDetail());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to create status");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse delete(InputIdModel dataToDelete) {
        RequestResponse returnValue = new RequestResponse();
        for (Long row : dataToDelete.getId()) {
            this.userStatusRepository.deleteById((Object)row);
        }
        logger.info("user status deleted successfully");
        return returnValue;
    }
}

