/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.queueTimeIntervalView.controller;

import com.coraltele.db.telemetry.main.entity.view.QueueTimeIntervalFifteenView;
import com.coraltele.db.telemetry.main.entity.view.QueueTimeIntervalFortyFiveView;
import com.coraltele.db.telemetry.main.entity.view.QueueTimeIntervalSixtyView;
import com.coraltele.db.telemetry.main.entity.view.QueueTimeIntervalView;
import com.coraltele.db.telemetry.main.repository.QueueTimeIntervalFifteenViewRepository;
import com.coraltele.db.telemetry.main.repository.QueueTimeIntervalFortyFiveViewRepository;
import com.coraltele.db.telemetry.main.repository.QueueTimeIntervalSixtyViewRepository;
import com.coraltele.db.telemetry.main.repository.QueueTimeIntervalViewRepository;
import com.coraltele.db.telemetry.main.specification.QueueTimeIntervalFifteenViewSpecification;
import com.coraltele.db.telemetry.main.specification.QueueTimeIntervalFortyFiveViewSpecification;
import com.coraltele.db.telemetry.main.specification.QueueTimeIntervalSixtyViewSpecification;
import com.coraltele.db.telemetry.main.specification.QueueTimeIntervalViewSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.telemetry.main.queueTimeIntervalView.service.QueueTimeIntervalService;
import com.coraltele.service.user.service.UserService;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/queueTimeInterval"})
@RestController
public class QueueTimeIntervalViewController {
    private static final Logger logger = LogManager.getLogger(QueueTimeIntervalViewController.class);
    @Autowired
    QueueTimeIntervalService queueTimeIntervalService;
    @Autowired
    QueueTimeIntervalViewRepository queueTimeIntervalViewRepository;
    @Autowired
    DownloadPdfService pdfDownloadService;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadServiceTest;
    @Autowired
    QueueTimeIntervalFifteenViewRepository queueTimeIntervalFifteenViewRepository;
    @Autowired
    QueueTimeIntervalFortyFiveViewRepository queueTimeIntervalFortyFiveViewRepository;
    @Autowired
    QueueTimeIntervalSixtyViewRepository queueTimeIntervalSixtyViewRepository;
    @Autowired
    UserService userService;
    @Autowired
    QueueTLService queueTLService;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    @PostMapping(value={"/thirtyList"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.queueTimeIntervalService.getAllByFilter(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"thirty/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for queue time interval--");
            boolean teamLeaderUser = false;
            if (this.userService.checkRoleTL(principal.getName())) {
                teamLeaderUser = true;
            }
            List queueId = null;
            if (teamLeaderUser) {
                queueId = this.queueTLService.getQueueListByTeamLeader(principal.getName());
            }
            Specification filters = QueueTimeIntervalViewSpecification.generateFilters((SearchRequest)searchRequestData, (boolean)teamLeaderUser, queueId);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.queueTimeIntervalViewRepository.findAll(filters, sort) : this.queueTimeIntervalViewRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (QueueTimeIntervalView item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for queue time interval", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading queue time interval CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValue(QueueTimeIntervalView item, String columnName) {
        switch (columnName) {
            case "st": {
                return this.checkNull((Object)item.getSt());
            }
            case "et": {
                return this.checkNull((Object)item.getEt());
            }
            case "queue": {
                return this.checkNull((Object)item.getQueue());
            }
            case "queueName": {
                return this.checkNull((Object)item.getQueueName());
            }
            case "callOffered": {
                return this.checkNull((Object)item.getCallOffered());
            }
            case "answered": {
                return this.checkNull((Object)item.getAnswered());
            }
            case "noAnswer": {
                return this.checkNull((Object)item.getNoAnswer());
            }
        }
        return null;
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadServiceTest.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    @PostMapping(value={"/fifteenList"})
    public ResponseEntity<RequestResponse> getAllByFilterForFifteenTimeInterval(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.queueTimeIntervalService.getAllByFilterForFifteenTimeInterval(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"fifteen/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSVForFifteen(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for queue time interval--");
            boolean teamLeaderUser = false;
            if (this.userService.checkRoleTL(principal.getName())) {
                teamLeaderUser = true;
            }
            List queueId = null;
            if (teamLeaderUser) {
                queueId = this.queueTLService.getQueueListByTeamLeader(principal.getName());
            }
            Specification filters = QueueTimeIntervalFifteenViewSpecification.generateFilters((SearchRequest)searchRequestData, (boolean)teamLeaderUser, queueId);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.queueTimeIntervalFifteenViewRepository.findAll(filters, sort) : this.queueTimeIntervalFifteenViewRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (QueueTimeIntervalFifteenView item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for queue time interval", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading queue time interval CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValue(QueueTimeIntervalFifteenView item, String columnName) {
        switch (columnName) {
            case "st": {
                return this.checkNull((Object)item.getSt());
            }
            case "et": {
                return this.checkNull((Object)item.getEt());
            }
            case "queue": {
                return this.checkNull((Object)item.getQueue());
            }
            case "queueName": {
                return this.checkNull((Object)item.getQueueName());
            }
            case "callOffered": {
                return this.checkNull((Object)item.getCallOffered());
            }
            case "answered": {
                return this.checkNull((Object)item.getAnswered());
            }
            case "noAnswer": {
                return this.checkNull((Object)item.getNoAnswer());
            }
        }
        return null;
    }

    @PostMapping(value={"/fortyFiveList"})
    public ResponseEntity<RequestResponse> getAllByFilterForFortyFive(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.queueTimeIntervalService.getAllByFilterForFortyFive(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"fortyFive/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSVForFortyFive(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for queue time interval--");
            boolean teamLeaderUser = false;
            if (this.userService.checkRoleTL(principal.getName())) {
                teamLeaderUser = true;
            }
            List queueId = null;
            if (teamLeaderUser) {
                queueId = this.queueTLService.getQueueListByTeamLeader(principal.getName());
            }
            Specification filters = QueueTimeIntervalFortyFiveViewSpecification.generateFilters((SearchRequest)searchRequestData, (boolean)teamLeaderUser, queueId);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.queueTimeIntervalFortyFiveViewRepository.findAll(filters, sort) : this.queueTimeIntervalFortyFiveViewRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (QueueTimeIntervalFortyFiveView item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for queue time interval", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading queue time interval CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValue(QueueTimeIntervalFortyFiveView item, String columnName) {
        switch (columnName) {
            case "st": {
                return this.checkNull((Object)item.getSt());
            }
            case "et": {
                return this.checkNull((Object)item.getEt());
            }
            case "queue": {
                return this.checkNull((Object)item.getQueue());
            }
            case "queueName": {
                return this.checkNull((Object)item.getQueueName());
            }
            case "callOffered": {
                return this.checkNull((Object)item.getCallOffered());
            }
            case "answered": {
                return this.checkNull((Object)item.getAnswered());
            }
            case "noAnswer": {
                return this.checkNull((Object)item.getNoAnswer());
            }
        }
        return null;
    }

    @PostMapping(value={"/sixtyList"})
    public ResponseEntity<RequestResponse> getAllByFilterForSixty(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.queueTimeIntervalService.getAllByFilterForSixty(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"sixty/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSVForForSixty(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for queue time interval--");
            boolean teamLeaderUser = false;
            if (this.userService.checkRoleTL(principal.getName())) {
                teamLeaderUser = true;
            }
            List queueId = null;
            if (teamLeaderUser) {
                queueId = this.queueTLService.getQueueListByTeamLeader(principal.getName());
            }
            Specification filters = QueueTimeIntervalSixtyViewSpecification.generateFilters((SearchRequest)searchRequestData, (boolean)teamLeaderUser, queueId);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.queueTimeIntervalSixtyViewRepository.findAll(filters, sort) : this.queueTimeIntervalSixtyViewRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (QueueTimeIntervalSixtyView item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for queue time interval", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading queue time interval CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValue(QueueTimeIntervalSixtyView item, String columnName) {
        switch (columnName) {
            case "st": {
                return this.checkNull((Object)item.getSt());
            }
            case "et": {
                return this.checkNull((Object)item.getEt());
            }
            case "queue": {
                return this.checkNull((Object)item.getQueue());
            }
            case "queueName": {
                return this.checkNull((Object)item.getQueueName());
            }
            case "callOffered": {
                return this.checkNull((Object)item.getCallOffered());
            }
            case "answered": {
                return this.checkNull((Object)item.getAnswered());
            }
            case "noAnswer": {
                return this.checkNull((Object)item.getNoAnswer());
            }
        }
        return null;
    }

    static {
        columnMappings.put("st", "Start Interval");
        columnMappings.put("et", "End Interval");
        columnMappings.put("queue", "Queue");
        columnMappings.put("queueName", "Queue Name");
        columnMappings.put("callOffered", "Total Call Offered");
        columnMappings.put("answered", "Total Call Answered");
        columnMappings.put("noAnswer", "Total Call Abandoned");
    }
}

