/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.coralnms.widget.service;

import com.coraltele.db.telemetry.coralnms.entity.API;
import com.coraltele.db.telemetry.coralnms.entity.Sensor;
import com.coraltele.db.telemetry.coralnms.entity.Widget;
import com.coraltele.db.telemetry.coralnms.entity.WidgetType;
import com.coraltele.db.telemetry.coralnms.entity.view.DashboardWidgetView;
import com.coraltele.db.telemetry.coralnms.repository.APIRepository;
import com.coraltele.db.telemetry.coralnms.repository.DashboardWidgetViewRepository;
import com.coraltele.db.telemetry.coralnms.repository.SenorRepository;
import com.coraltele.db.telemetry.coralnms.repository.WidgetRepository;
import com.coraltele.db.telemetry.coralnms.repository.WidgetTypeRepository;
import com.coraltele.db.telemetry.coralnms.specification.DashboardWidgetViewSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.coralnms.widget.model.DashboardWidgetModel;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class DashboardWidgetService {
    private static final Logger logger = LogManager.getLogger(DashboardWidgetService.class);
    @Autowired
    WidgetRepository widgetRepository;
    @Autowired
    WidgetTypeRepository widgetTypeRepository;
    @Autowired
    APIRepository apiRepository;
    @Autowired
    SenorRepository senorRepository;
    @Autowired
    DashboardWidgetViewRepository dashboardWidgetViewRepository;

    public RequestResponse create(DashboardWidgetModel data, Principal principal) {
        logger.debug("Create New Dashboard : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional api;
            Optional sensor;
            Widget widget = new Widget();
            Optional widgetType = this.widgetTypeRepository.findById(Integer.valueOf(9));
            if (widgetType.isPresent()) {
                widget.setWidgetType((WidgetType)widgetType.get());
            }
            widget.setName(data.getName());
            widget.setCode(data.getCode());
            widget.setChartType(data.getChartType());
            if (data.getSensor() != null && (sensor = this.senorRepository.findById(data.getSensor())).isPresent()) {
                widget.setSensor((Sensor)sensor.get());
            }
            widget.setLegendFieldDataType(data.getLegendFieldDataType());
            widget.setValueFieldDataType(data.getValueFieldDataType());
            if (data.getApi() != null && (api = this.apiRepository.findById(data.getApi())).isPresent()) {
                widget.setApi((API)api.get());
            }
            widget.setRefreshInterval(data.getRefreshInterval());
            widget.setImageName(data.getImageName());
            widget.setCategory(data.getCategory());
            widget.setIsDefaultDashboard(Boolean.valueOf(data.getIsDefaultDashboard() != false));
            widget.setIsDefaultDashboard(data.getIsDefaultDashboard());
            widget.setEnabled(data.getEnabled());
            widget.setExport(data.getExport());
            widget.setHasWebSocketUpdate(data.getHasWebSocketUpdate());
            widget.setDashboardGroup(data.getDashboardGroup());
            widget.setDashboardLayout(data.getDashboardLayout());
            widget.setCreatedBy(principal.getName());
            widget.setCreatedOn(LocalDateTime.now());
            widget.setUuid(UUID.randomUUID().toString());
            this.widgetRepository.save((Object)widget);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Dashboard Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable To Create Dashboard");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(DashboardWidgetModel data) {
        Optional api;
        Optional sensor;
        logger.debug("Update Dashboard {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional widget = this.widgetRepository.findById(data.getId());
        if (!widget.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Dashboard found");
            returnValue.setMessageDetail("Dashboard not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getName() != null) {
            ((Widget)widget.get()).setName(data.getName());
        }
        if (data.getCode() != null) {
            ((Widget)widget.get()).setCode(data.getCode());
        }
        if (data.getChartType() != null) {
            ((Widget)widget.get()).setChartType(data.getChartType());
        }
        if (data.getSensor() != null && (sensor = this.senorRepository.findById(data.getSensor())).isPresent()) {
            ((Widget)widget.get()).setSensor((Sensor)sensor.get());
        }
        if (data.getLegendFieldDataType() != null) {
            ((Widget)widget.get()).setLegendFieldDataType(data.getLegendFieldDataType());
        }
        if (data.getValueFieldDataType() != null) {
            ((Widget)widget.get()).setValueFieldDataType(data.getValueFieldDataType());
        }
        if (data.getApi() != null && (api = this.apiRepository.findById(data.getApi())).isPresent()) {
            ((Widget)widget.get()).setApi((API)api.get());
        }
        if (data.getRefreshInterval() != null) {
            ((Widget)widget.get()).setRefreshInterval(data.getRefreshInterval());
        }
        if (data.getImageName() != null) {
            ((Widget)widget.get()).setImageName(data.getImageName());
        }
        if (data.getCategory() != null) {
            ((Widget)widget.get()).setCategory(data.getCategory());
        }
        if (data.getIsDefaultDashboard() != null) {
            ((Widget)widget.get()).setIsDefaultDashboard(data.getIsDefaultDashboard());
        }
        if (data.getEnabled() != null) {
            ((Widget)widget.get()).setEnabled(data.getEnabled());
        }
        if (data.getExport() != null) {
            ((Widget)widget.get()).setExport(data.getExport());
        }
        if (data.getDashboardGroup() != null) {
            ((Widget)widget.get()).setDashboardGroup(data.getDashboardGroup());
        }
        if (data.getDashboardLayout() != null) {
            ((Widget)widget.get()).setDashboardLayout(data.getDashboardLayout());
        }
        this.widgetRepository.save(widget.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("Dashboard Updated Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional category = this.widgetRepository.findById(Integer.valueOf(ids));
            if (category.isPresent()) {
                addValue.add(category.get());
                this.widgetRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAll() {
        Optional widgetType = this.widgetTypeRepository.findById(Integer.valueOf(9));
        List list = this.widgetRepository.findAllByWidgetType((WidgetType)widgetType.get());
        ArrayList<DashboardWidgetModel> addValue = new ArrayList<DashboardWidgetModel>();
        RequestResponse returnValue = new RequestResponse();
        for (Widget widget : list) {
            DashboardWidgetModel data = new DashboardWidgetModel();
            if (widget.getApi() != null) {
                data.setApi(widget.getApi().getId());
            }
            data.setCategory(widget.getCategory());
            data.setChartType(widget.getChartType());
            data.setCode(widget.getCode());
            data.setDashboardGroup(widget.getDashboardGroup());
            data.setEnabled(widget.getEnabled());
            data.setExport(widget.getExport());
            data.setHasWebSocketUpdate(widget.getHasWebSocketUpdate());
            data.setId(widget.getId());
            data.setImageName(widget.getImageName());
            data.setIsDefaultDashboard(widget.getIsDefaultDashboard());
            data.setLegendFieldDataType(widget.getLegendFieldDataType());
            data.setName(widget.getName());
            data.setRefreshInterval(widget.getRefreshInterval());
            if (widget.getSensor() != null) {
                data.setSensor(widget.getSensor().getId());
            }
            data.setValueFieldDataType(widget.getValueFieldDataType());
            data.setWidgetType(widget.getWidgetType().getId());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getFilteredList(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = DashboardWidgetViewSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.dashboardWidgetViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.dashboardWidgetViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<DashboardWidgetModel> entityToModelConversion(List<DashboardWidgetView> widgets) {
        ArrayList<DashboardWidgetModel> addValue = new ArrayList<DashboardWidgetModel>();
        for (DashboardWidgetView row : widgets) {
            DashboardWidgetModel data = new DashboardWidgetModel();
            data.setId(row.getId());
            if (row.getApi() != null) {
                data.setApi(row.getApi());
            }
            data.setCategory(row.getCategory());
            data.setChartType(row.getChartType());
            data.setCode(row.getCode());
            data.setDashboardGroup(row.getDashboardGroup());
            data.setEnabled(row.getEnabled());
            data.setExport(row.getExport());
            data.setHasWebSocketUpdate(row.getHasWebSocketUpdate());
            data.setImageName(row.getImageName());
            data.setIsDefaultDashboard(row.getIsDefaultDashboard());
            data.setLegendFieldDataType(row.getLegendFieldDataType());
            data.setName(row.getName());
            data.setRefreshInterval(row.getRefreshInterval());
            if (row.getSensor() != null) {
                data.setSensor(row.getSensor());
            }
            data.setValueFieldDataType(row.getValueFieldDataType());
            data.setDashboardLayout(row.getDashboardLayout());
            addValue.add(data);
        }
        return addValue;
    }
}

