/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.m_tenantmaster.service;

import com.coraltele.db.telephony.pbx.entity.CLIServerCommandLog;
import com.coraltele.db.telephony.pbx.entity.TenantMaster;
import com.coraltele.db.telephony.pbx.repository.TenantMasterRepository;
import com.coraltele.db.telephony.pbx.specification.TenantMasterSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.helper.ReturnField;
import com.coraltele.model.CliCommandData;
import com.coraltele.model.InputAction;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.cLIServerCommandLog.service.CLIServerCommandLogService;
import com.coraltele.service.pbx.m_tenantmaster.model.TenantMasterModel;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class TenantMasterService {
    private static final Logger logger = LogManager.getLogger(TenantMasterService.class);
    @Autowired
    private TenantMasterRepository tenantMasterRepository;
    @Autowired
    private CLIServerCommandLogService cLIServerCommandLogService;

    public RequestResponse createTenantMaster(TenantMasterModel data) {
        logger.debug("create new extension : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            TenantMaster tenantMaster = new TenantMaster();
            tenantMaster.setName(data.getName());
            tenantMaster.setCode(data.getCode());
            tenantMaster.setPrefix(data.getPrefix());
            this.tenantMasterRepository.save((Object)tenantMaster);
            ReturnField field = new ReturnField();
            field.setId(tenantMaster.getId().intValue());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("TenantMaster Registered");
            returnValue.setMessageDetail("TenantMaster created successfully");
            returnValue.setData((Object)field);
            logger.info(" TenantMaster saved : {}", (Object)returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("unable to create TenantMaster");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getById(int id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional tenantMaster = this.tenantMasterRepository.findById(Integer.valueOf(id));
            if (tenantMaster.isPresent()) {
                TenantMasterModel data = new TenantMasterModel();
                data.setId(((TenantMaster)tenantMaster.get()).getId());
                data.setCode(((TenantMaster)tenantMaster.get()).getCode());
                data.setName(((TenantMaster)tenantMaster.get()).getName());
                data.setPrefix(((TenantMaster)tenantMaster.get()).getPrefix());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("tenantMaster Found");
                returnValue.setData((Object)data);
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Unable to return value");
                returnValue.setMessageDetail("Records not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("contact with administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getAll() {
        List list = (List)this.tenantMasterRepository.findAll();
        ArrayList<TenantMasterModel> addValue = new ArrayList<TenantMasterModel>();
        RequestResponse returnValue = new RequestResponse();
        for (TenantMaster tenantMaster : list) {
            TenantMasterModel data = new TenantMasterModel();
            data.setId(tenantMaster.getId());
            data.setCode(tenantMaster.getCode());
            data.setName(tenantMaster.getName());
            data.setPrefix(tenantMaster.getPrefix());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateTenantMaster(HttpServletRequest request, TenantMasterModel data, Authentication authentication) {
        logger.debug("Update tenantMaster {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional tenantMaster = this.tenantMasterRepository.findById(data.getId());
            if (tenantMaster.isPresent()) {
                ((TenantMaster)tenantMaster.get()).setCode(data.getCode());
                ((TenantMaster)tenantMaster.get()).setName(data.getName());
                ((TenantMaster)tenantMaster.get()).setPrefix(data.getPrefix());
                this.tenantMasterRepository.save(tenantMaster.get());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Updated");
                returnValue.setMessageDetail("tenantMaster Updated successfully");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("tenantMaster not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to update tenantMaster");
            returnValue.setMessageDetail("please Contact to administrator");
            logger.error("error while fetching the data.", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse deleteTenantMaster(int id) {
        RequestResponse returnValue = new RequestResponse();
        Optional tenantMaster = this.tenantMasterRepository.findById(Integer.valueOf(id));
        if (!tenantMaster.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("Records not found");
        } else {
            this.tenantMasterRepository.deleteById((Object)id);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Deleted");
            returnValue.setMessageDetail("Data deleted successfully");
        }
        return returnValue;
    }

    public void saveData(HttpServletRequest request, TenantMaster tenantMaster, Authentication authentication) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper().findAndRegisterModules();
        Map newMap = (Map)new ObjectMapper().readValue((InputStream)request.getInputStream(), Map.class);
        Set entrySet = newMap.entrySet();
        Iterator iterator = entrySet.iterator();
        ArrayList<InputAction> addValue = new ArrayList<InputAction>();
        CliCommandData cliCommandData = new CliCommandData();
        try {
            if (tenantMaster.getId() != null && this.tenantMasterRepository.findById(tenantMaster.getId()).isPresent()) {
                Optional oldData = this.tenantMasterRepository.findById(tenantMaster.getId());
                Map oldMap = (Map)objectMapper.convertValue(oldData.get(), Map.class);
                while (iterator.hasNext()) {
                    Map.Entry mapEntry = iterator.next();
                    InputAction inputValue = new InputAction();
                    inputValue.setFieldName(mapEntry.getKey());
                    inputValue.setNewValue(mapEntry.getValue());
                    for (Map.Entry set : oldMap.entrySet()) {
                        if (!mapEntry.getKey().equals(set.getKey())) continue;
                        inputValue.setOldValue(set.getValue());
                    }
                    addValue.add(inputValue);
                }
                cliCommandData.setData(addValue);
                cliCommandData.setEntity("m_tenantmaster");
                String dataReceived = objectMapper.writeValueAsString(addValue);
                CLIServerCommandLog dataLogs = new CLIServerCommandLog();
                dataLogs.setCLICommand(dataReceived);
                dataLogs.setRecordSource("dl");
                dataLogs.setServerCode("");
                dataLogs.setRecordCreatedBy(authentication.getName());
                dataLogs.setRecordCreatedOn(LocalDateTime.now());
                dataLogs.setOutputFileName("Name");
                dataLogs.setOutputFilePath("");
                this.cLIServerCommandLogService.save(dataLogs);
            }
        }
        catch (JsonProcessingException e) {
            logger.info((Object)e);
        }
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = TenantMasterSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "name" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "name" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.tenantMasterRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.tenantMasterRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional tenantMaster = this.tenantMasterRepository.findById(Integer.valueOf(ids));
            if (tenantMaster.isPresent()) {
                addValue.add(tenantMaster.get());
                this.tenantMasterRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("TenantMaster Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

