/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.fwdExtension.service;

import com.coraltele.db.telephony.pbx.entity.FwdExtension;
import com.coraltele.db.telephony.pbx.repository.FwdExtensionRepository;
import com.coraltele.db.telephony.pbx.specification.FwdExtensionSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.fwdExtension.model.FwdExtConversionModel;
import com.coraltele.service.pbx.fwdExtension.model.FwdExtDExtDayWiseModel;
import com.coraltele.service.pbx.fwdExtension.model.FwdExtModel;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FwdExtensionService {
    private static final Logger logger = LogManager.getLogger(FwdExtensionService.class);
    @Autowired
    FwdExtensionRepository fwdExtensionRepository;

    public RequestResponse createData(FwdExtModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        if (!StringUtils.hasText((String)data.getExtension()) || !StringUtils.hasText((String)data.getForwardExtension()) || data.getFromTime().equals("null")) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Improper data on creation");
            returnValue.setMessageDetail("Missing parameter either extension or fwdExtension or time");
            logger.error(returnValue.getMessageDetail());
            return returnValue;
        }
        if (data.getExtension().equals(data.getForwardExtension())) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Both extension have same");
            returnValue.setMessageDetail("Select different extension for call forward");
            logger.error(returnValue.getMessageDetail());
            return returnValue;
        }
        try {
            if (!this.checkExistingData(data)) {
                FwdExtension record = new FwdExtension();
                record.setCreatedBy(principal.getName());
                record.setCreatedOn(LocalDateTime.now());
                record.setExtension(data.getExtension());
                record.setMonday(Integer.valueOf(data.getMonday() != null ? 1 : 0));
                record.setTuesday(Integer.valueOf(data.getTuesday() != null ? 1 : 0));
                record.setThursday(Integer.valueOf(data.getThursday() != null ? 1 : 0));
                record.setWednesday(Integer.valueOf(data.getWednesday() != null ? 1 : 0));
                record.setFriday(Integer.valueOf(data.getFriday() != null ? 1 : 0));
                record.setSaturday(Integer.valueOf(data.getSaturday() != null ? 1 : 0));
                record.setSunday(Integer.valueOf(data.getSunday() != null ? 1 : 0));
                record.setFromTime(data.getFromTime());
                record.setToTime(data.getToTime());
                record.setForwardExtension(data.getForwardExtension());
                this.fwdExtensionRepository.save((Object)record);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("OK");
                returnValue.setMessageDetail("New fwdExtension Created Successfully");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("selected extension of same day and time already exist");
                returnValue.setMessageDetail("select different time or day");
                logger.error(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create data");
            returnValue.setMessageDetail("Contact With administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public boolean checkExistingData(FwdExtModel data) {
        List records = new ArrayList();
        if (data.getMonday() != null && data.getMonday().equals(1)) {
            records = this.fwdExtensionRepository.findByExtensionAndMonday(data.getExtension(), Integer.valueOf(1));
        } else if (data.getTuesday() != null && data.getTuesday().equals(1)) {
            records = this.fwdExtensionRepository.findByExtensionAndTuesday(data.getExtension(), Integer.valueOf(1));
        } else if (data.getWednesday() != null && data.getWednesday().equals(1)) {
            records = this.fwdExtensionRepository.findByExtensionAndWednesday(data.getExtension(), Integer.valueOf(1));
        } else if (data.getThursday() != null && data.getThursday().equals(1)) {
            records = this.fwdExtensionRepository.findByExtensionAndThursday(data.getExtension(), Integer.valueOf(1));
        } else if (data.getFriday() != null && data.getFriday().equals(1)) {
            records = this.fwdExtensionRepository.findByExtensionAndFriday(data.getExtension(), Integer.valueOf(1));
        } else if (data.getSaturday() != null && data.getSaturday().equals(1)) {
            records = this.fwdExtensionRepository.findByExtensionAndSaturday(data.getExtension(), Integer.valueOf(1));
        } else if (data.getSunday() != null && data.getSunday().equals(1)) {
            records = this.fwdExtensionRepository.findByExtensionAndSunday(data.getExtension(), Integer.valueOf(1));
        }
        for (FwdExtension row : records) {
            if (!data.getFromTime().equals(row.getFromTime()) && !data.getFromTime().equals(row.getToTime()) && !data.getToTime().equals(row.getFromTime()) && !data.getToTime().equals(row.getToTime()) && (!data.getFromTime().isBefore(row.getToTime()) || !data.getToTime().isAfter(row.getFromTime()))) continue;
            return true;
        }
        return false;
    }

    public RequestResponse update(FwdExtModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        Optional fwdExt = this.fwdExtensionRepository.findById((Object)data.getId());
        if (!fwdExt.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("Data Not Found");
            logger.error(returnValue.getMessage());
            return returnValue;
        }
        if (data.getForwardExtension() != null) {
            ((FwdExtension)fwdExt.get()).setForwardExtension(data.getForwardExtension());
        }
        if (data.getFromTime() != null) {
            ((FwdExtension)fwdExt.get()).setFromTime(data.getFromTime());
        }
        if (data.getToTime() != null) {
            ((FwdExtension)fwdExt.get()).setToTime(data.getToTime());
        }
        ((FwdExtension)fwdExt.get()).setUpdatedBy(principal.getName());
        ((FwdExtension)fwdExt.get()).setUpdatedOn(LocalDateTime.now());
        this.fwdExtensionRepository.save(fwdExt.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("Updated Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getListByDayAndExt(String day, String extension) {
        List fwdExt;
        RequestResponse returnValue = new RequestResponse();
        ArrayList<FwdExtDExtDayWiseModel> response = new ArrayList<FwdExtDExtDayWiseModel>();
        if (day.equalsIgnoreCase("Sunday")) {
            fwdExt = this.fwdExtensionRepository.findByExtensionAndSunday(extension, Integer.valueOf(1));
        } else if (day.equalsIgnoreCase("Monday")) {
            fwdExt = this.fwdExtensionRepository.findByExtensionAndMonday(extension, Integer.valueOf(1));
        } else if (day.equalsIgnoreCase("Tuesday")) {
            fwdExt = this.fwdExtensionRepository.findByExtensionAndTuesday(extension, Integer.valueOf(1));
        } else if (day.equalsIgnoreCase("Wednesday")) {
            fwdExt = this.fwdExtensionRepository.findByExtensionAndWednesday(extension, Integer.valueOf(1));
        } else if (day.equalsIgnoreCase("Thursday")) {
            fwdExt = this.fwdExtensionRepository.findByExtensionAndThursday(extension, Integer.valueOf(1));
        } else if (day.equalsIgnoreCase("Friday")) {
            fwdExt = this.fwdExtensionRepository.findByExtensionAndFriday(extension, Integer.valueOf(1));
        } else if (day.equalsIgnoreCase("Saturday")) {
            fwdExt = this.fwdExtensionRepository.findByExtensionAndSaturday(extension, Integer.valueOf(1));
        } else {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid Day");
            returnValue.setMessageDetail("The provided day is not valid.");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (fwdExt.isEmpty()) {
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("No Data Found");
            returnValue.setMessageDetail("No Forward Extensions found for the given day and extension.");
            returnValue.setData(Collections.emptyList());
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        for (FwdExtension row : fwdExt) {
            FwdExtDExtDayWiseModel data = new FwdExtDExtDayWiseModel();
            data.setId(row.getId());
            data.setFromTime(row.getFromTime());
            data.setToTime(row.getToTime());
            data.setForwardExtension(row.getForwardExtension());
            response.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("list of records");
        returnValue.setData(response);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllFwdExtensionByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = FwdExtensionSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extension" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extension" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.fwdExtensionRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.fwdExtensionRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<FwdExtConversionModel> entityToModelConversion(List<FwdExtension> fwdExt) {
        ArrayList<FwdExtConversionModel> addValue = new ArrayList<FwdExtConversionModel>();
        for (FwdExtension row : fwdExt) {
            FwdExtConversionModel data = new FwdExtConversionModel();
            data.setCreatedOn(row.getCreatedOn());
            data.setExtension(row.getExtension());
            data.setId(row.getId());
            data.setCreatedBy(row.getCreatedBy());
            data.setFromTime(row.getFromTime());
            data.setToTime(row.getToTime());
            if (row.getSunday() != null && row.getSunday() == 1) {
                data.setSunday("Yes");
            } else {
                data.setSunday("No");
            }
            if (row.getMonday() != null && row.getMonday() == 1) {
                data.setMonday("Yes");
            } else {
                data.setMonday("No");
            }
            if (row.getTuesday() != null && row.getTuesday() == 1) {
                data.setTuesday("Yes");
            } else {
                data.setTuesday("No");
            }
            if (row.getWednesday() != null && row.getWednesday() == 1) {
                data.setWednesday("Yes");
            } else {
                data.setWednesday("No");
            }
            if (row.getThursday() != null && row.getThursday() == 1) {
                data.setThursday("Yes");
            } else {
                data.setThursday("No");
            }
            if (row.getFriday() != null && row.getFriday() == 1) {
                data.setFriday("Yes");
            } else {
                data.setFriday("No");
            }
            if (row.getSaturday() != null && row.getSaturday() == 1) {
                data.setSaturday("Yes");
            } else {
                data.setSaturday("No");
            }
            data.setForwardExtension(row.getForwardExtension());
            data.setUpdatedBy(row.getUpdatedBy());
            data.setUpdatedOn(data.getUpdatedOn());
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse deleteById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional fwdData = this.fwdExtensionRepository.findById((Object)ids);
            if (fwdData.isPresent()) {
                addValue.add(fwdData.get());
                this.fwdExtensionRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

