/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.conferenceMeeting.conferenceParticipant.service;

import com.coraltele.db.telephony.main.entity.Channels;
import com.coraltele.db.telephony.main.repository.ChannelsRepository;
import com.coraltele.db.telephony.pbx.entity.ConferenceParticipant;
import com.coraltele.db.telephony.pbx.entity.ConfigureConference;
import com.coraltele.db.telephony.pbx.entity.EmailDetail;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.repository.ConferenceDetailsRepository;
import com.coraltele.db.telephony.pbx.repository.ConferenceParticipantRepository;
import com.coraltele.db.telephony.pbx.repository.ConferenceRoomRepository;
import com.coraltele.db.telephony.pbx.repository.ConfigureConferenceRepository;
import com.coraltele.db.telephony.pbx.repository.EmailDetailRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.telephony.pbx.specification.ConferenceParticipantSpecification;
import com.coraltele.db.telephony.pbx.specification.ConferenceParticipantSpecification1;
import com.coraltele.helper.BashCmd;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.helper.Telephony;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.pbx.service.CDRService;
import com.coraltele.service.pbx.conferenceMeeting.conferenceParticipant.model.ActiveCallModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceParticipant.model.ActiveMemberModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceParticipant.model.ConferenceModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceParticipant.model.ConferenceParticipantModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceParticipant.model.ExtensionListModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceParticipant.model.LiveCallJsonModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceParticipant.model.ParticipantEmailModel;
import com.coraltele.service.pbx.controlRluServer.service.ControlRluServerService;
import com.coraltele.service.pbx.extension.service.AuthExtensionService;
import com.coraltele.service.pbx.extension.service.ExtensionsService;
import com.coraltele.service.user.service.UserService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Service
public class ConferenceParticipantService {
    private static final Logger logger = LogManager.getLogger(ConferenceParticipantService.class);
    @Autowired
    ConferenceParticipantRepository conferenceParticipantRepository;
    @Autowired
    EmailDetailRepository emailDetailsRepository;
    @Autowired
    ConfigureConferenceRepository configureConferenceRepository;
    @Autowired
    ConferenceRoomRepository conferenceRoomRepository;
    @Autowired
    ExtensionsRepository extensionRepository;
    @Autowired
    ExtensionsService extensionService;
    @Autowired
    CDRService cdrService;
    @Autowired
    ChannelsRepository channelsRepository;
    @Autowired
    BashCmd bashCmd;
    @Autowired
    ControlRluServerService controlRluServerService;
    @Autowired
    AuthExtensionService authExtensionService;
    @Autowired
    ExtensionsRepository extensionsRepository;
    @Autowired
    UserService userService;
    @Autowired
    ConferenceDetailsRepository conferenceRoomParticipantRepository;

    public String generateFourDigitRandom() {
        Random random = new Random();
        int randomValue = random.nextInt(9000) + 1000;
        return String.valueOf(randomValue);
    }

    public RequestResponse createData(ParticipantEmailModel data, Authentication authentication) {
        logger.debug("create new conferenceParticipant : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            String extensions;
            ConferenceParticipant conferenceParticipant = new ConferenceParticipant();
            Optional conferenceData = this.configureConferenceRepository.findById(data.getConfigureConferrerId());
            if (conferenceData.isPresent()) {
                conferenceParticipant.setAccessCode(((ConfigureConference)conferenceData.get()).getAccessCode());
            }
            conferenceParticipant.setConferencePassword(this.generateFourDigitRandom());
            conferenceParticipant.setCreatedBy(authentication.getName());
            conferenceParticipant.setCreatedOn(LocalDateTime.now());
            conferenceParticipant.setDialTry(data.getDialTry());
            conferenceParticipant.setDialed(data.getDialed());
            conferenceParticipant.setEmailId(data.getEmailId());
            conferenceParticipant.setEmailSent(data.getEmailSent());
            conferenceParticipant.setIsModeratorRecord(Integer.valueOf(0));
            conferenceParticipant.setMobileNumber(data.getMobileNumber());
            conferenceParticipant.setNoOfTry(data.getNoOfTry());
            conferenceParticipant.setParticipantName(data.getParticipantName());
            conferenceParticipant.setParticipantType(Integer.valueOf(0));
            conferenceParticipant.setRemainderDial(Boolean.valueOf(false));
            conferenceParticipant.setRetryDelay(data.getRetryDelay());
            conferenceParticipant.setSmsSent(data.getSmsSent());
            conferenceParticipant.setMemberType(data.getMemberType());
            Integer idToCheck = data.getConfigureConferrerId();
            boolean exists = this.configureConferenceRepository.existsById(idToCheck);
            if (exists) {
                extensions = data.getExtensions();
                boolean combinationExists = this.conferenceParticipantRepository.existsByConfigureConferrerIdAndExtensions(idToCheck, extensions);
                if (combinationExists) {
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("Please Select The Different Extension");
                    returnValue.setMessageDetail("Extension Already Assigned");
                    logger.error(returnValue.getMessage() + "-" + returnValue.getMessageDetail());
                    return returnValue;
                }
            } else {
                throw new IllegalArgumentException("Invalid ConfigureConferrerId");
            }
            conferenceParticipant.setConfigureConferrerId(idToCheck);
            conferenceParticipant.setExtensions(extensions);
            conferenceParticipant.setExtensions(data.getExtensions());
            Optional conferenceRoom = this.conferenceRoomRepository.findById(((ConfigureConference)conferenceData.get()).getRoomId());
            EmailDetail emailDetails = new EmailDetail();
            emailDetails.setAccessCode(conferenceParticipant.getAccessCode());
            emailDetails.setAttachmentName(data.getAttachmentName());
            emailDetails.setAttachmentPath(data.getAttachmentPath());
            emailDetails.setCidName(data.getCidName());
            emailDetails.setCli(data.getCli());
            emailDetails.setCodeType(data.getCodeType());
            emailDetails.setConferencePassword(conferenceParticipant.getConferencePassword());
            emailDetails.setCreatedTime(LocalDateTime.now());
            emailDetails.setEmailBcc(data.getEmailBcc());
            emailDetails.setEmailCc(data.getEmailCc());
            emailDetails.setEmailId(conferenceParticipant.getEmailId());
            emailDetails.setExecutionTime(data.getExecutionTime());
            emailDetails.setFromUser(authentication.getName());
            emailDetails.setIsSent(data.getIsSent());
            emailDetails.setLocation(data.getLocation());
            emailDetails.setMailSubject("new");
            emailDetails.setMeetingDate(((ConfigureConference)conferenceData.get()).getScheduledDate());
            emailDetails.setMeetingFromTime(((ConfigureConference)conferenceData.get()).getFromTime());
            emailDetails.setMeetingToTime(((ConfigureConference)conferenceData.get()).getToTime());
            emailDetails.setParticipant(conferenceParticipant.getParticipantName());
            emailDetails.setRemarks(data.getRemarks());
            emailDetails.setStatus(data.getStatus());
            emailDetails.setToUser(data.getToUser());
            emailDetails.setType("conf");
            emailDetails.setUuid(data.getUuid());
            this.conferenceParticipantRepository.save((Object)conferenceParticipant);
            this.emailDetailsRepository.save((Object)emailDetails);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("ConferenceParticipant Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create ConferenceParticipant");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse deleteConferenceParticipantById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional conferenceParticipant = this.conferenceParticipantRepository.findById(Integer.valueOf(ids));
            if (conferenceParticipant.isPresent()) {
                addValue.add(conferenceParticipant.get());
                this.conferenceParticipantRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateById(ConferenceParticipantModel data, Authentication authentication) {
        logger.debug("Update conferenceParticipant {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional conferenceParticipant = this.conferenceParticipantRepository.findById(data.getId());
        if (!conferenceParticipant.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("ConferenceParticipant Not Found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getAccessCode() != null) {
            ((ConferenceParticipant)conferenceParticipant.get()).setAccessCode(data.getAccessCode());
        }
        if (data.getConferencePassword() != null) {
            ((ConferenceParticipant)conferenceParticipant.get()).setConferencePassword(data.getConferencePassword());
        }
        if (data.getCreatedBy() != null) {
            ((ConferenceParticipant)conferenceParticipant.get()).setCreatedBy(data.getCreatedBy());
        }
        if (data.getCreatedOn() != null) {
            ((ConferenceParticipant)conferenceParticipant.get()).setCreatedOn(data.getCreatedOn());
        }
        if (data.getDialTry() != null) {
            ((ConferenceParticipant)conferenceParticipant.get()).setDialTry(data.getDialTry());
        }
        if (data.getDialed() != null) {
            ((ConferenceParticipant)conferenceParticipant.get()).setDialed(data.getDialed());
        }
        if (data.getEmailId() != null) {
            ((ConferenceParticipant)conferenceParticipant.get()).setEmailId(data.getEmailId());
        }
        if (data.getEmailSent() != null) {
            ((ConferenceParticipant)conferenceParticipant.get()).setEmailSent(data.getEmailSent());
        }
        if (data.getExtensions() != null) {
            ((ConferenceParticipant)conferenceParticipant.get()).setExtensions(data.getExtensions());
        }
        if (data.getIsModeratorRecord() != null) {
            ((ConferenceParticipant)conferenceParticipant.get()).setIsModeratorRecord(data.getEmailSent());
        }
        if (data.getMobileNumber() != null) {
            ((ConferenceParticipant)conferenceParticipant.get()).setMobileNumber(data.getMobileNumber());
        }
        if (data.getNoOfTry() != null) {
            ((ConferenceParticipant)conferenceParticipant.get()).setNoOfTry(data.getNoOfTry());
        }
        if (data.getParticipantName() != null) {
            ((ConferenceParticipant)conferenceParticipant.get()).setParticipantName(data.getParticipantName());
        }
        if (data.getParticipantType() != null) {
            ((ConferenceParticipant)conferenceParticipant.get()).setParticipantType(data.getParticipantType());
        }
        if (data.getRemainderDial() != null) {
            ((ConferenceParticipant)conferenceParticipant.get()).setRemainderDial(data.getRemainderDial());
        }
        if (data.getRetryDelay() != null) {
            ((ConferenceParticipant)conferenceParticipant.get()).setRetryDelay(data.getRetryDelay());
        }
        if (data.getSmsSent() != null) {
            ((ConferenceParticipant)conferenceParticipant.get()).setSmsSent(data.getSmsSent());
        }
        if (data.getConfigureConferrerId() != null) {
            ((ConferenceParticipant)conferenceParticipant.get()).setConfigureConferrerId(data.getConfigureConferrerId());
        }
        ((ConferenceParticipant)conferenceParticipant.get()).setModifiedOn(LocalDateTime.now());
        ((ConferenceParticipant)conferenceParticipant.get()).setModifiedBy(authentication.getName());
        this.conferenceParticipantRepository.save(conferenceParticipant.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("ConferenceParticipant Updated Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllConferenceParticipantByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ConferenceParticipantSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.conferenceParticipantRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.conferenceParticipantRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllConferenceParticipantByFilter1(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ConferenceParticipantSpecification1.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.conferenceParticipantRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.conferenceParticipantRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getExtensionList() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList extList = new ArrayList();
        List list = this.extensionRepository.findByExtensionType("phone");
        if (list != null && !list.isEmpty()) {
            list.forEach(row -> {
                ExtensionListModel data = new ExtensionListModel(row.getId(), row.getExtension());
                extList.add(data);
            });
            logger.info("extension list of type phone");
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("list of nodes");
            returnValue.setMessageDetail("Total records:" + list.size());
            returnValue.setData(extList);
        } else {
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Empty list of extension!");
            logger.error(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getAllParticipantByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ConferenceParticipantSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.conferenceParticipantRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.conferenceParticipantRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getParticipantList(Integer conferenceId) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<ConferenceParticipantModel> addValue = new ArrayList<ConferenceParticipantModel>();
        List list = this.conferenceParticipantRepository.findByConfigureConferrerId(conferenceId);
        if (list != null && !list.isEmpty()) {
            for (ConferenceParticipant participantData : list) {
                if (participantData.getIsModeratorRecord().equals(1)) continue;
                ConferenceParticipantModel data = new ConferenceParticipantModel();
                data.setId(participantData.getId());
                data.setParticipantName(participantData.getParticipantName());
                data.setAccessCode(participantData.getAccessCode());
                data.setCreatedBy(participantData.getCreatedBy());
                data.setCreatedOn(participantData.getCreatedOn());
                data.setConfigureConferrerId(participantData.getConfigureConferrerId());
                data.setConferencePassword(participantData.getConferencePassword());
                data.setEmailId(participantData.getEmailId());
                data.setDialTry(participantData.getDialTry());
                data.setExtensions(participantData.getExtensions());
                data.setMobileNumber(participantData.getMobileNumber());
                data.setParticipantType(participantData.getParticipantType());
                data.setIsModeratorRecord(participantData.getIsModeratorRecord());
                data.setBlockedStatus(participantData.getBarred());
                if (participantData.getParticipantName() != null) {
                    data.setIsVip(Boolean.valueOf(this.userService.userIsVip(participantData.getParticipantName())));
                }
                addValue.add(data);
            }
            logger.info("participant list");
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("list of participants");
            returnValue.setData(addValue);
        } else {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Empty list of participants!");
            returnValue.setData(addValue);
            logger.error(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse makeConferenceMeetingCall(Integer conferenceId, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        String moderatorNumber = this.extensionService.getExtensionOfUser(principal.getName());
        String accessCode = "";
        try {
            String ip = this.cdrService.getIpFeatureServer();
            ArrayList<String> participantNumberList = new ArrayList<String>();
            List participantList = this.conferenceParticipantRepository.findByConfigureConferrerId(conferenceId);
            accessCode = ((ConferenceParticipant)participantList.get(0)).getAccessCode();
            if (!participantList.isEmpty()) {
                for (ConferenceParticipant participant : participantList) {
                    String extensionNumber = participant.getMobileNumber();
                    participantNumberList.add(extensionNumber);
                }
            } else {
                logger.error("Not any record exist of given Conference:{}", (Object)conferenceId);
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("No data present in given Conference");
                return returnValue;
            }
            logger.info("List of Participant number:{}", participantNumberList);
            String exitPreviousConf = String.format("fs_cli -x \"bgapi conference %s hup all \"", accessCode);
            logger.info("exist previous conference of same id:{}", (Object)exitPreviousConf);
            Telephony.makeCallBackCall((String)exitPreviousConf);
            if (!participantNumberList.isEmpty()) {
                for (String participantNumber : participantNumberList) {
                    logger.info("Caller:{} and destination:{}", (Object)moderatorNumber, (Object)participantNumber);
                    String command = "";
                    command = this.extensionService.isExtensionUCType(participantNumber) ? String.format("fs_cli -x \"bgapi originate{origination_caller_id_number=Conference} user/%s &conference(%s)\"", participantNumber, accessCode) : String.format("fs_cli -x \"bgapi originate {origination_caller_id_number=Conference}sofia/internal/%s@%s &conference(%s)\"", participantNumber, ip, accessCode);
                    logger.info("command to execute call :{}", (Object)command);
                    Telephony.makeCallBackCall((String)command);
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("Call execute successfully");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error during call initiation:{}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to execute call");
        }
        return returnValue;
    }

    public RequestResponse stopCall(Integer conferenceId) {
        RequestResponse returnValue = new RequestResponse();
        String accessCode = conferenceId.toString();
        try {
            String command = String.format("fs_cli -x \"bgapi conference %s hup all \"", accessCode);
            logger.info("command to execute call :{}", (Object)command);
            Telephony.makeCallBackCall((String)command);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Call stop successfully");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error on call cmd:{}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to stop call");
        }
        return returnValue;
    }

    public RequestResponse callToParticipant(Principal principal, ConferenceModel data) {
        RequestResponse returnValue = new RequestResponse();
        String accessCode = data.getConferenceId().toString();
        String ip = this.cdrService.getIpFeatureServer();
        String callerNumber = this.authExtensionService.getExtensionOfUser(principal.getName());
        String callerIdName = "ConferenceCall";
        logger.info("ConferenceCall participantNumber:{} accesscode: {} conferenceNumber:{},isModerator:{} \",participantNumber,accessCode,conferenceNumber,isModerator); ");
        String rluCode = this.controlRluServerService.getRluCodeFinal(callerNumber);
        String sofiaProfile = this.controlRluServerService.getProfileName(callerNumber);
        logger.info("sofiaProfile : {} rluCode : {}", (Object)sofiaProfile, (Object)rluCode);
        String rluIP = this.controlRluServerService.getVirtualIp(rluCode);
        try {
            String command = "";
            if (Constants.BACKWARD_COMPATIBILITY.booleanValue()) {
                if (data.getIsModerator() != null && data.getIsModerator().booleanValue()) {
                    for (String participant : data.getParticipantNumber()) {
                        rluCode = this.controlRluServerService.getRluCodeFinal(participant);
                        rluIP = this.controlRluServerService.getVirtualIp(rluCode);
                        logger.info("rluCode for dialing conference for moderator and participant:{}", (Object)rluCode);
                        logger.info("rluIp for dialing conference for moderator and participant:{}", (Object)rluIP);
                        command = String.format("fs_cli -H %s -x \"bgapi originate {absoulte_codec_string='PCMU,PCMA',origination_caller_id_number=%s,origination_caller_id_name='%s',sip_h_X-coral_dial_type=ConferenceCall,sip_h_X-Conferencecall=%s}user/%s &transfer(%s)\"", rluIP, data.getConferenceNumber(), callerIdName, accessCode, participant, data.getConferenceNumber());
                        logger.info("command to execute joining conference :{}", (Object)command);
                        Telephony.makeCallBackCall((String)command);
                    }
                } else {
                    for (String participant : data.getParticipantNumber()) {
                        rluCode = this.controlRluServerService.getRluCodeFinal(participant);
                        rluIP = this.controlRluServerService.getVirtualIp(rluCode);
                        logger.info("rluCode for dialing participant conference:{}", (Object)rluCode);
                        logger.info("rluIp for dialing participant conference", (Object)rluIP);
                        command = String.format("fs_cli -H %s -x \"bgapi originate {absoulte_codec_string='PCMU,PCMA',origination_caller_id_number=%s,origination_caller_id_name='%s',sip_h_X-coral_dial_type=ConferenceCall,sip_h_X-Conferencecall=%s}user/%s &transfer(%s)\"", rluIP, data.getConferenceNumber(), callerIdName, accessCode, participant, data.getConferenceNumber());
                        logger.info("command to execute dialing conference :{}", (Object)command);
                        Telephony.makeCallBackCall((String)command);
                    }
                }
            } else {
                for (String participant : data.getParticipantNumber()) {
                    if (this.extensionService.isExtensionUCType(participant)) {
                        command = String.format("fs_cli -x \"bgapi originate {origination_caller_id_number=Conference,absolute_codec_string='PCMU,PCMA'}user/%s &conference(%s)\"", participant, accessCode);
                        logger.info("command to execute conference :{}", (Object)command);
                        continue;
                    }
                    command = String.format("fs_cli -x \"bgapi originate {origination_caller_id_number=Conference,absolute_codec_string='PCMU,PCMA'}sofia/%s/%s@%s &conference(%s)\"", sofiaProfile, participant, ip, accessCode);
                    logger.info("command to execute conference :{}", (Object)command);
                    Telephony.makeCallBackCall((String)command);
                }
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("make call successfully");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error on call cmd:{}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to make call");
        }
        return returnValue;
    }

    public RequestResponse callToParticipant1(Principal principal, String participantNumber, String conferenceId, String conferenceNumber, Boolean isModerator) {
        RequestResponse returnValue = new RequestResponse();
        String moderatorNumber = this.extensionService.getExtensionOfUser(principal.getName());
        String accessCode = conferenceId.toString();
        String ip = this.cdrService.getIpFeatureServer();
        String callerNumber = this.authExtensionService.getExtensionOfUser(principal.getName());
        String callerIdName = "ConferenceCall";
        logger.info("ConferenceCall participantNumber:{} accesscode: {} conferenceNumber:{},isModerator:{}", (Object)participantNumber, (Object)accessCode, (Object)conferenceNumber, (Object)isModerator);
        String rluCode = this.controlRluServerService.getRluCodeFinal(callerNumber);
        String sofiaProfile = this.controlRluServerService.getProfileName(callerNumber);
        logger.info("sofiaProfile : {} rluCode : {}", (Object)sofiaProfile, (Object)rluCode);
        String rluIP = this.controlRluServerService.getVirtualIp(rluCode);
        try {
            String command = "";
            if (Constants.CLICK_TO_CALL_REMOTE_SERVER != null && Constants.CLICK_TO_CALL_REMOTE_SERVER.booleanValue()) {
                rluIP = Constants.CLICK_TO_CALL_REMOTE_IP != null && !Constants.CLICK_TO_CALL_REMOTE_IP.isEmpty() ? Constants.CLICK_TO_CALL_REMOTE_IP : this.controlRluServerService.getVirtualIp(rluCode);
                logger.info("rluCode for joining conference:{}", (Object)rluCode);
                logger.info("rluIp for joining conference:{}", (Object)rluIP);
                command = String.format("fs_cli -H %s -x \"bgapi originate {absoulte_codec_string='PCMU,PCMA',origination_caller_id_number=%s,origination_caller_id_name='%s',sip_h_X-Conferencecall=%s}user/%s &transfer(%s)\"", rluIP, conferenceNumber, callerIdName, accessCode, participantNumber, conferenceNumber);
            } else {
                if (Constants.CLICK_TO_CALL_REMOTE_IP != null && !Constants.CLICK_TO_CALL_REMOTE_IP.isEmpty()) {
                    rluIP = Constants.CLICK_TO_CALL_REMOTE_IP;
                } else {
                    rluCode = this.controlRluServerService.getRluCodeFinal(participantNumber);
                    rluIP = this.controlRluServerService.getVirtualIp(rluCode);
                }
                logger.info("rluCode for dialing conference:{}", (Object)rluCode);
                logger.info("rluIp for dialing conference:{}", (Object)rluIP);
                command = String.format("fs_cli -H %s -x \"bgapi originate {absoulte_codec_string='PCMU,PCMA',origination_caller_id_number=%s,origination_caller_id_name='%s',sip_h_X-Conferencecall=%s}user/%s &transfer(%s)\"", rluIP, conferenceNumber, callerIdName, accessCode, participantNumber, conferenceNumber);
            }
            logger.info("command to execute call :{}", (Object)command);
            Telephony.makeCallBackCall((String)command);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("make call successfully");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error on call cmd:{}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to make call");
        }
        return returnValue;
    }

    public RequestResponse getActiveCallDetails(String conferenceNumber) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<ActiveCallModel> activeCallList = new ArrayList<ActiveCallModel>();
        String filePath = "/tmp/conference" + conferenceNumber + ".xml";
        try {
            String command = String.format("fs_cli -x \"conference %s xml_list\"", conferenceNumber);
            logger.info("final Command is: {}", (Object)command);
            String xmlResponse = this.bashCmd.executeCommand(command);
            logger.info("XML Response: {}", (Object)xmlResponse);
            if (xmlResponse == null || xmlResponse.trim().isEmpty() || xmlResponse.contains("-ERR Conference " + conferenceNumber + " not found")) {
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("No meeting exists");
                returnValue.setMessageDetail("Not any participant joined the meeting");
                return returnValue;
            }
            this.createXMLFile(xmlResponse, filePath);
            File xmlFile = new File(filePath);
            if (!xmlFile.exists()) {
                logger.error("XML file does not exist at the specified path: {}", (Object)filePath);
                returnValue.setMessage("XML file does not exist at the specified path.");
                return returnValue;
            }
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(xmlFile);
            doc.getDocumentElement().normalize();
            NodeList conferenceNodeList = doc.getElementsByTagName("conference");
            for (int i = 0; i < conferenceNodeList.getLength(); ++i) {
                Element conferenceElement = (Element)conferenceNodeList.item(i);
                NodeList memberList = conferenceElement.getElementsByTagName("member");
                for (int j = 0; j < memberList.getLength(); ++j) {
                    Element memberElement;
                    String memberType;
                    Node memberNode = memberList.item(j);
                    if (memberNode.getNodeType() != 1 || !"caller".equals(memberType = (memberElement = (Element)memberNode).getAttribute("type"))) continue;
                    ActiveCallModel activeCall = new ActiveCallModel();
                    activeCall.setId(memberElement.getElementsByTagName("id").item(0).getTextContent());
                    activeCall.setUuid(memberElement.getElementsByTagName("uuid").item(0).getTextContent());
                    activeCall.setCanHear(memberElement.getElementsByTagName("can_hear").item(0).getTextContent());
                    activeCall.setCanSee(memberElement.getElementsByTagName("can_see").item(0).getTextContent());
                    activeCall.setCanSpeak(memberElement.getElementsByTagName("can_speak").item(0).getTextContent());
                    activeCall.setMuteDetect(memberElement.getElementsByTagName("mute_detect").item(0).getTextContent());
                    activeCall.setTalking(memberElement.getElementsByTagName("talking").item(0).getTextContent());
                    activeCall.setContact(this.getContact(activeCall.getUuid()));
                    activeCall.setIsHandRaised(this.getIsHandRaised(activeCall.getUuid()));
                    activeCall.setHasVideo(memberElement.getElementsByTagName("has_video").item(0).getTextContent());
                    activeCallList.add(activeCall);
                }
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("List retrieved successfully");
            returnValue.setData(activeCallList);
        }
        catch (IllegalArgumentException e) {
            this.handleException(returnValue, "Invalid XML Response", (Exception)e);
        }
        catch (ParserConfigurationException e) {
            this.handleException(returnValue, "Parser Configuration Error", (Exception)e);
        }
        catch (SAXException e) {
            this.handleException(returnValue, "Error Parsing XML", (Exception)e);
        }
        catch (IOException e) {
            this.handleException(returnValue, "IO Error", (Exception)e);
        }
        catch (Exception e) {
            this.handleException(returnValue, "Error on getting call detail", e);
        }
        return returnValue;
    }

    private void handleException(RequestResponse returnValue, String message, Exception e) {
        returnValue.setStatus(Constants.Error.ERROR);
        returnValue.setMessage(message);
        returnValue.setMessageDetail(e.getMessage());
        logger.error("{}: {}", (Object)message, (Object)e.getMessage());
    }

    public void createXMLFile(String xmlResponse, String filePath) {
        try {
            File oldFile = new File(filePath);
            if (oldFile.exists()) {
                oldFile.delete();
            }
            FileWriter writer = new FileWriter(filePath);
            writer.write(xmlResponse);
            writer.close();
            logger.info("XML file created successfully at:{}", (Object)filePath);
        }
        catch (IOException e) {
            logger.error("Error creating XML file: {}", (Object)e.getMessage());
        }
    }

    public String getContact(String uuid) {
        String contact = "";
        Optional channelData = this.channelsRepository.findByUuid(uuid);
        if (channelData.isPresent()) {
            contact = ((Channels)channelData.get()).getCoralOriginalNum();
        }
        return contact;
    }

    public Integer getIsHandRaised(String uuid) {
        Integer isHandRaised = null;
        Optional channelData = this.channelsRepository.findByUuid(uuid);
        if (channelData.isPresent()) {
            isHandRaised = ((Channels)channelData.get()).getIsHandRaised();
        }
        return isHandRaised;
    }

    public RequestResponse handRaiseUpdate(String uuid) {
        RequestResponse returnValue = new RequestResponse();
        Optional channelData = this.channelsRepository.findByUuid(uuid);
        if (channelData.isPresent()) {
            ((Channels)channelData.get()).setIsHandRaised(Integer.valueOf(1));
            this.channelsRepository.save(channelData.get());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("hand raised successfully");
            logger.info(returnValue.getMessage());
        } else {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("data not found for raise hand");
            logger.error(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse muteMember(String action, String accessCode, String memberId) {
        RequestResponse returnValue = new RequestResponse();
        try {
            String command = "";
            if (action.equalsIgnoreCase("mute")) {
                command = String.format("fs_cli -x \"bgapi conference %s mute %s \"", accessCode, memberId);
                logger.info("command for mute selected member :{}", (Object)command);
                returnValue.setMessage("member mute successfully");
            } else {
                command = String.format("fs_cli -x \"bgapi conference %s unmute %s \"", accessCode, memberId);
                logger.info("command for unMute selected member :{}", (Object)command);
                returnValue.setMessage("member unMute successfully");
            }
            Telephony.makeCallBackCall((String)command);
            returnValue.setStatus(Constants.Error.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error on mute cmd:{}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to mute/unMute member");
        }
        return returnValue;
    }

    public RequestResponse muteAll(String action, String accessCode) {
        RequestResponse returnValue = new RequestResponse();
        try {
            String command = "";
            if (action.equalsIgnoreCase("mute")) {
                command = String.format("fs_cli -x \"bgapi conference %s mute non_moderator\"", accessCode);
                logger.info("command for mute selected member :{}", (Object)command);
                Telephony.makeCallBackCall((String)command);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("member mute successfully");
            } else {
                command = String.format("fs_cli -x \"bgapi conference %s unmute all \"", accessCode);
                logger.info("command for unMute selected member :{}", (Object)command);
                Telephony.makeCallBackCall((String)command);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("member unMute successfully");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error on mute cmd:{}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to mute/unMute member");
        }
        return returnValue;
    }

    public RequestResponse allowUserToSpeak(String confNumber, String accessCode, String memberId, String moderatorMemberId) {
        RequestResponse returnValue = new RequestResponse();
        logger.info("conferenceNumber,accessCode and memberId for below code is:{},{}", (Object)confNumber, (Object)accessCode, (Object)memberId);
        try {
            List channelList = this.channelsRepository.findByConferenceNumber(confNumber);
            if (!channelList.isEmpty()) {
                String command1 = String.format("fs_cli -x \"conference %s mute non_moderator\"", accessCode);
                logger.info("command to mute all :{}", (Object)command1);
                Telephony.makeCallBackCall((String)command1);
                String command2 = String.format("fs_cli -x \"conference %s unmute %s\"", accessCode, memberId);
                logger.info("command to unMute selected member :{}", (Object)command2);
                Telephony.makeCallBackCall((String)command2);
                for (Channels row : channelList) {
                    row.setIsHandRaised(Integer.valueOf(0));
                    this.channelsRepository.save((Object)row);
                }
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("No active conference exist");
                logger.error("There is no any conference exist of given destNumber:{}", (Object)accessCode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error during unMute raiseHand user for speak :{}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to unMute user");
        }
        return returnValue;
    }

    public RequestResponse removeMember(String accessCode, String memberId, String extension) {
        RequestResponse returnValue = new RequestResponse();
        try {
            String command = "";
            command = String.format("fs_cli -x \"bgapi conference %s kick %s \"", accessCode, memberId);
            logger.info("command for remove selected member :{}", (Object)command);
            returnValue.setMessage("member remove successfully");
            Optional getParticipant = this.conferenceParticipantRepository.findByExtensionsAndAccessCode(extension, accessCode);
            if (getParticipant.isPresent()) {
                ((ConferenceParticipant)getParticipant.get()).setBarred(Integer.valueOf(1));
                this.conferenceParticipantRepository.save(getParticipant.get());
            }
            Telephony.makeCallBackCall((String)command);
            returnValue.setStatus(Constants.Error.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error on execute cmd:{}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to remove member");
        }
        return returnValue;
    }

    public RequestResponse unblockMember(String accessCode, String extension) {
        RequestResponse returnValue = new RequestResponse();
        Optional getParticipant = this.conferenceParticipantRepository.findByExtensionsAndAccessCode(extension, accessCode);
        if (getParticipant.isPresent()) {
            ((ConferenceParticipant)getParticipant.get()).setBarred(Integer.valueOf(0));
            this.conferenceParticipantRepository.save(getParticipant.get());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("member unblock successfully");
        } else {
            logger.error("unable to find member for unblock:{},accessCode:{}", (Object)extension, (Object)accessCode);
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to unblock member");
        }
        return returnValue;
    }

    public RequestResponse getActiveCallsByJson(String conferenceNumber) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<ActiveCallModel> activeCallList = new ArrayList<ActiveCallModel>();
        try {
            String command = String.format("fs_cli -x \"conference %s json_list\"", conferenceNumber);
            logger.info("Final command is: {}", (Object)command);
            String jsonResponse = this.bashCmd.executeCommand(command);
            logger.info("JSON Response: {}", (Object)jsonResponse);
            if (jsonResponse == null || jsonResponse.trim().isEmpty() || jsonResponse.contains("-ERR Conference " + conferenceNumber + " not found")) {
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("No meeting exists");
                returnValue.setMessageDetail("No participants have joined the meeting");
                return returnValue;
            }
            ObjectMapper objectMapper = new ObjectMapper();
            LiveCallJsonModel[] liveCallArray = (LiveCallJsonModel[])objectMapper.readValue(jsonResponse, LiveCallJsonModel[].class);
            if (liveCallArray.length > 0) {
                LiveCallJsonModel liveCall = liveCallArray[0];
                for (ActiveMemberModel member : liveCall.getMembers()) {
                    if (!"caller".equals(member.getType())) continue;
                    ActiveCallModel activeCall = new ActiveCallModel();
                    activeCall.setId(member.getId().toString());
                    activeCall.setUuid(member.getUuid());
                    activeCall.setCanHear(member.getFlags().getCanHear().toString());
                    activeCall.setCanSee(member.getFlags().getCanSee().toString());
                    activeCall.setCanSpeak(member.getFlags().getCanSpeak().toString());
                    activeCall.setMuteDetect(member.getFlags().getMuteDetect().toString());
                    activeCall.setTalking(member.getFlags().getTalking().toString());
                    activeCall.setContact(this.getContact(activeCall.getUuid()));
                    activeCall.setIsHandRaised(this.getIsHandRaised(activeCall.getUuid()));
                    activeCallList.add(activeCall);
                }
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("List retrieved successfully");
            returnValue.setData(activeCallList);
        }
        catch (IOException | IllegalArgumentException e) {
            this.handleException(returnValue, "Error occurred while processing JSON response", e);
        }
        catch (Exception e) {
            this.handleException(returnValue, "Unexpected error occurred while getting call details", e);
        }
        return returnValue;
    }

    public String getRluCodeForCaller(String extension) {
        Optional data = this.extensionsRepository.findByExtension(extension);
        if (data.isPresent()) {
            return ((Extension)data.get()).getRluCode();
        }
        return "";
    }
}

