/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.autoAttendant.service;

import com.coraltele.db.coralapps.callcenter.entity.IVRLanguage;
import com.coraltele.db.telephony.pbx.entity.AutoAttendant;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.entity.IVRManager;
import com.coraltele.db.telephony.pbx.repository.AutoAttendantRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.telephony.pbx.repository.IVRManagerRepository;
import com.coraltele.db.telephony.pbx.specification.AutoAttendantSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.IVRUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.callcenter.IVRLanguage.service.IVRLanguageService;
import com.coraltele.service.pbx.autoAttendant.model.AutoAttendantDropDownModel;
import com.coraltele.service.pbx.autoAttendant.model.AutoAttendantModel;
import com.coraltele.service.pbx.autoAttendant.model.IVRNode;
import com.coraltele.service.pbx.autoAttendant.model.IVRTree;
import com.coraltele.service.pbx.autoAttendant.model.LTSModel;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AutoAttendantService {
    private static final Logger logger = LogManager.getLogger(AutoAttendantService.class);
    private static String iVRFilePath = "/usr/local/freeswitch/sounds/";
    @Autowired
    private AutoAttendantRepository autoAttendantRepository;
    @Autowired
    IVRManagerRepository ivrManagerRepository;
    @Autowired
    private IVRUtility iVRUtility;
    @Autowired
    IVRLanguageService ivrLanguageService;
    @Autowired
    ExtensionsRepository extensionsRepository;
    String message;

    public RequestResponse createAutoAttendant(AutoAttendantModel data) {
        logger.debug("create new AutoAttendant : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            AutoAttendant autoAttendant = new AutoAttendant();
            autoAttendant.setDescription(data.getAccessDesc());
            autoAttendant.setCallType(data.getCallType());
            autoAttendant.setCreatedOn(LocalDateTime.now());
            autoAttendant.setDefaultXFrDay(data.getDefaultXFrDay());
            autoAttendant.setDefaultXFrNight(data.getDefaultXFrNight());
            autoAttendant.setExtension(data.getExtension());
            autoAttendant.setIntroFile(data.getIntroFile());
            autoAttendant.setInvalidFileName(data.getInvalidFileName());
            autoAttendant.setIvrLanguage(data.getIvrLanguage());
            autoAttendant.setMaxInput(data.getMaxInput());
            autoAttendant.setMaxRetryFilename(data.getMaxRetryFilename());
            autoAttendant.setMaxRetry(data.getMaxRetry());
            autoAttendant.setNoInputFilename(data.getNoInputFilename());
            autoAttendant.setOnEight(data.getOnEight());
            autoAttendant.setOnEightDesc(data.getOnEightDesc());
            autoAttendant.setOnEightNight(data.getOnEightNight());
            autoAttendant.setOnFive(data.getOnFive());
            autoAttendant.setOnFiveDesc(data.getOnFiveDesc());
            autoAttendant.setOnFiveNight(data.getOnFiveNight());
            autoAttendant.setOnFour(data.getOnFour());
            autoAttendant.setOnFourDesc(data.getOnFourDesc());
            autoAttendant.setOnFourNight(data.getOnFourNight());
            autoAttendant.setOnNine(data.getOnNine());
            autoAttendant.setOnNineDesc(data.getOnNineDesc());
            autoAttendant.setOnNineNight(data.getOnNineNight());
            autoAttendant.setOnOne(data.getOnOne());
            autoAttendant.setOnOneDesc(data.getOnOneDesc());
            autoAttendant.setOnOneNight(data.getOnOneNight());
            autoAttendant.setOnSeven(data.getOnSeven());
            autoAttendant.setOnSevenDesc(data.getOnSevenDesc());
            autoAttendant.setOnSevenNight(data.getOnSevenNight());
            autoAttendant.setOnSix(data.getOnSix());
            autoAttendant.setOnSixDesc(data.getOnSixDesc());
            autoAttendant.setOnSixNight(data.getOnSixNight());
            autoAttendant.setOnThree(data.getOnThree());
            autoAttendant.setOnThreeDesc(data.getOnThreeDesc());
            autoAttendant.setOnThreeNight(data.getOnThreeNight());
            autoAttendant.setOnTwo(data.getOnTwo());
            autoAttendant.setOnTwoDesc(data.getOnTwoDesc());
            autoAttendant.setOnTwoNight(data.getOnTwoNight());
            autoAttendant.setOnZero(data.getOnZero());
            autoAttendant.setOnZero(data.getOnZero());
            autoAttendant.setOnZeroDesc(data.getOnZeroDesc());
            autoAttendant.setOnZeroNight(data.getOnZeroNight());
            autoAttendant.setOperator(data.getOperator());
            autoAttendant.setWaitTime(data.getWaitTime());
            autoAttendant.setWelcomeFile(data.getWelcomeFile());
            autoAttendant.setIsParent(Boolean.valueOf(true));
            autoAttendant.setIvrGroup(data.getExtension());
            this.autoAttendantRepository.save((Object)autoAttendant);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("autoAttendant created successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to create autoAttendant");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    private void addPlayFile(HashMap<String, AutoAttendant> records, String ivrGroup, String extension, String playFileName) {
        AutoAttendant aaStep = new AutoAttendant();
        aaStep.setExtension(extension);
        aaStep.setCreatedOn(LocalDateTime.now());
        aaStep.setIvrGroup(ivrGroup);
        aaStep.setIsParent(Boolean.valueOf(false));
        aaStep.setIntroFile(playFileName);
        aaStep.setNodeType("PF");
        records.put(extension, aaStep);
    }

    @Transactional(value="switchTransactionManager")
    public RequestResponse updateAutoAttendant(IVRTree data) {
        RequestResponse returnValue = new RequestResponse();
        Boolean hasLanguage = false;
        String superParentKey = "";
        try {
            HashMap<String, AutoAttendant> records = new HashMap<String, AutoAttendant>();
            for (IVRNode key : data.getIvrNodes()) {
                AutoAttendant aaStep;
                String parentKey = key.getParentLevelId();
                if (key.getProperties() != null && key.getProperties().getMaxInput() == null && StringUtils.hasLength((String)key.getProperties().getIntroFile())) {
                    key.getProperties().setMaxInput(Integer.valueOf(1));
                }
                if (hasLanguage.booleanValue() && parentKey.equals(superParentKey)) {
                    parentKey = parentKey + "_L";
                }
                if (parentKey.equals(key.getLevelId())) {
                    hasLanguage = true;
                    superParentKey = parentKey;
                    this.createParentRecord(records, data, key, parentKey);
                    continue;
                }
                if (records.containsKey(parentKey)) {
                    aaStep = (AutoAttendant)records.get(parentKey);
                } else {
                    aaStep = new AutoAttendant();
                    this.nodeTree(data.getIvrGroup(), aaStep, parentKey, key);
                    records.put(parentKey, aaStep);
                }
                String onKey = key.getLevelId();
                String keyDescription = key.getName();
                if (StringUtils.hasLength((String)key.getProperties().getDescription())) {
                    keyDescription = key.getProperties().getDescription();
                }
                if (key.getNodeType().equals("EXT")) {
                    onKey = key.getProperties().getExtensionForwardTo();
                } else if (key.getNodeType().equals("PF")) {
                    this.addPlayFile(records, data.getIvrGroup(), onKey, key.getProperties().getPlayFileFileName());
                } else if (key.getNodeType().equals("LTS")) {
                    LTSModel updatedOnKey = this.getLevelId(key.getProperties().getLtsReferenceCode(), data.getIvrNodes());
                    onKey = updatedOnKey.getLevelId();
                    keyDescription = updatedOnKey.getName();
                }
                this.assignKey(aaStep, key, onKey, keyDescription);
            }
            this.saveAutoAttendantData(records, data);
        }
        catch (Exception e) {
            logger.error("Unable to save the data", (Throwable)e);
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to save data");
            throw new IllegalArgumentException("Unable to save the data");
        }
        return returnValue;
    }

    private void createParentRecord(HashMap<String, AutoAttendant> records, IVRTree data, IVRNode node, String parentKey) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        String ivrData = objectMapper.writeValueAsString((Object)data);
        if (node.getProperties().getIvrLanguage() != null && node.getProperties().getIvrLanguage().booleanValue()) {
            AutoAttendant aaLanguageStep = new AutoAttendant();
            aaLanguageStep.setIvrDetails(ivrData);
            this.languageStep(data.getIvrGroup(), aaLanguageStep, parentKey, node);
            records.put(parentKey, aaLanguageStep);
            AutoAttendant aaStep = new AutoAttendant();
            this.treeAfterLanguage(data.getIvrGroup(), aaStep, parentKey, node);
            records.put(parentKey + "_L", aaStep);
        } else {
            AutoAttendant aaStep = new AutoAttendant();
            aaStep.setIvrDetails(ivrData);
            this.startTree(ivrData, aaStep, parentKey, node);
            records.put(parentKey, aaStep);
        }
    }

    private void saveAutoAttendantData(HashMap<String, AutoAttendant> records, IVRTree data) {
        this.autoAttendantRepository.findByIvrGroup(data.getIvrGroup()).forEach(row -> this.autoAttendantRepository.delete(row));
        List pendingAutoAttendant = this.autoAttendantRepository.findByIvrGroup(data.getIvrGroup());
        this.ivrManagerRepository.findByIvrGroup(data.getIvrGroup()).forEach(row -> this.ivrManagerRepository.delete(row));
        List pendingIVRManager = this.ivrManagerRepository.findByIvrGroup(data.getIvrGroup());
        List extensions = this.extensionsRepository.findByExtGroupId(data.getIvrGroup());
        extensions.forEach(extension -> this.extensionsRepository.delete(extension));
        extensions = this.extensionsRepository.findByExtGroupId(data.getIvrGroup());
        logger.info("Pending Auto Attendant {}", (Object)pendingAutoAttendant.size());
        logger.info("Pending IVR Manager {}", (Object)pendingIVRManager.size());
        logger.info("Pending extension {}", (Object)extensions.size());
        records.forEach((key, aaStep) -> {
            Boolean isIVR;
            IVRNode nodeConfiguration = this.getIVRNode(aaStep.getExtension(), data.getIvrNodes());
            if (nodeConfiguration != null && !aaStep.getIsParent().booleanValue()) {
                aaStep.setNodeType(nodeConfiguration.getNodeType());
            }
            if (!(isIVR = Boolean.valueOf(StringUtils.hasLength((String)aaStep.getNodeType()) && aaStep.getNodeType().equals("API"))).booleanValue()) {
                if (nodeConfiguration != null && !aaStep.getNodeType().equals("LANG-SEL")) {
                    aaStep.setWelcomeFile(nodeConfiguration.getProperties().getWelcomeFile());
                    aaStep.setIntroFile(nodeConfiguration.getProperties().getIntroFile());
                    aaStep.setWaitTime(nodeConfiguration.getProperties().getWaitTime());
                    aaStep.setMaxInput(nodeConfiguration.getProperties().getMaxInput());
                    aaStep.setMaxRetry(nodeConfiguration.getProperties().getMaxRetry());
                    aaStep.setMaxRetryFilename(nodeConfiguration.getProperties().getMaxRetryFileName());
                    aaStep.setInvalidFileName(nodeConfiguration.getProperties().getInvalidFileName());
                    aaStep.setNoInputFilename(nodeConfiguration.getProperties().getNoInputFileName());
                    if (StringUtils.hasLength((String)nodeConfiguration.getProperties().getPlayFileFileName())) {
                        aaStep.setIntroFile(nodeConfiguration.getProperties().getPlayFileFileName());
                    }
                }
                logger.info("Saving Auto Attendant Data for row for step : {}", (Object)aaStep.getExtension());
                this.autoAttendantRepository.save(aaStep);
            } else {
                this.saveIVR(aaStep, data.getIvrNodes()).forEach(row -> {
                    logger.info("Saving IVR Data for row for step : {} : {}", (Object)aaStep.getExtension(), (Object)row.getNumber());
                    this.ivrManagerRepository.save(row);
                });
            }
            if (!aaStep.getIsParent().booleanValue()) {
                Extension extension = new Extension();
                extension.setExtension(aaStep.getExtension());
                extension.setExtensionType(isIVR != false ? "ivr" : "autoattendant");
                extension.setExtGroupId(data.getIvrGroup());
                logger.info("Generating extension for Auto attendant {} : {}", (Object)extension.getExtensionType(), (Object)extension.getExtension());
                this.extensionsRepository.save((Object)extension);
            }
        });
    }

    private void assignKey(AutoAttendant aaStep, IVRNode key, String onKey, String keyDescription) {
        if (key.getDtmf().equals("0")) {
            aaStep.setOnZero(onKey);
            aaStep.setOnZeroDesc(keyDescription);
        } else if (!StringUtils.hasLength((String)key.getApiResponseType()) && key.getDtmf().equals("1") || StringUtils.hasLength((String)key.getApiResponseType()) && key.getApiResponseType().equals("ON-SUCCESS")) {
            aaStep.setOnOne(onKey);
            aaStep.setOnOneDesc(keyDescription);
        } else if (!StringUtils.hasLength((String)key.getApiResponseType()) && key.getDtmf().equals("2") || StringUtils.hasLength((String)key.getApiResponseType()) && key.getApiResponseType().equals("ON-FAIL")) {
            aaStep.setOnTwo(onKey);
            aaStep.setOnTwoDesc(key.getName());
        } else if (key.getDtmf().equals("3")) {
            aaStep.setOnThree(onKey);
            aaStep.setOnThreeDesc(keyDescription);
        } else if (key.getDtmf().equals("4")) {
            aaStep.setOnFour(onKey);
            aaStep.setOnFourDesc(keyDescription);
        } else if (key.getDtmf().equals("5")) {
            aaStep.setOnFive(onKey);
            aaStep.setOnFiveDesc(onKey);
        } else if (key.getDtmf().equals("6")) {
            aaStep.setOnSix(onKey);
            aaStep.setOnSixDesc(keyDescription);
        } else if (key.getDtmf().equals("7")) {
            aaStep.setOnSeven(onKey);
            aaStep.setOnSevenDesc(keyDescription);
        } else if (key.getDtmf().equals("8")) {
            aaStep.setOnEight(onKey);
            aaStep.setOnEightDesc(keyDescription);
        } else if (key.getDtmf().equals("9")) {
            aaStep.setOnNine(onKey);
            aaStep.setOnNineDesc(keyDescription);
        } else if (key.getDtmf().equals("*")) {
            aaStep.setOnStar(onKey);
            aaStep.setOnStarDesc(keyDescription);
        } else if (key.getDtmf().equals("#")) {
            aaStep.setOnHash(onKey);
            aaStep.setOnHashDesc(keyDescription);
        }
    }

    private List<IVRManager> saveIVR(AutoAttendant aaStep, IVRNode[] prop) {
        ArrayList<IVRManager> returnValue = new ArrayList<IVRManager>();
        IVRManager start = null;
        IVRManager start1 = null;
        IVRManager stepSuccess = null;
        IVRManager stepFail = null;
        IVRNode nodeConfiguration = this.getIVRNode(aaStep.getExtension(), prop);
        if (nodeConfiguration != null) {
            if (StringUtils.hasLength((String)nodeConfiguration.getProperties().getReqVariableName()) && StringUtils.hasLength((String)nodeConfiguration.getProperties().getApiResponseFile())) {
                start1 = this.apiIVR("pa", nodeConfiguration, aaStep);
                start = this.apiIVR("start", nodeConfiguration, aaStep);
            } else if (StringUtils.hasLength((String)nodeConfiguration.getProperties().getVariableName())) {
                start1 = this.pioIVR("main", nodeConfiguration, aaStep);
                start = this.apiIVR("start", nodeConfiguration, aaStep);
            } else if (nodeConfiguration.getProperties().getApiResponseFile() != null && !nodeConfiguration.getProperties().getApiResponseFile().isEmpty()) {
                start1 = this.apiIVR("main1", nodeConfiguration, aaStep);
                start = this.apiIVR("start", nodeConfiguration, aaStep);
            } else if (nodeConfiguration.getProperties() != null && nodeConfiguration.getProperties().getApiResponseVariable() != null && !nodeConfiguration.getProperties().getApiResponseVariable().isEmpty() && nodeConfiguration.getProperties().getCpm() != null && nodeConfiguration.getProperties().getCpm().equals(true)) {
                start1 = this.apiIVR("cpm", nodeConfiguration, aaStep);
                start = this.apiIVR("start", nodeConfiguration, aaStep);
            } else {
                start1 = this.apiIVR("main", nodeConfiguration, aaStep);
                start = this.apiIVR("start", nodeConfiguration, aaStep);
            }
            stepSuccess = this.transferIVR("step-success", aaStep);
            stepFail = this.transferIVR("step-fail", aaStep);
        }
        if (start != null) {
            returnValue.add(start);
        }
        if (start1 != null) {
            returnValue.add(start1);
        }
        if (stepSuccess != null) {
            returnValue.add(stepSuccess);
        }
        if (stepFail != null) {
            returnValue.add(stepFail);
        }
        return returnValue;
    }

    private IVRNode getIVRNode(String extension, IVRNode[] prop) {
        IVRNode returnValue = null;
        for (IVRNode node : prop) {
            if (!node.getLevelId().equals(extension)) continue;
            returnValue = node;
            break;
        }
        return returnValue;
    }

    private void nodeTree(String ivrGroup, AutoAttendant aaStep, String parentKey, IVRNode node) {
        aaStep.setExtension(parentKey);
        aaStep.setCreatedOn(LocalDateTime.now());
        aaStep.setIvrGroup(ivrGroup);
        aaStep.setIsParent(Boolean.valueOf(false));
        aaStep.setDescription(node.getProperties().getDescription());
        if (node.getNodeType().equals("TREE")) {
            aaStep.setIntroFile(node.getProperties().getIntroFile());
            aaStep.setWaitTime(node.getProperties().getWaitTime());
            aaStep.setMaxInput(node.getProperties().getMaxInput());
            aaStep.setMaxRetry(node.getProperties().getMaxRetry());
            aaStep.setMaxRetryFilename(node.getProperties().getMaxRetryFileName());
            aaStep.setInvalidFileName(node.getProperties().getInvalidFileName());
            aaStep.setNoInputFilename(node.getProperties().getNoInputFileName());
        }
        aaStep.setNodeType(node.getNodeType());
    }

    private void startTree(String ivrGroup, AutoAttendant aaStep, String parentKey, IVRNode node) {
        aaStep.setExtension(parentKey);
        aaStep.setCreatedOn(LocalDateTime.now());
        aaStep.setIvrGroup(ivrGroup);
        aaStep.setIsParent(Boolean.valueOf(true));
        aaStep.setWaitTime(node.getProperties().getWaitTime());
        aaStep.setMaxInput(node.getProperties().getMaxInput());
        aaStep.setMaxRetry(node.getProperties().getMaxRetry());
        aaStep.setMaxRetryFilename(node.getProperties().getMaxRetryFileName());
        aaStep.setInvalidFileName(node.getProperties().getInvalidFileName());
        aaStep.setNoInputFilename(node.getProperties().getNoInputFileName());
        aaStep.setWelcomeFile(node.getProperties().getWelcomeFile());
        aaStep.setIntroFile(node.getProperties().getIntroFile());
        aaStep.setDescription(node.getProperties().getDescription());
        aaStep.setNodeType("ENTRY");
    }

    private void treeAfterLanguage(String ivrGroup, AutoAttendant aaStep, String parentKey, IVRNode node) {
        aaStep.setExtension(parentKey + "_L");
        aaStep.setCreatedOn(LocalDateTime.now());
        aaStep.setIvrGroup(ivrGroup);
        aaStep.setIsParent(Boolean.valueOf(false));
        aaStep.setDescription(node.getProperties().getDescription());
        aaStep.setWaitTime(node.getProperties().getWaitTime());
        aaStep.setMaxInput(node.getProperties().getMaxInput());
        aaStep.setMaxRetry(node.getProperties().getMaxRetry());
        aaStep.setMaxRetryFilename(node.getProperties().getMaxRetryFileName());
        aaStep.setInvalidFileName(node.getProperties().getInvalidFileName());
        aaStep.setNoInputFilename(node.getProperties().getNoInputFileName());
        aaStep.setIntroFile(node.getProperties().getIntroFile());
        aaStep.setNodeType("ENTRY");
    }

    private void languageStep(String ivrGroup, AutoAttendant aaLanguageStep, String parentKey, IVRNode node) {
        aaLanguageStep.setExtension(parentKey);
        aaLanguageStep.setCreatedOn(LocalDateTime.now());
        aaLanguageStep.setIvrGroup(ivrGroup);
        aaLanguageStep.setIsParent(Boolean.valueOf(true));
        aaLanguageStep.setIvrLanguage(Boolean.valueOf(true));
        aaLanguageStep.setOnOne(node.getProperties().getDefaultLanguage());
        aaLanguageStep.setOnTwo(node.getProperties().getAlternateLanguage1());
        aaLanguageStep.setOnThree(node.getProperties().getAlternateLanguage2());
        aaLanguageStep.setOnFour(node.getProperties().getAlternateLanguage3());
        aaLanguageStep.setOnFive(node.getProperties().getAlternateLanguage4());
        aaLanguageStep.setOnSix(node.getProperties().getAlternateLanguage5());
        aaLanguageStep.setOnSeven(node.getProperties().getAlternateLanguage6());
        aaLanguageStep.setOnEight(node.getProperties().getAlternateLanguage7());
        aaLanguageStep.setOnNine(node.getProperties().getAlternateLanguage8());
        aaLanguageStep.setOnZero(node.getProperties().getAlternateLanguage9());
        aaLanguageStep.setOnOneDesc(node.getProperties().getDefaultLanguage());
        aaLanguageStep.setOnTwoDesc(node.getProperties().getAlternateLanguage1());
        aaLanguageStep.setOnThreeDesc(node.getProperties().getAlternateLanguage2());
        aaLanguageStep.setOnFourDesc(node.getProperties().getAlternateLanguage3());
        aaLanguageStep.setOnFiveDesc(node.getProperties().getAlternateLanguage4());
        aaLanguageStep.setOnSixDesc(node.getProperties().getAlternateLanguage5());
        aaLanguageStep.setOnSevenDesc(node.getProperties().getAlternateLanguage6());
        aaLanguageStep.setOnEightDesc(node.getProperties().getAlternateLanguage7());
        aaLanguageStep.setOnNineDesc(node.getProperties().getAlternateLanguage8());
        aaLanguageStep.setOnZeroDesc(node.getProperties().getAlternateLanguage9());
        aaLanguageStep.setDescription(node.getProperties().getDescription());
        aaLanguageStep.setWaitTime(node.getProperties().getWaitTime());
        aaLanguageStep.setMaxInput(node.getProperties().getMaxInput());
        aaLanguageStep.setMaxRetry(node.getProperties().getMaxRetry());
        aaLanguageStep.setMaxRetryFilename(node.getProperties().getMaxRetryFileName());
        aaLanguageStep.setInvalidFileName(node.getProperties().getInvalidFileName());
        aaLanguageStep.setNoInputFilename(node.getProperties().getNoInputFileName());
        aaLanguageStep.setWelcomeFile(node.getProperties().getWelcomeFile());
        aaLanguageStep.setIntroFile(node.getProperties().getLanguageAnnouncement());
        aaLanguageStep.setOperator(parentKey + "_L");
        aaLanguageStep.setNodeType("LANG-SEL");
    }

    private IVRManager pioIVR(String step, IVRNode nodeConfiguration, AutoAttendant aaStep) {
        IVRManager returnValue = new IVRManager();
        String apiMethod = nodeConfiguration.getProperties().getApiMethod();
        String apiType = nodeConfiguration.getProperties().getApiType();
        returnValue.setType("pio");
        returnValue.setIvrGroup(aaStep.getIvrGroup());
        returnValue.setNumber(aaStep.getExtension());
        returnValue.setStep(step);
        returnValue.setDescription(nodeConfiguration.getProperties().getDescription());
        returnValue.setFilename(nodeConfiguration.getProperties().getApiResponseFile());
        returnValue.setOnsuccess("step-success");
        returnValue.setOnFail("step-fail");
        returnValue.setIvrGroup(aaStep.getIvrGroup());
        returnValue.setNumber(aaStep.getExtension());
        if (apiMethod != null && !apiMethod.isEmpty()) {
            if (apiType.equals("SOAP")) {
                this.generateSoapXML(apiMethod, nodeConfiguration.getProperties().getSoapContent());
            } else if (apiType.equals("REST")) {
                this.generateJsonFile(apiMethod, nodeConfiguration.getProperties().getSoapContent());
            }
        }
        returnValue.setCompType(nodeConfiguration.getProperties().getApiComparisonType());
        returnValue.setCompValue(nodeConfiguration.getProperties().getApiComparisonValue());
        returnValue.setVariableName(nodeConfiguration.getProperties().getVariableName());
        returnValue.setReqCustomParam(nodeConfiguration.getProperties().getReqCustomParam());
        returnValue.setVarNames(nodeConfiguration.getProperties().getReqVariableName());
        returnValue.setSoapReturn("");
        returnValue.setNoInputFile(nodeConfiguration.getProperties().getNoInputFileName());
        returnValue.setInvalidInputFile(nodeConfiguration.getProperties().getInvalidFileName());
        if (nodeConfiguration.getProperties().getMaxRetry() != null) {
            returnValue.setMaxRetry(nodeConfiguration.getProperties().getMaxRetry().toString());
        }
        returnValue.setMaxRetryFile(nodeConfiguration.getProperties().getMaxRetryFileName());
        returnValue.setInputTerminator(nodeConfiguration.getProperties().getInputTerminator());
        returnValue.setValidation(nodeConfiguration.getProperties().getValidation());
        returnValue.setInputBreak(nodeConfiguration.getProperties().getInputBreak());
        returnValue.setInputMin(nodeConfiguration.getProperties().getInputMin());
        returnValue.setInvalidInputSeq(nodeConfiguration.getProperties().getInvalidInputSeq());
        returnValue.setInputWaitTime(this.returnMilliseconds(nodeConfiguration.getProperties().getWaitTime()));
        if (nodeConfiguration.getProperties().getMaxInput() != null) {
            returnValue.setInputMax(nodeConfiguration.getProperties().getMaxInput().toString());
        }
        return returnValue;
    }

    private IVRManager apiIVR1(String step, IVRNode nodeConfiguration, AutoAttendant aaStep) {
        IVRManager returnValue = new IVRManager();
        String apiMethod = nodeConfiguration.getProperties().getApiMethod();
        String apiType = nodeConfiguration.getProperties().getApiType();
        if (step.equals("start")) {
            returnValue.setType("");
            returnValue.setDescription("entry point");
            returnValue.setNumber(aaStep.getExtension());
            returnValue.setStep("start");
            returnValue.setOnsuccess("main");
            returnValue.setIvrGroup(aaStep.getIvrGroup());
            return returnValue;
        }
        if (step.equals("main1")) {
            if (nodeConfiguration.getProperties().getApiResponseVariable() != null && !nodeConfiguration.getProperties().getApiResponseVariable().isEmpty()) {
                returnValue.setType("ad");
                returnValue.setIvrGroup(aaStep.getIvrGroup());
                returnValue.setNumber(aaStep.getExtension());
                returnValue.setStep("main");
                returnValue.setDescription(nodeConfiguration.getProperties().getDescription());
                returnValue.setOnsuccess("step-success");
                returnValue.setOnFail("step-fail");
                returnValue.setUrl(nodeConfiguration.getProperties().getApiURL());
                returnValue.setSoapMethod(nodeConfiguration.getProperties().getApiMethod());
                returnValue.setFilename(nodeConfiguration.getProperties().getApiResponseFile());
                returnValue.setCompType(nodeConfiguration.getProperties().getApiComparisonType());
                returnValue.setCompValue(nodeConfiguration.getProperties().getApiComparisonValue());
                returnValue.setVariableName(nodeConfiguration.getProperties().getApiResponseVariable());
                returnValue.setReqCustomParam(nodeConfiguration.getProperties().getReqCustomParam());
                returnValue.setVarNames(nodeConfiguration.getProperties().getReqVariableName());
                returnValue.setSoapReturn("");
                returnValue.setNoInputFile(nodeConfiguration.getProperties().getNoInputFileName());
                returnValue.setInvalidInputFile(nodeConfiguration.getProperties().getInvalidFileName());
                returnValue.setMaxRetryFile(nodeConfiguration.getProperties().getMaxRetryFileName());
                returnValue.setInputTerminator(nodeConfiguration.getProperties().getInputTerminator());
                returnValue.setValidation(nodeConfiguration.getProperties().getValidation());
                returnValue.setInputBreak(nodeConfiguration.getProperties().getInputBreak());
                returnValue.setInputMin(nodeConfiguration.getProperties().getInputMin());
                returnValue.setInvalidInputSeq(nodeConfiguration.getProperties().getInvalidInputSeq());
                returnValue.setInputWaitTime(this.returnMilliseconds(nodeConfiguration.getProperties().getWaitTime()));
                return returnValue;
            }
            returnValue.setType("pl");
            returnValue.setIvrGroup(aaStep.getIvrGroup());
            returnValue.setNumber(aaStep.getExtension());
            returnValue.setStep("main");
            returnValue.setDescription(nodeConfiguration.getProperties().getDescription());
            returnValue.setOnsuccess("step-success");
            returnValue.setOnFail("step-fail");
            returnValue.setUrl(nodeConfiguration.getProperties().getApiURL());
            returnValue.setSoapMethod(nodeConfiguration.getProperties().getApiMethod());
            returnValue.setFilename(nodeConfiguration.getProperties().getApiResponseFile());
            returnValue.setCompType(nodeConfiguration.getProperties().getApiComparisonType());
            returnValue.setCompValue(nodeConfiguration.getProperties().getApiComparisonValue());
            returnValue.setVariableName(nodeConfiguration.getProperties().getApiResponseVariable());
            returnValue.setReqCustomParam(nodeConfiguration.getProperties().getReqCustomParam());
            returnValue.setVarNames(nodeConfiguration.getProperties().getReqVariableName());
            returnValue.setSoapReturn("");
            returnValue.setNoInputFile(nodeConfiguration.getProperties().getNoInputFileName());
            returnValue.setInvalidInputFile(nodeConfiguration.getProperties().getInvalidFileName());
            if (nodeConfiguration.getProperties().getMaxRetry() != null) {
                returnValue.setMaxRetry(nodeConfiguration.getProperties().getMaxRetry().toString());
            }
            returnValue.setMaxRetryFile(nodeConfiguration.getProperties().getMaxRetryFileName());
            returnValue.setInputTerminator(nodeConfiguration.getProperties().getInputTerminator());
            returnValue.setValidation(nodeConfiguration.getProperties().getValidation());
            returnValue.setInputBreak(nodeConfiguration.getProperties().getInputBreak());
            returnValue.setInputMin(nodeConfiguration.getProperties().getInputMin());
            returnValue.setInvalidInputSeq(nodeConfiguration.getProperties().getInvalidInputSeq());
            returnValue.setInputWaitTime(this.returnMilliseconds(nodeConfiguration.getProperties().getWaitTime()));
            return returnValue;
        }
        returnValue.setType("api");
        returnValue.setIvrGroup(aaStep.getIvrGroup());
        returnValue.setNumber(aaStep.getExtension());
        returnValue.setStep(step);
        returnValue.setDescription(nodeConfiguration.getProperties().getDescription());
        returnValue.setOnsuccess("step-success");
        returnValue.setOnFail("step-fail");
        returnValue.setUrl(nodeConfiguration.getProperties().getApiURL());
        returnValue.setSoapMethod(nodeConfiguration.getProperties().getApiMethod());
        if (apiMethod != null && !apiMethod.isEmpty()) {
            if (apiType.equals("SOAP")) {
                this.generateSoapXML(apiMethod, nodeConfiguration.getProperties().getSoapContent());
            } else if (apiType.equals("REST")) {
                this.generateJsonFile(apiMethod, nodeConfiguration.getProperties().getSoapContent());
            }
        }
        returnValue.setFilename("");
        returnValue.setCompType(nodeConfiguration.getProperties().getApiComparisonType());
        returnValue.setCompValue(nodeConfiguration.getProperties().getApiComparisonValue());
        returnValue.setVariableName(nodeConfiguration.getProperties().getVariableName());
        returnValue.setReqCustomParam(nodeConfiguration.getProperties().getReqCustomParam());
        returnValue.setVarNames(nodeConfiguration.getProperties().getReqVariableName());
        returnValue.setSoapReturn("");
        returnValue.setNoInputFile(nodeConfiguration.getProperties().getNoInputFileName());
        returnValue.setInvalidInputFile(nodeConfiguration.getProperties().getInvalidFileName());
        returnValue.setMaxRetryFile(nodeConfiguration.getProperties().getMaxRetryFileName());
        returnValue.setInputTerminator(nodeConfiguration.getProperties().getInputTerminator());
        returnValue.setValidation(nodeConfiguration.getProperties().getValidation());
        returnValue.setInputBreak(nodeConfiguration.getProperties().getInputBreak());
        returnValue.setInputMin(nodeConfiguration.getProperties().getInputMin());
        returnValue.setInvalidInputSeq(nodeConfiguration.getProperties().getInvalidInputSeq());
        returnValue.setInputWaitTime(this.returnMilliseconds(nodeConfiguration.getProperties().getWaitTime()));
        return returnValue;
    }

    private IVRManager transferIVR(String step, AutoAttendant aaStep) {
        IVRManager returnValue = new IVRManager();
        returnValue.setType("t");
        returnValue.setIvrGroup(aaStep.getIvrGroup());
        returnValue.setNumber(aaStep.getExtension());
        returnValue.setStep(step);
        returnValue.setDescription(aaStep.getDescription());
        returnValue.setOnsuccess(step.equals("step-success") ? aaStep.getOnOne() : aaStep.getOnTwo());
        return returnValue;
    }

    public RequestResponse getAutoAttendantByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = AutoAttendantSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.autoAttendantRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.autoAttendantRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getIVRGroup(String ivrGroup) {
        RequestResponse returnValue = new RequestResponse();
        List data = this.autoAttendantRepository.findAllByIsParent(Boolean.valueOf(true));
        returnValue.setStatus(Constants.Error.ERROR);
        returnValue.setMessage("Unable to find data for " + ivrGroup);
        for (AutoAttendant autoAttendant : data) {
            if (autoAttendant.getIvrGroup() == null || !autoAttendant.getIvrGroup().equals(ivrGroup)) continue;
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                IVRTree ivr = (IVRTree)objectMapper.readValue(autoAttendant.getIvrDetails() == null ? "{\"key\":\"P\",\"name\":\"P\",\"dtmf\":null,\"dtmfValue\":null,\"ivrGroup\":\"" + ivrGroup + "\",\"children\":[]}" : autoAttendant.getIvrDetails(), IVRTree.class);
                returnValue.setData((Object)ivr);
            }
            catch (JsonProcessingException e) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Error while reading IVR " + ivrGroup);
                logger.error("Error while reading data {}", (Object)ivrGroup, (Object)e);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("");
        }
        return returnValue;
    }

    public RequestResponse getSimpleList() {
        logger.debug("create new AutoAttendant  ");
        RequestResponse returnValue = new RequestResponse();
        ArrayList<AutoAttendantModel> addValue = new ArrayList<AutoAttendantModel>();
        try {
            List list = this.autoAttendantRepository.findAllByIsParentOrderByDescriptionAscExtensionAsc(Boolean.valueOf(true));
            for (AutoAttendant data : list) {
                if (data.getIvrGroup() == null) continue;
                AutoAttendantModel autoAttendant = new AutoAttendantModel();
                autoAttendant.setAccessDesc(data.getDescription() != null && !data.getDescription().isEmpty() ? data.getDescription() + " (" + data.getExtension() + ")" : data.getExtension());
                autoAttendant.setCallType(data.getCallType());
                autoAttendant.setDefaultXFrDay(data.getDefaultXFrDay());
                autoAttendant.setDefaultXFrNight(data.getDefaultXFrNight());
                autoAttendant.setExtension(data.getExtension());
                autoAttendant.setIntroFile(data.getIntroFile());
                autoAttendant.setInvalidFileName(data.getInvalidFileName());
                autoAttendant.setIvrLanguage(data.getIvrLanguage());
                autoAttendant.setMaxInput(data.getMaxInput());
                autoAttendant.setMaxRetryFilename(data.getMaxRetryFilename());
                autoAttendant.setMaxRetry(data.getMaxRetry());
                autoAttendant.setNoInputFilename(data.getNoInputFilename());
                autoAttendant.setOnEight(data.getOnEight());
                autoAttendant.setOnEightDesc(data.getOnEightDesc());
                autoAttendant.setOnEightNight(data.getOnEightNight());
                autoAttendant.setOnFive(data.getOnFive());
                autoAttendant.setOnFiveDesc(data.getOnFiveDesc());
                autoAttendant.setOnFiveNight(data.getOnFiveNight());
                autoAttendant.setOnFour(data.getOnFour());
                autoAttendant.setOnFourDesc(data.getOnFourDesc());
                autoAttendant.setOnFourNight(data.getOnFourNight());
                autoAttendant.setOnNine(data.getOnNine());
                autoAttendant.setOnNineDesc(data.getOnNineDesc());
                autoAttendant.setOnNineNight(data.getOnNineNight());
                autoAttendant.setOnOne(data.getOnOne());
                autoAttendant.setOnOneDesc(data.getOnOneDesc());
                autoAttendant.setOnOneNight(data.getOnOneNight());
                autoAttendant.setOnSeven(data.getOnSeven());
                autoAttendant.setOnSevenDesc(data.getOnSevenDesc());
                autoAttendant.setOnSevenNight(data.getOnSevenNight());
                autoAttendant.setOnSix(data.getOnSix());
                autoAttendant.setOnSixDesc(data.getOnSixDesc());
                autoAttendant.setOnSixNight(data.getOnSixNight());
                autoAttendant.setOnThree(data.getOnThree());
                autoAttendant.setOnThreeDesc(data.getOnThreeDesc());
                autoAttendant.setOnThreeNight(data.getOnThreeNight());
                autoAttendant.setOnTwo(data.getOnTwo());
                autoAttendant.setOnTwoDesc(data.getOnTwoDesc());
                autoAttendant.setOnTwoNight(data.getOnTwoNight());
                autoAttendant.setOnZero(data.getOnZero());
                autoAttendant.setOnZero(data.getOnZero());
                autoAttendant.setOnZeroDesc(data.getOnZeroDesc());
                autoAttendant.setOnZeroNight(data.getOnZeroNight());
                autoAttendant.setOperator(data.getOperator());
                autoAttendant.setWaitTime(data.getWaitTime());
                autoAttendant.setWelcomeFile(data.getWelcomeFile());
                autoAttendant.setIsParent(data.getIsParent());
                addValue.add(autoAttendant);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("List Of AutoAttendant");
            returnValue.setData(addValue);
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to find autoAttendant");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getFileList() {
        String fullPath = null;
        RequestResponse returnValue = new RequestResponse();
        try {
            List isPrimaryTrue = this.ivrLanguageService.getByIsPrimaryTrue();
            fullPath = isPrimaryTrue.isEmpty() ? "/usr/local/freeswitch/sounds/en/us/callie/ivr" : "/usr/local/freeswitch/sounds/" + ((IVRLanguage)isPrimaryTrue.get(0)).getLanguageName();
            List data = this.iVRUtility.getFileList(fullPath);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Success");
            returnValue.setMessageDetail("List Of Files");
            returnValue.setData((Object)data);
            logger.info("File Has been Fetched From =>> " + fullPath);
            logger.info(returnValue.getMessage());
        }
        catch (NullPointerException n) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Path Does Not Exist");
            returnValue.setMessageDetail("First Create The Path");
            logger.error(returnValue.getMessageDetail(), (Throwable)n);
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable To Find Files");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse fileUpload(MultipartFile file, String folderName) {
        logger.debug("upload file : {}", (Object)file);
        RequestResponse returnValue = new RequestResponse();
        boolean flag = false;
        try {
            if ((file.getContentType().equals("audio/mpeg") || file.getContentType().equals("audio/wave")) && returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                if (flag) {
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage(" uploaded ");
                    returnValue.setMessageDetail("file has been uploaded successfully");
                    logger.info(returnValue.getMessage());
                } else {
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage(" file not uploaded ");
                    returnValue.setMessageDetail("contact with administrator");
                    logger.error(returnValue.getMessageDetail());
                }
            } else {
                returnValue.setStatus(Constants.Error.BAD_INPUT_DATA);
                returnValue.setMessage("Can't Upload The File");
                returnValue.setMessageDetail(" File Must Be Either wav or mp3 ");
                logger.error(returnValue.getMessageDetail());
            }
        }
        catch (NullPointerException e) {
            returnValue.setStatus(Constants.Error.BAD_INPUT_DATA);
            returnValue.setMessage("file can't be empty");
            returnValue.setMessageDetail("kindly upload the file");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to upload file");
            returnValue.setMessageDetail("Please Contact administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public LTSModel getLevelId(String ltsReferenceCode, IVRNode[] data) {
        for (IVRNode row : data) {
            if (!ltsReferenceCode.equals(row.getProperties().getCode())) continue;
            String levelId = row.getLevelId();
            String name = row.getName();
            return new LTSModel(levelId, name);
        }
        return null;
    }

    public void generateSoapXML(String fileName, String data) {
        try {
            String filePath = Constants.API_TEMPLATE_PATH + fileName + ".xml";
            if (data != null) {
                FileWriter fileWriter = new FileWriter(filePath);
                fileWriter.write(data);
                fileWriter.close();
                logger.info("XML file generated at: " + filePath);
            } else {
                logger.error("XML Content is blank, that's why unable to generate file. ");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Failed to generate the XML file.");
        }
    }

    public void generateJsonFile(String fileName, String data) {
        try {
            String filePath = Constants.API_TEMPLATE_PATH + fileName + ".json";
            if (data != null) {
                FileWriter fileWriter = new FileWriter(filePath);
                fileWriter.write(data);
                fileWriter.close();
                logger.info("JSON file generated at: " + filePath);
            } else {
                logger.error("JSON Content is blank, that's why unable to generate file.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Failed to generate the JSON file.");
        }
    }

    public String returnMilliseconds(Integer time) {
        String result = "";
        if (time != null) {
            result = String.valueOf(time * 1000);
        }
        return result;
    }

    private IVRManager apiIVR(String step, IVRNode nodeConfiguration, AutoAttendant aaStep) {
        IVRManager returnValue = new IVRManager();
        String apiMethod = nodeConfiguration.getProperties().getApiMethod();
        String apiType = nodeConfiguration.getProperties().getApiType();
        returnValue.setIvrGroup(aaStep.getIvrGroup());
        returnValue.setNumber(aaStep.getExtension());
        returnValue.setStep(step);
        returnValue.setDescription(nodeConfiguration.getProperties().getDescription());
        returnValue.setOnsuccess("step-success");
        returnValue.setOnFail("step-fail");
        returnValue.setUrl(nodeConfiguration.getProperties().getApiURL());
        returnValue.setSoapMethod(apiMethod);
        if (apiMethod != null && !apiMethod.isEmpty()) {
            if (apiType.equals("SOAP")) {
                this.generateSoapXML(apiMethod, nodeConfiguration.getProperties().getSoapContent());
            } else if (apiType.equals("REST")) {
                this.generateJsonFile(apiMethod, nodeConfiguration.getProperties().getSoapContent());
            }
        }
        returnValue.setCompType(nodeConfiguration.getProperties().getApiComparisonType());
        returnValue.setCompValue(nodeConfiguration.getProperties().getApiComparisonValue());
        returnValue.setReqCustomParam(nodeConfiguration.getProperties().getReqCustomParam());
        returnValue.setVarNames(nodeConfiguration.getProperties().getReqVariableName());
        returnValue.setSoapReturn(nodeConfiguration.getProperties().getApiReturnVariable());
        returnValue.setNoInputFile(nodeConfiguration.getProperties().getNoInputFileName());
        returnValue.setInvalidInputFile(nodeConfiguration.getProperties().getInvalidFileName());
        returnValue.setMaxRetryFile(nodeConfiguration.getProperties().getMaxRetryFileName());
        returnValue.setInputTerminator(nodeConfiguration.getProperties().getInputTerminator());
        returnValue.setValidation(nodeConfiguration.getProperties().getValidation());
        returnValue.setInputBreak(nodeConfiguration.getProperties().getInputBreak());
        if (nodeConfiguration.getProperties().getMaxRetry() != null) {
            returnValue.setMaxRetry(nodeConfiguration.getProperties().getMaxRetry().toString());
        }
        returnValue.setVariableName(nodeConfiguration.getProperties().getApiResponseVariable());
        if (nodeConfiguration.getProperties().getMaxInput() != null) {
            returnValue.setInputMax(nodeConfiguration.getProperties().getMaxInput().toString());
        }
        returnValue.setInputMin(nodeConfiguration.getProperties().getInputMin());
        returnValue.setInvalidInputSeq(nodeConfiguration.getProperties().getInvalidInputSeq());
        returnValue.setInputWaitTime(this.returnMilliseconds(nodeConfiguration.getProperties().getWaitTime()));
        if (step.equals("start")) {
            returnValue.setType("");
            returnValue.setDescription("entry point");
            returnValue.setOnsuccess("main");
            returnValue.setOnFail("");
        } else if (step.equals("main1")) {
            if (nodeConfiguration.getProperties().getApiResponseVariable() != null && !nodeConfiguration.getProperties().getApiResponseVariable().isEmpty()) {
                returnValue.setType("ad");
                returnValue.setStep("main");
                returnValue.setFilename(nodeConfiguration.getProperties().getApiResponseFile());
                returnValue.setVariableName(nodeConfiguration.getProperties().getApiResponseVariable());
            } else {
                returnValue.setType("pl");
                returnValue.setStep("main");
                returnValue.setVariableName(nodeConfiguration.getProperties().getApiResponseVariable());
                returnValue.setFilename(nodeConfiguration.getProperties().getApiResponseFile());
            }
        } else if (step.equals("pa")) {
            returnValue.setType("pa");
            returnValue.setStep("main");
            returnValue.setVariableName(nodeConfiguration.getProperties().getApiResponseVariable());
            returnValue.setFilename(nodeConfiguration.getProperties().getApiResponseFile());
        } else if (step.equals("cpm")) {
            returnValue.setType("cpm");
            returnValue.setStep("main");
            returnValue.setVariableName(nodeConfiguration.getProperties().getApiResponseVariable());
            returnValue.setFilename("");
        } else {
            returnValue.setType("api");
            returnValue.setVariableName(nodeConfiguration.getProperties().getVariableName());
        }
        return returnValue;
    }

    public RequestResponse getDropdownList() {
        List list = this.autoAttendantRepository.findAll();
        ArrayList<AutoAttendantDropDownModel> addValue = new ArrayList<AutoAttendantDropDownModel>();
        RequestResponse returnValue = new RequestResponse();
        for (AutoAttendant autoAttendant : list) {
            AutoAttendantDropDownModel data = new AutoAttendantDropDownModel();
            data.setId(autoAttendant.getId());
            data.setExtension(autoAttendant.getExtension());
            data.setAccessDesc(autoAttendant.getDescription());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

