/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.announcement.service;

import com.coraltele.db.telephony.pbx.entity.Announcement;
import com.coraltele.db.telephony.pbx.repository.AnnouncementRepository;
import com.coraltele.db.telephony.pbx.specification.AnnouncementSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.announcement.model.AnnouncementModel;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class AnnouncementService {
    private static final Logger logger = LogManager.getLogger(AnnouncementService.class);
    private static final String QUEUE_SOUND_DIR = "/home/coralswitch/queuesounds/";
    @Autowired
    AnnouncementRepository announcementRepository;

    public RequestResponse createData(AnnouncementModel data) {
        logger.debug("create new Announcement  : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Announcement announcement = new Announcement();
            announcement.setCode(data.getCode());
            announcement.setDescription(data.getDescription());
            announcement.setWavFile(data.getWavFile());
            this.announcementRepository.save((Object)announcement);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Data Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to Create Data");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse deleteById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional announcement = this.announcementRepository.findById((Object)ids);
            if (announcement.isPresent()) {
                addValue.add(announcement.get());
                this.announcementRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateById(AnnouncementModel data) {
        logger.debug("Update data {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional announcement = this.announcementRepository.findById((Object)data.getId());
        if (!announcement.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("data not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getCode() != null) {
            ((Announcement)announcement.get()).setCode(data.getCode());
        }
        if (data.getDescription() != null) {
            ((Announcement)announcement.get()).setDescription(data.getDescription());
        }
        if (data.getWavFile() != null) {
            ((Announcement)announcement.get()).setWavFile(data.getWavFile());
        }
        this.announcementRepository.save(announcement.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("data Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllData() {
        List list = (List)this.announcementRepository.findAll();
        ArrayList<AnnouncementModel> addValue = new ArrayList<AnnouncementModel>();
        RequestResponse returnValue = new RequestResponse();
        for (Announcement data : list) {
            AnnouncementModel announcementModel = new AnnouncementModel();
            announcementModel.setCode(data.getCode());
            announcementModel.setId(data.getId());
            announcementModel.setDescription(data.getDescription());
            announcementModel.setWavFile(data.getWavFile());
            addValue.add(announcementModel);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse listQueueSoundFiles() {
        File[] files;
        RequestResponse response = new RequestResponse();
        File folder = new File(QUEUE_SOUND_DIR);
        ArrayList fileList = new ArrayList();
        if (folder.exists() && folder.isDirectory() && (files = folder.listFiles()) != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().toLowerCase().endsWith(".wav")) continue;
                HashMap<String, String> fileMap = new HashMap<String, String>();
                fileMap.put("name", file.getName());
                fileList.add(fileMap);
            }
        }
        response.setData(fileList);
        response.setMessage("List of sound files");
        response.setStatus(Constants.Error.OK);
        return response;
    }

    public RequestResponse getAllDataFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = AnnouncementSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.announcementRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.announcementRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<AnnouncementModel> entityToModelConversion(List<Announcement> announcement) {
        ArrayList<AnnouncementModel> addValue = new ArrayList<AnnouncementModel>();
        for (Announcement data : announcement) {
            AnnouncementModel model = new AnnouncementModel();
            model.setId(data.getId());
            model.setCode(data.getCode());
            model.setDescription(data.getDescription());
            model.setWavFile(data.getWavFile());
            addValue.add(model);
        }
        return addValue;
    }
}

