/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.billing.main.epVoicePicker.controller;

import com.coraltele.db.billing.main.entity.view.EpVoicePicker;
import com.coraltele.db.billing.main.repository.EpVoicePickerRepository;
import com.coraltele.db.billing.main.specification.EpVoicePickerSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.billing.main.epVoicePicker.service.EpVoicePickerService;
import com.coraltele.service.billing.main.epVoicePicker.service.VoicePickerPDFGenerator;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/eVoicePicker"})
public class EpVoicePickerController {
    private static final Logger logger = LogManager.getLogger(EpVoicePickerController.class);
    @Autowired
    EpVoicePickerService epVoicePickerService;
    @Autowired
    EpVoicePickerRepository epVoicePickerRepository;
    @Autowired
    VoicePickerPDFGenerator pdfGenerator;
    @Autowired
    DownloadPdfService pdfDownloadService;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadServiceTest;
    @Autowired
    DateFormatUtility dateFormatUtility;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllEpVoicePicker(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.epVoicePickerService.getAllEpVoicePicker(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadServiceTest.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData) {
        try {
            logger.info("CSV file download started for vPicker--");
            Specification filters = EpVoicePickerSpecification.generateFilters((SearchRequest)searchRequestData);
            Sort sort = null;
            if (searchRequestData.getSortDirection().equals("asc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startStamp" : searchRequestData.getSortBy()}).ascending();
            } else if (searchRequestData.getSortDirection().equals("desc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startStamp" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.epVoicePickerRepository.findAll(filters, sort) : this.epVoicePickerRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (EpVoicePicker item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for alertHistory", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading alertHistory CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValue(EpVoicePicker item, String columnName) {
        switch (columnName) {
            case "location": {
                return this.checkNull((Object)item.getLocation());
            }
            case "direction": {
                return this.checkNull((Object)item.getDirection());
            }
            case "coralApp": {
                return this.checkNull((Object)item.getCoralApp());
            }
            case "callerName": {
                return this.checkNull((Object)item.getCallerName());
            }
            case "callerIdNumber": {
                return this.checkNull((Object)item.getCallerIdNumber());
            }
            case "destinationNumber": {
                return this.checkNull((Object)item.getDestinationNumber());
            }
            case "destName": {
                return this.checkNull((Object)item.getDestName());
            }
            case "startStamp": {
                return this.checkNull((Object)DateFormatUtility.dateAndTimeFormatter((LocalDateTime)item.getStartStamp()));
            }
            case "endStamp": {
                return item.getEndStamp() == null || item.getEndStamp().equals("0") ? null : DateFormatUtility.dateAndTimeFormatter((LocalDateTime)item.getEndStamp());
            }
            case "duration": {
                return this.checkNull((Object)item.getDuration());
            }
            case "billSec": {
                return this.checkNull((Object)item.getBillSec());
            }
            case "fileTime": {
                return this.checkNull((Object)DateFormatUtility.dateAndTimeFormatter((LocalDateTime)item.getFileTime()));
            }
        }
        return null;
    }

    private Object checkNull(Object value) {
        return value != null ? value : "";
    }

    static {
        columnMappings.put("location", "Location");
        columnMappings.put("direction", "Direction");
        columnMappings.put("coralApp", "Recording Type");
        columnMappings.put("callerName", "Caller Name");
        columnMappings.put("callerIdNumber", "Caller");
        columnMappings.put("destinationNumber", "Destination Number");
        columnMappings.put("destName", "Destination Name");
        columnMappings.put("answerStamp", "Answer Time");
        columnMappings.put("startStamp", "Start Time");
        columnMappings.put("endStamp", "End Time");
        columnMappings.put("duration", "Duration");
        columnMappings.put("billSec", "Talk Time");
        columnMappings.put("fileTime", "File Time");
    }
}

