/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.helper;

import com.coraltele.helper.EventNotification;
import com.coraltele.helper.EventNotifyModel;
import com.coraltele.helper.HttpUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.simp.SimpMessagingTemplate;

public class Messaging {
    private static final Logger logger = LoggerFactory.getLogger(Messaging.class);
    private static SimpMessagingTemplate simpMessagingTemplate;

    private Messaging() {
    }

    public static SimpMessagingTemplate getMessagingTemplate() {
        return simpMessagingTemplate;
    }

    public static void setMessagingTemplate(SimpMessagingTemplate messagingTemplate) {
        simpMessagingTemplate = messagingTemplate;
    }

    public static boolean sendEvent(EventNotification dataToSend) {
        boolean returnValue = false;
        try {
            String topic = String.format("user-%s", dataToSend.getSubscriber());
            ObjectMapper objectMapper = new ObjectMapper();
            String message = objectMapper.writeValueAsString((Object)dataToSend);
            simpMessagingTemplate.convertAndSend((Object)String.format("/app/v2/messaging/topic/%s", topic), (Object)message);
            returnValue = true;
            HttpUtils.sendNotificationToWebSocket((EventNotification)dataToSend);
        }
        catch (JsonProcessingException e) {
            logger.error("Error in sendEvent() for sending message to {} => {}", new Object[]{dataToSend.getSubscriber(), e.getMessage(), e});
        }
        return returnValue;
    }

    public static boolean sendAlert(EventNotifyModel dataToSend) {
        boolean returnValue = false;
        try {
            String topic = String.format("user-%s", dataToSend.getEventDestination());
            ObjectMapper objectMapper = new ObjectMapper();
            String message = objectMapper.writeValueAsString((Object)dataToSend);
            simpMessagingTemplate.convertAndSend((Object)String.format("/app/v2/messaging/topic/%s", topic), (Object)message);
            returnValue = true;
            HttpUtils.sendAlertToWebSocket((EventNotifyModel)dataToSend);
        }
        catch (JsonProcessingException e) {
            logger.error("Error in sendEvent() for sending message to {} => {}", new Object[]{dataToSend.getEventDestination(), e.getMessage(), e});
        }
        return returnValue;
    }
}

