/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.helper;

import com.coraltele.db.telephony.pbx.entity.ControlRluServer;
import com.coraltele.db.telephony.pbx.entity.NodeConfiguration;
import com.coraltele.db.telephony.pbx.repository.ControlRluServerRepository;
import com.coraltele.db.telephony.pbx.repository.NodeConfigurationRepository;
import com.coraltele.db.users.main.entity.RluLocation;
import com.coraltele.db.users.main.repository.RluLocationRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.CustomCorsFilter;
import com.coraltele.service.user.service.UserService;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CorsConfig {
    private static final Logger logger = LogManager.getLogger(CustomCorsFilter.class);
    @Autowired
    NodeConfigurationRepository nodeConfigurationRepository;
    @Autowired
    ControlRluServerRepository controlRluServerRepository;
    @Autowired
    RluLocationRepository rluLocationRepository;
    @Autowired
    UserService userService;
    private static final String coralFilePath = "/etc/default/coral";
    private List<String> allowedOrigins;

    public List<String> getAllowedOrigins() {
        if (this.allowedOrigins == null) {
            this.allowedOrigins = new ArrayList();
            if (this.getEnableLocalhost().equals("true")) {
                this.allowedOrigins.add("http://localhost:3000");
                this.allowedOrigins.add("http://127.0.0.1:3000");
                this.allowedOrigins.add("http://" + Constants.CLICK_TO_CALL_IP);
                this.allowedOrigins.add("https://" + Constants.CLICK_TO_CALL_IP);
            }
            this.buildAllowedOriginsList();
        }
        logger.info("List of Domains:{}", (Object)this.allowedOrigins);
        return this.allowedOrigins;
    }

    private void buildAllowedOriginsList() {
        String domain = this.getDomain();
        if (StringUtils.hasText((String)domain)) {
            String[] domainParts = domain.split("\\.");
            if (domainParts.length == 3) {
                this.allowedOrigins.add("http://" + domain);
                this.allowedOrigins.add("https://" + domain);
                this.addSubdomainsToAllowedOrigins(domainParts[1] + "." + domainParts[2]);
            } else if (domainParts.length == 2) {
                this.addSubdomainsToAllowedOrigins(domainParts[0] + "." + domainParts[1]);
            }
        }
        this.allowedOrigins.addAll(this.getNodeIP().stream().map(ip -> "http://" + ip).collect(Collectors.toList()));
        this.allowedOrigins.addAll(this.getVirtualIp().stream().map(ip -> "http://" + ip).collect(Collectors.toList()));
    }

    private void addSubdomainsToAllowedOrigins(String baseDomain) {
        this.getNodeName().forEach(nodeName -> {
            this.allowedOrigins.add("http://" + nodeName + "." + baseDomain);
            this.allowedOrigins.add("https://" + nodeName + "." + baseDomain);
        });
        this.getRluCode().forEach(rluCode -> {
            this.allowedOrigins.add("http://" + rluCode + "." + baseDomain);
            this.allowedOrigins.add("https://" + rluCode + "." + baseDomain);
        });
        this.getAdditionalDomain().forEach(rluLocation -> {
            this.allowedOrigins.add("http://" + rluLocation);
            this.allowedOrigins.add("https://" + rluLocation);
        });
    }

    private String getDomain() {
        String domain = "";
        try {
            Ini ini;
            File file = new File(coralFilePath);
            if (file.exists() && (ini = new Ini(file)).containsKey((Object)"CLUSTER")) {
                Profile.Section clusterSection = (Profile.Section)ini.get((Object)"CLUSTER");
                String domainValue = (String)clusterSection.get((Object)"DOMAIN");
                if (StringUtils.hasText((String)domainValue)) {
                    domain = domainValue.trim();
                } else {
                    String wssDomainValue = (String)clusterSection.get((Object)"WSS-DOMAIN");
                    if (StringUtils.hasText((String)wssDomainValue)) {
                        domain = wssDomainValue.trim();
                        logger.info("DOMAIN value is empty or missing. Falling back to WSS-DOMAIN: {}", (Object)domain);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Error reading domain from config file: ", (Throwable)e);
        }
        return domain;
    }

    private String getEnableLocalhost() {
        String enableLocalhost = "false";
        try {
            Profile.Section clusterSection;
            Ini ini;
            File file = new File(coralFilePath);
            if (file.exists() && (ini = new Ini(file)).containsKey((Object)"CLUSTER") && (clusterSection = (Profile.Section)ini.get((Object)"CLUSTER")).containsKey((Object)"ENABLE-LOCALHOST")) {
                enableLocalhost = (String)clusterSection.get((Object)"ENABLE-LOCALHOST");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return enableLocalhost;
    }

    private List<String> getVirtualIp() {
        ArrayList<String> virtualIp = new ArrayList<String>();
        List listVirtualIP = this.controlRluServerRepository.findAll();
        for (ControlRluServer controlRluServer : listVirtualIP) {
            virtualIp.add(controlRluServer.getVirtualIp());
        }
        return virtualIp;
    }

    private List<String> getNodeIP() {
        ArrayList<String> nodeIP = new ArrayList<String>();
        List nodeIPList = this.nodeConfigurationRepository.findAll();
        for (NodeConfiguration nodeConfiguration : nodeIPList) {
            nodeIP.add(nodeConfiguration.getNodeIp());
        }
        return nodeIP;
    }

    private List<String> getRluCode() {
        ArrayList<String> rluCode = new ArrayList<String>();
        List listRluCode = this.controlRluServerRepository.findAll();
        for (ControlRluServer controlRluServer : listRluCode) {
            if (controlRluServer.getRluCode() == null || !StringUtils.hasText((String)controlRluServer.getRluCode())) continue;
            rluCode.add(controlRluServer.getRluCode());
        }
        return rluCode;
    }

    private List<String> getNodeName() {
        ArrayList<String> nodeName = new ArrayList<String>();
        List nodeNameList = this.nodeConfigurationRepository.findAll();
        for (NodeConfiguration nodeConfiguration : nodeNameList) {
            if (nodeConfiguration.getNodeName() == null || !StringUtils.hasText((String)nodeConfiguration.getNodeName())) continue;
            nodeName.add(nodeConfiguration.getNodeName());
        }
        return nodeName;
    }

    private List<String> getAdditionalDomain() {
        ArrayList<String> rluLocationDomain = new ArrayList<String>();
        List list = this.rluLocationRepository.findAll();
        for (RluLocation row : list) {
            if (row.getDomainName() == null || !StringUtils.hasText((String)row.getDomainName())) continue;
            rluLocationDomain.add(row.getDomainName());
        }
        return rluLocationDomain;
    }
}

