/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.db.users.main.repository;

import com.coraltele.db.users.main.entity.User;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface UserRepository
extends CrudRepository<User, Integer> {
    public Optional<User> findById(int var1);

    public Optional<User> findByIpAddress(String var1);

    public Optional<User> findByKeyValue(String var1);

    public Optional<User> findByUsername(String var1);

    public void deleteById(int var1);

    public List<User> findAllByOrderById();

    public Page<User> findAll(Specification var1, Pageable var2);

    public List<User> findByUuidIsNull();

    public Optional<User> findByUsernameAndContactNo(String var1, String var2);

    public List<User> findByContactNoIn(List<String> var1);

    public List<User> findByContactNo(String var1);

    public List<User> findByIdIn(List<Integer> var1);

    public Optional<User> findByDeviceId(String var1);

    public Optional<User> findByUsernameAndOtpCode(String var1, Integer var2);

    public boolean existsByContactNo(String var1);

    @Transactional(transactionManager="usersTransactionManager")
    @Modifying(clearAutomatically=true, flushAutomatically=true)
    @Query(value="UPDATE User u SET u.uuidSecurity = :uuidSecurity WHERE u.username = :username")
    public void updateUuidByUsername(String var1, String var2);
}

