/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.db.users.main.entity;

import com.coraltele.helper.UuidUpdatable;
import com.coraltele.helper.UuidUpdateListener;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import lombok.Generated;

@EntityListeners(value={UuidUpdateListener.class})
@Entity
@Table(name="m_user")
public class User
implements UuidUpdatable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    @Column(name="username", columnDefinition="VARCHAR(255) DEFAULT ''", nullable=true)
    private String username;
    @Column(name="emailid", columnDefinition="VARCHAR(100) DEFAULT ''", nullable=true)
    private String emailId;
    @Column(name="password", columnDefinition="VARCHAR(100) DEFAULT ''", nullable=true)
    private String password;
    @Column(name="description", columnDefinition="VARCHAR(100) DEFAULT ''", nullable=true)
    private String description;
    @Column(name="enabled", columnDefinition="int default 0", nullable=true)
    private Integer enabled;
    @Column(name="failedattempts", columnDefinition="Integer default 0", nullable=true)
    private Integer failedAttempts;
    @Column(name="accountexpired", columnDefinition="boolean default false", nullable=true)
    private Boolean accountExpired;
    @Column(name="accountlocked", columnDefinition="boolean default false", nullable=true)
    private Boolean accountLocked;
    @Column(name="credentialsexpired", columnDefinition="boolean default false", nullable=true)
    private Boolean credentialsExpired;
    @JsonFormat(pattern="yyyy-MM-dd")
    @Column(name="lastlogon")
    private LocalDate lastLogon;
    @Column(name="contactno", columnDefinition="VARCHAR(20) DEFAULT ''", nullable=true)
    private String contactNo;
    @JsonFormat(pattern="yyyy-MM-dd")
    @Column(name="lastpasswordchange")
    private LocalDate lastPasswordChange;
    @Column(name="createdby", columnDefinition="VARCHAR(100) DEFAULT ''", nullable=true)
    private String createdBy;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Column(name="createdon", columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP", nullable=true)
    private LocalDateTime createdOn;
    @Column(name="updatedby", columnDefinition="VARCHAR(100) DEFAULT ''", nullable=true)
    private String updatedBy;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Column(name="updatedon")
    private LocalDateTime updatedOn;
    @Column(name="ipaddress", columnDefinition="VARCHAR(255) DEFAULT ''", nullable=true)
    private String ipAddress;
    @Column(name="key_value", columnDefinition="VARCHAR(255) DEFAULT ''", nullable=true)
    private String keyValue;
    @Column(name="status", columnDefinition="TEXT")
    private String status;
    @Column(name="isondemand", columnDefinition="boolean default false", nullable=true)
    private Boolean isOnDemand;
    @Column(name="autoans", columnDefinition="boolean default false", nullable=true)
    private Boolean autoAnswer;
    @Column(name="do_not_disturb", columnDefinition="boolean default false", nullable=true)
    private Boolean doNotDisturb;
    @Column(name="lastlogonip", columnDefinition="VARCHAR(50) DEFAULT ''", nullable=true)
    private String lastLogOnIP;
    @Column(name="location", columnDefinition="VARCHAR(100) DEFAULT ''", nullable=true)
    private String location;
    @Column(name="authenticatedsession", columnDefinition="TEXT")
    private String authenticatedSession;
    @Column(name="cansendsms", columnDefinition="boolean default true", nullable=true)
    private Boolean canSendSms;
    @Column(name="usergroup", columnDefinition="TEXT")
    private String userGroup;
    @Column(name="jwtauthkey", columnDefinition="TEXT")
    private String jwtAuthKey;
    @Column(name="jwttokengeneratedtime", columnDefinition="int default 0", nullable=true)
    private Integer jwtTokenGeneratedTime;
    @Column(name="jwttokenvalidtill", columnDefinition="int default 0", nullable=true)
    private Integer jwtTokenValidTill;
    @Column(name="outboundgateway", columnDefinition="TEXT")
    private String outBoundGateway;
    @Column(name="role", columnDefinition="TEXT")
    private String role;
    @Column(name="nodeid", columnDefinition="TEXT")
    private String nodeId;
    @Column(name="sippass", columnDefinition="VARCHAR(20) DEFAULT ''", nullable=true)
    private String sipPassword;
    @Column(name="maxnoanswer", columnDefinition="int default 0", nullable=true)
    private Integer maxNoAnswer;
    @Column(name="wrapuptime", columnDefinition="int default 0", nullable=true)
    private Integer wrapUpTime;
    @Column(name="rejectdelaytime", columnDefinition="int default 0", nullable=true)
    private Integer rejectDelayTime;
    @Column(name="busydelaytime", columnDefinition="int default 0", nullable=true)
    private Integer busyDelayTime;
    @Column(name="noanswerdelaytime", columnDefinition="int default 0", nullable=true)
    private Integer noAnswerDelayTime;
    @Column(name="calltimeout", columnDefinition="int default 0", nullable=true)
    private Integer callTimeout;
    @Column(name="agentshiftid", columnDefinition="int default 0", nullable=true)
    private Integer agentShiftId;
    private String uuid;
    @Column(name="vip_user", columnDefinition="boolean default false", nullable=true)
    private Boolean vipUser;
    @Column(name="reporting_head", columnDefinition="VARCHAR(255) DEFAULT ''", nullable=true)
    private String reportingHead;
    @Column(name="dispatcher_autoanswer", columnDefinition="boolean default false", nullable=true)
    private Boolean dispatcherAutoAnswer;
    @Column(name="ring_answer", columnDefinition="int default 0", nullable=true)
    private Integer ringAnswerCount;
    @Column(name="public_emergency_number", columnDefinition="VARCHAR(255) DEFAULT ''", nullable=true)
    private String publicEmergencyNumber;
    @Column(name="broadcast_number", columnDefinition="VARCHAR(255) DEFAULT ''", nullable=true)
    private String broadcastNumber;
    @Column(name="area_id", nullable=true)
    private Integer areaId;
    @Column(name="assigned_zone", columnDefinition="TEXT")
    private String zoneId;
    @Column(name="mobilenumber")
    private String mobileNumber;
    @Column(name="otp_code")
    private Integer otpCode;
    @Column(name="otp_genertedon")
    private String otpGeneratedOn;
    @Column(name="allow_otp")
    private String allowOtp;
    @Column(name="token_uuid")
    private String tokenUuid;
    @Column(name="loggedin", columnDefinition="boolean default false")
    private Boolean loggedIn;
    @Column(name="device_id")
    private String deviceId;
    @Column(name="department")
    private String department;
    @Column(name="usertype")
    private String userType;
    @Column(name="refid")
    private String refId;
    @Column(name="uuid_security")
    private String uuidSecurity;

    @PrePersist
    public void generateUniqueId() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID().toString();
        }
        if (this.enabled == null) {
            this.enabled = 0;
        }
        if (this.failedAttempts == null) {
            this.failedAttempts = 0;
        }
        if (this.accountExpired == null) {
            this.accountExpired = false;
        }
        if (this.accountLocked == null) {
            this.accountLocked = false;
        }
        if (this.credentialsExpired == null) {
            this.credentialsExpired = false;
        }
        if (this.jwtTokenGeneratedTime == null) {
            this.jwtTokenGeneratedTime = 0;
        }
        if (this.jwtTokenValidTill == null) {
            this.jwtTokenValidTill = 0;
        }
        if (this.maxNoAnswer == null) {
            this.maxNoAnswer = 0;
        }
        if (this.wrapUpTime == null) {
            this.wrapUpTime = 0;
        }
        if (this.rejectDelayTime == null) {
            this.rejectDelayTime = 0;
        }
        if (this.busyDelayTime == null) {
            this.busyDelayTime = 0;
        }
        if (this.noAnswerDelayTime == null) {
            this.noAnswerDelayTime = 0;
        }
        if (this.callTimeout == null) {
            this.callTimeout = 0;
        }
        if (this.agentShiftId == null) {
            this.agentShiftId = 0;
        }
        if (this.createdOn == null) {
            this.createdOn = LocalDateTime.now();
        }
        if (this.lastLogOnIP == null) {
            this.lastLogOnIP = "";
        }
        if (this.canSendSms == null) {
            this.canSendSms = true;
        }
        if (this.isOnDemand == null) {
            this.isOnDemand = false;
        }
        if (this.autoAnswer == null) {
            this.autoAnswer = false;
        }
        if (this.doNotDisturb == null) {
            this.doNotDisturb = false;
        }
        if (this.vipUser == null) {
            this.vipUser = false;
        }
        if (this.dispatcherAutoAnswer == null) {
            this.dispatcherAutoAnswer = false;
        }
        if (this.ringAnswerCount == null) {
            this.ringAnswerCount = 0;
        }
        if (this.publicEmergencyNumber == null) {
            this.publicEmergencyNumber = "";
        }
        if (this.loggedIn == null) {
            this.loggedIn = false;
        }
    }

    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getEmailId() {
        return this.emailId;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Integer getEnabled() {
        return this.enabled;
    }

    @Generated
    public Integer getFailedAttempts() {
        return this.failedAttempts;
    }

    @Generated
    public Boolean getAccountExpired() {
        return this.accountExpired;
    }

    @Generated
    public Boolean getAccountLocked() {
        return this.accountLocked;
    }

    @Generated
    public Boolean getCredentialsExpired() {
        return this.credentialsExpired;
    }

    @Generated
    public LocalDate getLastLogon() {
        return this.lastLogon;
    }

    @Generated
    public String getContactNo() {
        return this.contactNo;
    }

    @Generated
    public LocalDate getLastPasswordChange() {
        return this.lastPasswordChange;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public LocalDateTime getCreatedOn() {
        return this.createdOn;
    }

    @Generated
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @Generated
    public LocalDateTime getUpdatedOn() {
        return this.updatedOn;
    }

    @Generated
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Generated
    public String getKeyValue() {
        return this.keyValue;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public Boolean getIsOnDemand() {
        return this.isOnDemand;
    }

    @Generated
    public Boolean getAutoAnswer() {
        return this.autoAnswer;
    }

    @Generated
    public Boolean getDoNotDisturb() {
        return this.doNotDisturb;
    }

    @Generated
    public String getLastLogOnIP() {
        return this.lastLogOnIP;
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Generated
    public String getAuthenticatedSession() {
        return this.authenticatedSession;
    }

    @Generated
    public Boolean getCanSendSms() {
        return this.canSendSms;
    }

    @Generated
    public String getUserGroup() {
        return this.userGroup;
    }

    @Generated
    public String getJwtAuthKey() {
        return this.jwtAuthKey;
    }

    @Generated
    public Integer getJwtTokenGeneratedTime() {
        return this.jwtTokenGeneratedTime;
    }

    @Generated
    public Integer getJwtTokenValidTill() {
        return this.jwtTokenValidTill;
    }

    @Generated
    public String getOutBoundGateway() {
        return this.outBoundGateway;
    }

    @Generated
    public String getRole() {
        return this.role;
    }

    @Generated
    public String getNodeId() {
        return this.nodeId;
    }

    @Generated
    public String getSipPassword() {
        return this.sipPassword;
    }

    @Generated
    public Integer getMaxNoAnswer() {
        return this.maxNoAnswer;
    }

    @Generated
    public Integer getWrapUpTime() {
        return this.wrapUpTime;
    }

    @Generated
    public Integer getRejectDelayTime() {
        return this.rejectDelayTime;
    }

    @Generated
    public Integer getBusyDelayTime() {
        return this.busyDelayTime;
    }

    @Generated
    public Integer getNoAnswerDelayTime() {
        return this.noAnswerDelayTime;
    }

    @Generated
    public Integer getCallTimeout() {
        return this.callTimeout;
    }

    @Generated
    public Integer getAgentShiftId() {
        return this.agentShiftId;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public Boolean getVipUser() {
        return this.vipUser;
    }

    @Generated
    public String getReportingHead() {
        return this.reportingHead;
    }

    @Generated
    public Boolean getDispatcherAutoAnswer() {
        return this.dispatcherAutoAnswer;
    }

    @Generated
    public Integer getRingAnswerCount() {
        return this.ringAnswerCount;
    }

    @Generated
    public String getPublicEmergencyNumber() {
        return this.publicEmergencyNumber;
    }

    @Generated
    public String getBroadcastNumber() {
        return this.broadcastNumber;
    }

    @Generated
    public Integer getAreaId() {
        return this.areaId;
    }

    @Generated
    public String getZoneId() {
        return this.zoneId;
    }

    @Generated
    public String getMobileNumber() {
        return this.mobileNumber;
    }

    @Generated
    public Integer getOtpCode() {
        return this.otpCode;
    }

    @Generated
    public String getOtpGeneratedOn() {
        return this.otpGeneratedOn;
    }

    @Generated
    public String getAllowOtp() {
        return this.allowOtp;
    }

    @Generated
    public String getTokenUuid() {
        return this.tokenUuid;
    }

    @Generated
    public Boolean getLoggedIn() {
        return this.loggedIn;
    }

    @Generated
    public String getDeviceId() {
        return this.deviceId;
    }

    @Generated
    public String getDepartment() {
        return this.department;
    }

    @Generated
    public String getUserType() {
        return this.userType;
    }

    @Generated
    public String getRefId() {
        return this.refId;
    }

    @Generated
    public String getUuidSecurity() {
        return this.uuidSecurity;
    }

    @Generated
    public void setId(Integer id) {
        this.id = id;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setEmailId(String emailId) {
        this.emailId = emailId;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setFailedAttempts(Integer failedAttempts) {
        this.failedAttempts = failedAttempts;
    }

    @Generated
    public void setAccountExpired(Boolean accountExpired) {
        this.accountExpired = accountExpired;
    }

    @Generated
    public void setAccountLocked(Boolean accountLocked) {
        this.accountLocked = accountLocked;
    }

    @Generated
    public void setCredentialsExpired(Boolean credentialsExpired) {
        this.credentialsExpired = credentialsExpired;
    }

    @JsonFormat(pattern="yyyy-MM-dd")
    @Generated
    public void setLastLogon(LocalDate lastLogon) {
        this.lastLogon = lastLogon;
    }

    @Generated
    public void setContactNo(String contactNo) {
        this.contactNo = contactNo;
    }

    @JsonFormat(pattern="yyyy-MM-dd")
    @Generated
    public void setLastPasswordChange(LocalDate lastPasswordChange) {
        this.lastPasswordChange = lastPasswordChange;
    }

    @Generated
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Generated
    public void setCreatedOn(LocalDateTime createdOn) {
        this.createdOn = createdOn;
    }

    @Generated
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Generated
    public void setUpdatedOn(LocalDateTime updatedOn) {
        this.updatedOn = updatedOn;
    }

    @Generated
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Generated
    public void setKeyValue(String keyValue) {
        this.keyValue = keyValue;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setIsOnDemand(Boolean isOnDemand) {
        this.isOnDemand = isOnDemand;
    }

    @Generated
    public void setAutoAnswer(Boolean autoAnswer) {
        this.autoAnswer = autoAnswer;
    }

    @Generated
    public void setDoNotDisturb(Boolean doNotDisturb) {
        this.doNotDisturb = doNotDisturb;
    }

    @Generated
    public void setLastLogOnIP(String lastLogOnIP) {
        this.lastLogOnIP = lastLogOnIP;
    }

    @Generated
    public void setLocation(String location) {
        this.location = location;
    }

    @Generated
    public void setAuthenticatedSession(String authenticatedSession) {
        this.authenticatedSession = authenticatedSession;
    }

    @Generated
    public void setCanSendSms(Boolean canSendSms) {
        this.canSendSms = canSendSms;
    }

    @Generated
    public void setUserGroup(String userGroup) {
        this.userGroup = userGroup;
    }

    @Generated
    public void setJwtAuthKey(String jwtAuthKey) {
        this.jwtAuthKey = jwtAuthKey;
    }

    @Generated
    public void setJwtTokenGeneratedTime(Integer jwtTokenGeneratedTime) {
        this.jwtTokenGeneratedTime = jwtTokenGeneratedTime;
    }

    @Generated
    public void setJwtTokenValidTill(Integer jwtTokenValidTill) {
        this.jwtTokenValidTill = jwtTokenValidTill;
    }

    @Generated
    public void setOutBoundGateway(String outBoundGateway) {
        this.outBoundGateway = outBoundGateway;
    }

    @Generated
    public void setRole(String role) {
        this.role = role;
    }

    @Generated
    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    @Generated
    public void setSipPassword(String sipPassword) {
        this.sipPassword = sipPassword;
    }

    @Generated
    public void setMaxNoAnswer(Integer maxNoAnswer) {
        this.maxNoAnswer = maxNoAnswer;
    }

    @Generated
    public void setWrapUpTime(Integer wrapUpTime) {
        this.wrapUpTime = wrapUpTime;
    }

    @Generated
    public void setRejectDelayTime(Integer rejectDelayTime) {
        this.rejectDelayTime = rejectDelayTime;
    }

    @Generated
    public void setBusyDelayTime(Integer busyDelayTime) {
        this.busyDelayTime = busyDelayTime;
    }

    @Generated
    public void setNoAnswerDelayTime(Integer noAnswerDelayTime) {
        this.noAnswerDelayTime = noAnswerDelayTime;
    }

    @Generated
    public void setCallTimeout(Integer callTimeout) {
        this.callTimeout = callTimeout;
    }

    @Generated
    public void setAgentShiftId(Integer agentShiftId) {
        this.agentShiftId = agentShiftId;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setVipUser(Boolean vipUser) {
        this.vipUser = vipUser;
    }

    @Generated
    public void setReportingHead(String reportingHead) {
        this.reportingHead = reportingHead;
    }

    @Generated
    public void setDispatcherAutoAnswer(Boolean dispatcherAutoAnswer) {
        this.dispatcherAutoAnswer = dispatcherAutoAnswer;
    }

    @Generated
    public void setRingAnswerCount(Integer ringAnswerCount) {
        this.ringAnswerCount = ringAnswerCount;
    }

    @Generated
    public void setPublicEmergencyNumber(String publicEmergencyNumber) {
        this.publicEmergencyNumber = publicEmergencyNumber;
    }

    @Generated
    public void setBroadcastNumber(String broadcastNumber) {
        this.broadcastNumber = broadcastNumber;
    }

    @Generated
    public void setAreaId(Integer areaId) {
        this.areaId = areaId;
    }

    @Generated
    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    @Generated
    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    @Generated
    public void setOtpCode(Integer otpCode) {
        this.otpCode = otpCode;
    }

    @Generated
    public void setOtpGeneratedOn(String otpGeneratedOn) {
        this.otpGeneratedOn = otpGeneratedOn;
    }

    @Generated
    public void setAllowOtp(String allowOtp) {
        this.allowOtp = allowOtp;
    }

    @Generated
    public void setTokenUuid(String tokenUuid) {
        this.tokenUuid = tokenUuid;
    }

    @Generated
    public void setLoggedIn(Boolean loggedIn) {
        this.loggedIn = loggedIn;
    }

    @Generated
    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    @Generated
    public void setDepartment(String department) {
        this.department = department;
    }

    @Generated
    public void setUserType(String userType) {
        this.userType = userType;
    }

    @Generated
    public void setRefId(String refId) {
        this.refId = refId;
    }

    @Generated
    public void setUuidSecurity(String uuidSecurity) {
        this.uuidSecurity = uuidSecurity;
    }

    @Generated
    public User() {
    }

    @Generated
    public User(Integer id, String username, String emailId, String password, String description, Integer enabled, Integer failedAttempts, Boolean accountExpired, Boolean accountLocked, Boolean credentialsExpired, LocalDate lastLogon, String contactNo, LocalDate lastPasswordChange, String createdBy, LocalDateTime createdOn, String updatedBy, LocalDateTime updatedOn, String ipAddress, String keyValue, String status, Boolean isOnDemand, Boolean autoAnswer, Boolean doNotDisturb, String lastLogOnIP, String location, String authenticatedSession, Boolean canSendSms, String userGroup, String jwtAuthKey, Integer jwtTokenGeneratedTime, Integer jwtTokenValidTill, String outBoundGateway, String role, String nodeId, String sipPassword, Integer maxNoAnswer, Integer wrapUpTime, Integer rejectDelayTime, Integer busyDelayTime, Integer noAnswerDelayTime, Integer callTimeout, Integer agentShiftId, String uuid, Boolean vipUser, String reportingHead, Boolean dispatcherAutoAnswer, Integer ringAnswerCount, String publicEmergencyNumber, String broadcastNumber, Integer areaId, String zoneId, String mobileNumber, Integer otpCode, String otpGeneratedOn, String allowOtp, String tokenUuid, Boolean loggedIn, String deviceId, String department, String userType, String refId, String uuidSecurity) {
        this.id = id;
        this.username = username;
        this.emailId = emailId;
        this.password = password;
        this.description = description;
        this.enabled = enabled;
        this.failedAttempts = failedAttempts;
        this.accountExpired = accountExpired;
        this.accountLocked = accountLocked;
        this.credentialsExpired = credentialsExpired;
        this.lastLogon = lastLogon;
        this.contactNo = contactNo;
        this.lastPasswordChange = lastPasswordChange;
        this.createdBy = createdBy;
        this.createdOn = createdOn;
        this.updatedBy = updatedBy;
        this.updatedOn = updatedOn;
        this.ipAddress = ipAddress;
        this.keyValue = keyValue;
        this.status = status;
        this.isOnDemand = isOnDemand;
        this.autoAnswer = autoAnswer;
        this.doNotDisturb = doNotDisturb;
        this.lastLogOnIP = lastLogOnIP;
        this.location = location;
        this.authenticatedSession = authenticatedSession;
        this.canSendSms = canSendSms;
        this.userGroup = userGroup;
        this.jwtAuthKey = jwtAuthKey;
        this.jwtTokenGeneratedTime = jwtTokenGeneratedTime;
        this.jwtTokenValidTill = jwtTokenValidTill;
        this.outBoundGateway = outBoundGateway;
        this.role = role;
        this.nodeId = nodeId;
        this.sipPassword = sipPassword;
        this.maxNoAnswer = maxNoAnswer;
        this.wrapUpTime = wrapUpTime;
        this.rejectDelayTime = rejectDelayTime;
        this.busyDelayTime = busyDelayTime;
        this.noAnswerDelayTime = noAnswerDelayTime;
        this.callTimeout = callTimeout;
        this.agentShiftId = agentShiftId;
        this.uuid = uuid;
        this.vipUser = vipUser;
        this.reportingHead = reportingHead;
        this.dispatcherAutoAnswer = dispatcherAutoAnswer;
        this.ringAnswerCount = ringAnswerCount;
        this.publicEmergencyNumber = publicEmergencyNumber;
        this.broadcastNumber = broadcastNumber;
        this.areaId = areaId;
        this.zoneId = zoneId;
        this.mobileNumber = mobileNumber;
        this.otpCode = otpCode;
        this.otpGeneratedOn = otpGeneratedOn;
        this.allowOtp = allowOtp;
        this.tokenUuid = tokenUuid;
        this.loggedIn = loggedIn;
        this.deviceId = deviceId;
        this.department = department;
        this.userType = userType;
        this.refId = refId;
        this.uuidSecurity = uuidSecurity;
    }
}

