/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.app;

import com.coraltele.helper.HttpUtils;
import com.coraltele.helper.RequestResponse;
import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/app/v2/status"})
@RestController
public class StatusController {
    @Value(value="${application.name}")
    private String applicationName;
    @Value(value="${build.version}")
    private String buildVersion;

    @GetMapping(value={"/live"})
    public ResponseEntity<RequestResponse> currentStatus(HttpServletRequest request) {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setMessage(MessageFormat.format("Application : {0}, Version {1}, Client IP {2}", this.applicationName, this.buildVersion, HttpUtils.getRequestIp((HttpServletRequest)request)));
        return ResponseEntity.ok((Object)returnValue);
    }

    public String getIp(HttpServletRequest request) {
        String xForwardedFor = request.getHeader("X-Forwarded-For");
        if (xForwardedFor != null) {
            return xForwardedFor.split(",")[0];
        }
        return request.getRemoteAddr();
    }
}

