/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.user.model.RoleModel;
import com.coraltele.service.user.service.RoleService;
import java.security.Principal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/role"})
@RestController
public class RoleController {
    @Autowired
    private RoleService roleService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> addRole(@RequestBody RoleModel data, Principal principal) {
        RequestResponse returnValue = this.roleService.createRole(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/{id}"})
    public ResponseEntity<RequestResponse> getRoleById(@PathVariable(value="id") int id) {
        RequestResponse returnValue = this.roleService.getById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateRole(@RequestBody RoleModel data, Principal principal) {
        RequestResponse returnValue = this.roleService.updateRole(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteRole(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.roleService.deleteRole(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/dropdownList"})
    public ResponseEntity<RequestResponse> getAll() {
        RequestResponse returnValue = this.roleService.getAll();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getUserByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.roleService.getRoleByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

