/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.trainAlert.controller;

import com.coraltele.db.telemetry.main.entity.TrainAlert;
import com.coraltele.db.telemetry.main.repository.TainAlertRepository;
import com.coraltele.db.telemetry.main.specification.TrainAlertSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.telemetry.main.activityLogs.controller.ActivityLogController;
import com.coraltele.service.telemetry.main.trainAlert.service.TrainAlertService;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/trainAlert"})
@RestController
public class TrainAlertController {
    private static final Logger logger = LogManager.getLogger(ActivityLogController.class);
    @Autowired
    TrainAlertService trainAlertService;
    @Autowired
    TainAlertRepository trainAlertRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllAlertHistory(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.trainAlertService.getAll(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for alertHistory--");
            Specification filters = TrainAlertSpecification.generateFilters((SearchRequest)searchRequestData);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "alertGeneratedOn" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "alertGeneratedOn" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.trainAlertRepository.findAll(filters, sort) : this.trainAlertRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (TrainAlert item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for alertHistory", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading alertHistory CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValue(TrainAlert item, String columnName) {
        switch (columnName) {
            case "eventType": {
                return this.checkNull((Object)item.getEventType());
            }
            case "eventSeverity": {
                return this.checkNull((Object)item.getEventSeverity());
            }
            case "createdOn": {
                return this.checkNull((Object)this.formatNullableDate(item.getCreatedOn()));
            }
            case "type": {
                return this.checkNull((Object)item.getType());
            }
            case "createdBy": {
                return this.checkNull((Object)item.getCreatedBy());
            }
            case "zone": {
                return this.checkNull((Object)item.getZone());
            }
            case "description": {
                return this.checkNull((Object)item.getDescription());
            }
            case "didMapping": {
                return this.checkNull((Object)item.getDidMapping());
            }
            case "accessCode": {
                return this.checkNull((Object)item.getAccessCode());
            }
            case "roomName": {
                return this.checkNull((Object)item.getRoomName());
            }
        }
        return null;
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }

    private String formatNullableDate(Long epochMillis) {
        return epochMillis != null ? DateFormatUtility.dateAndTimeFormatter((LocalDateTime)DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)epochMillis)) : "";
    }

    static {
        columnMappings.put("eventType", "Call Status");
        columnMappings.put("eventSeverity", "Type Of Call");
        columnMappings.put("createdOn", "Caller Number");
        columnMappings.put("type", "Calling Group");
        columnMappings.put("createdBy", "Created By");
        columnMappings.put("zone", "Created On");
        columnMappings.put("description", "Destination Number");
        columnMappings.put("roomName", "Meeting Room");
        columnMappings.put("didMapping", "DidMapping");
        columnMappings.put("accessCode", "Access Code");
    }
}

