/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.extensionDetailIn.controller;

import com.coraltele.db.telemetry.main.entity.view.BillingCdrOutgoingView;
import com.coraltele.db.telemetry.main.repository.BillingCDRRepository;
import com.coraltele.db.telemetry.main.repository.BillingCdrIncomingSummaryViewRepository;
import com.coraltele.db.telemetry.main.repository.BillingCdrIncomingViewRepository;
import com.coraltele.db.telemetry.main.repository.BillingCdrOutgoingViewRepository;
import com.coraltele.db.telemetry.main.specification.BillingCdrIncomingSpecification;
import com.coraltele.db.telemetry.main.specification.BillingCdrIncomingSummarySpecification;
import com.coraltele.db.telemetry.main.specification.BillingCdrOutgoingViewSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.AdvanceFilter;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.telemetry.main.extensionDetailIn.model.ExtensionSummaryModel;
import com.coraltele.service.telemetry.main.extensionDetailIn.service.ExtensionDetailInService;
import java.io.File;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/extensionSummaryCDR"})
@RestController
public class ExtensionDetailInController {
    @Autowired
    ExtensionDetailInService extensionCDRService;
    @Autowired
    BillingCdrIncomingViewRepository billingCdrIncomingViewRepository;
    @Autowired
    BillingCdrIncomingSpecification billingCdrIncomingSpecification;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadService;
    @Autowired
    DownloadPdfService pdfDownloadService;
    @Autowired
    BillingCdrIncomingSummaryViewRepository billingCdrIncomingSummaryViewRepository;
    @Autowired
    BillingCdrIncomingSummarySpecification billingCdrIncomingSummarySpecification;
    @Autowired
    BillingCDRRepository billingCDRRepository;
    @Autowired
    BillingCdrOutgoingViewRepository viewRpository;
    @Autowired
    BillingCdrOutgoingViewSpecification BillingCdrSpecification;
    private static final Logger logger = LogManager.getLogger(ExtensionDetailInController.class);
    private static final ConcurrentHashMap<String, String> COLUMN_MAPPINGS = new ConcurrentHashMap();
    private static final Map<String, Integer> EXTENSION_SUMMARY_MAP;
    private static final NumberFormat INR_FORMAT;
    private static final LinkedHashMap<String, String> EXTENSION_HEADER_MAP;

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.extensionCDRService.getAllByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData) {
        try {
            logger.info("CSV download started...");
            Specification filters = BillingCdrOutgoingViewSpecification.generateFilters((SearchRequest)searchRequestData);
            Sort sort = null;
            if (searchRequestData.getSortDirection().equals("asc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).ascending();
            } else if (searchRequestData.getSortDirection().equals("desc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.viewRpository.findAll(filters, sort) : this.viewRpository.findAll(filters);
            StringWriter writer = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)writer, CSVFormat.DEFAULT);){
                List selectedColumns = searchRequestData.getColumnNames() == null || searchRequestData.getColumnNames().isEmpty() ? new ArrayList(COLUMN_MAPPINGS.keySet()) : searchRequestData.getColumnNames();
                csvPrinter.printRecord((Iterable)selectedColumns.stream().map(col -> COLUMN_MAPPINGS.getOrDefault(col, col)).collect(Collectors.toList()));
                for (BillingCdrOutgoingView item : filteredData) {
                    ArrayList<Object> row = new ArrayList<Object>();
                    for (String column : selectedColumns) {
                        row.add(this.getColumnValue(item, column));
                    }
                    csvPrinter.printRecord(row);
                }
            }
            byte[] csvBytes = writer.toString().getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "extension_detail_report.csv");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            logger.error("CSV export failed", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValue(BillingCdrOutgoingView item, String columnName) {
        switch (columnName) {
            case "callerIdNumber": {
                return this.checkNull((Object)this.safe((Object)item.getCallerIdNumber()));
            }
            case "datetimeIst": {
                return this.checkNull((Object)this.safe((Object)item.getDatetimeIst()));
            }
            case "destinationNumber": {
                return this.checkNull((Object)this.safe((Object)item.getDestinationNumber()));
            }
            case "callType": {
                return this.checkNull((Object)this.safe((Object)item.getCallType()));
            }
            case "coralCallDirection": {
                return this.checkNull((Object)this.safe((Object)item.getCoralCallDirection()));
            }
            case "talkDuration": {
                return this.checkNull((Object)this.safe((Object)DateFormatUtility.findLocalTime((Long)item.getTalkDuration())));
            }
            case "pulse": {
                return this.checkNull((Object)this.safe((Object)item.getPulse()));
            }
            case "cost": {
                return this.checkNull((Object)this.safe((Object)this.formatAmount(item.getCost())));
            }
        }
        return null;
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadService.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    @PostMapping(value={"/listSummary"})
    public ResponseEntity<RequestResponse> getBillingCdrIncomingSummaryByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.extensionCDRService.getExtensionSummary(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSVExtensionSummary"})
    public ResponseEntity<byte[]> downloadCSVExtensionSummary(@RequestBody SearchRequest request) {
        try {
            List rows;
            LocalDate fromDate = null;
            LocalDate toDate = null;
            String extension = null;
            if (request.getAdvancedFilters() != null) {
                for (AdvanceFilter f : request.getAdvancedFilters()) {
                    if ("callDate".equalsIgnoreCase(f.getFieldName())) {
                        if ("from".equalsIgnoreCase(f.getDirection())) {
                            fromDate = LocalDate.parse(f.getValue());
                        }
                        if ("to".equalsIgnoreCase(f.getDirection())) {
                            toDate = LocalDate.parse(f.getValue());
                        }
                    }
                    if (!"extension".equalsIgnoreCase(f.getFieldName())) continue;
                    extension = f.getValue();
                }
            }
            String sortBy = request.getSortBy();
            String sortDir = request.getSortDirection();
            if (sortBy == null || sortBy.isEmpty()) {
                sortBy = "extension";
            }
            if (sortDir == null || sortDir.isEmpty()) {
                sortDir = "asc";
            }
            if ((rows = this.billingCDRRepository.getExtensionSummary(fromDate, toDate, extension, request.getSearch(), sortBy, sortDir)) == null || rows.isEmpty()) {
                return ResponseEntity.noContent().build();
            }
            List data = rows.stream().map(arg_0 -> this.mapToExtensionSummary(arg_0)).collect(Collectors.toList());
            List<Object> accessors = request.getColumnNames() == null || request.getColumnNames().isEmpty() ? new ArrayList(EXTENSION_HEADER_MAP.keySet()) : request.getColumnNames();
            StringWriter writer = new StringWriter();
            CSVPrinter csvPrinter = new CSVPrinter((Appendable)writer, CSVFormat.DEFAULT.withHeader((String[])accessors.stream().map(EXTENSION_HEADER_MAP::get).toArray(String[]::new)));
            for (ExtensionSummaryModel item : data) {
                ArrayList<Object> row = new ArrayList<Object>();
                Iterator<Object> iterator = accessors.iterator();
                while (iterator.hasNext()) {
                    String col;
                    switch (col = (String)iterator.next()) {
                        case "extension": {
                            row.add(item.getExtension());
                            break;
                        }
                        case "totalCall": {
                            row.add(item.getTotalCall());
                            break;
                        }
                        case "answered": {
                            row.add(item.getAnswered());
                            break;
                        }
                        case "unanswered": {
                            row.add(item.getUnanswered());
                            break;
                        }
                        case "ringDuration": {
                            row.add(item.getRingDuration());
                            break;
                        }
                        case "avgRingDuration": {
                            row.add(item.getAvgRingDuration());
                            break;
                        }
                        case "callDuration": {
                            row.add(item.getCallDuration());
                            break;
                        }
                        case "avgCallDuration": {
                            row.add(item.getAvgCallDuration());
                        }
                    }
                }
                csvPrinter.printRecord(row);
            }
            csvPrinter.flush();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=extension_summary.csv"})).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)writer.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            logger.error("Extension CSV error", (Throwable)e);
            return ResponseEntity.internalServerError().build();
        }
    }

    private ExtensionSummaryModel mapToExtensionSummary(Object[] row) {
        ExtensionSummaryModel m = new ExtensionSummaryModel();
        m.setExtension(String.valueOf(row[0]));
        m.setTotalCall(this.toLong(row[1]));
        m.setAnswered(this.toLong(row[2]));
        m.setUnanswered(this.toLong(row[3]));
        m.setRingDuration(DateFormatUtility.findLocalTime((Long)this.toLong(row[4])));
        m.setAvgRingDuration(DateFormatUtility.findLocalTime((Long)this.toLong(row[5])));
        m.setCallDuration(DateFormatUtility.findLocalTime((Long)this.toLong(row[6])));
        m.setAvgCallDuration(DateFormatUtility.findLocalTime((Long)this.toLong(row[7])));
        return m;
    }

    private Long toLong(Object val) {
        return val == null ? 0L : ((Number)val).longValue();
    }

    private Double toDouble(Object val) {
        if (val == null) {
            return 0.0;
        }
        if (val instanceof BigDecimal) {
            return ((BigDecimal)val).doubleValue();
        }
        return ((Number)val).doubleValue();
    }

    private String formatAmount(Long val) {
        Long costInPaise = val != null ? val : 0L;
        double costInRupees = (double)costInPaise.longValue() / 100.0;
        return String.valueOf(costInRupees);
    }

    @PostMapping(value={"/generateSummaryAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateSummaryAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadService.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    private String safe(Object v) {
        return v != null ? v.toString() : "";
    }

    static {
        COLUMN_MAPPINGS.put("callerIdNumber", "Extension No");
        COLUMN_MAPPINGS.put("datetimeIst", "Call Date Time");
        COLUMN_MAPPINGS.put("destinationNumber", "called Number");
        COLUMN_MAPPINGS.put("callType", "Call Type");
        COLUMN_MAPPINGS.put("coralCallDirection", "Call Direction");
        COLUMN_MAPPINGS.put("talkDuration", "Talk Time(HH:MM:SS)");
        COLUMN_MAPPINGS.put("pulse", "Pulse");
        COLUMN_MAPPINGS.put("cost", "Cost");
        EXTENSION_SUMMARY_MAP = new LinkedHashMap();
        EXTENSION_SUMMARY_MAP.put("Extension No", 0);
        EXTENSION_SUMMARY_MAP.put("Answered", 1);
        EXTENSION_SUMMARY_MAP.put("UnAnswered", 2);
        EXTENSION_SUMMARY_MAP.put("Ring Time", 3);
        EXTENSION_SUMMARY_MAP.put("Avg Ring Time", 4);
        EXTENSION_SUMMARY_MAP.put("Call Time", 5);
        EXTENSION_SUMMARY_MAP.put("Avg Call Time", 6);
        INR_FORMAT = NumberFormat.getCurrencyInstance(new Locale("en", "IN"));
        EXTENSION_HEADER_MAP = new LinkedHashMap();
        EXTENSION_HEADER_MAP.put("extension", "Extension");
        EXTENSION_HEADER_MAP.put("totalCall", "Total Call");
        EXTENSION_HEADER_MAP.put("answered", "Answered");
        EXTENSION_HEADER_MAP.put("unanswered", "Unanswered");
        EXTENSION_HEADER_MAP.put("ringDuration", "Ring Duration");
        EXTENSION_HEADER_MAP.put("avgRingDuration", "Avg Ring Duration");
        EXTENSION_HEADER_MAP.put("callDuration", "Call Duration");
        EXTENSION_HEADER_MAP.put("avgCallDuration", "Avg Call Duration");
    }
}

