/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.customerCDR.service;

import com.coraltele.db.telemetry.main.entity.CustomerCDR;
import com.coraltele.db.telemetry.main.repository.CustomerCDRRepository;
import com.coraltele.db.telemetry.main.specification.AnsweredSpecification;
import com.coraltele.db.telemetry.main.specification.QueueAbandonedSpecification;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.telemetry.main.customerCDR.model.CustomerCDRModel;
import com.coraltele.service.telemetry.main.customerCDR.service.CustomerCDRService;
import com.coraltele.service.user.service.UserService;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class CustomerCDRSecondaryService {
    private static final Logger logger = LogManager.getLogger(CustomerCDRService.class);
    @Autowired
    CustomerCDRRepository customerCDRRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    UserService userService;
    @Autowired
    QueueTLService queueTLService;

    public RequestResponse getListOfQueueAbandoned(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        boolean teamLeaderUser = false;
        if (this.userService.checkRoleTL(principal.getName())) {
            teamLeaderUser = true;
        }
        List queueId = null;
        if (teamLeaderUser) {
            queueId = this.queueTLService.getQueueListByTeamLeader(principal.getName());
        }
        Specification filters = QueueAbandonedSpecification.generateFilters((SearchRequest)searchRequestData, (boolean)teamLeaderUser, queueId);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.customerCDRRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.customerCDRRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<CustomerCDRModel> entityToModelConversion(List<CustomerCDR> lastAgent) {
        ArrayList<CustomerCDRModel> addValue = new ArrayList<CustomerCDRModel>();
        for (CustomerCDR row : lastAgent) {
            CustomerCDRModel data = new CustomerCDRModel();
            data.setUuid(row.getUuid());
            data.setQueue(row.getQueue());
            data.setCcAgent(row.getCcAgent());
            data.setCallId(row.getCallId());
            data.setDuration(DateFormatUtility.findLocalTime((Long)row.getDuration().longValue()));
            data.setQueue(row.getQueue());
            data.setStatus(row.getStatus());
            data.setQueueName(row.getQueueName());
            if (row.getStartTime() != null) {
                data.setStartTime(DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)row.getStartTime()));
            }
            data.setAgentFullName(row.getAgentFullName());
            data.setAgentTalkTime(DateFormatUtility.findLocalTime((Long)row.getAgentTalkTime()));
            data.setAgentTalkedTo(row.getAgentTalkedTo());
            data.setCallDirection(row.getCallDirection());
            data.setRecordingFile(row.getRecordingFile());
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse getListOfAnswered(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = AnsweredSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.customerCDRRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.customerCDRRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

