/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.categoryService.service;

import com.coraltele.db.telemetry.coralnms.entity.Category;
import com.coraltele.db.telemetry.coralnms.repository.CategoryRepository;
import com.coraltele.db.telemetry.main.entity.CategoryService;
import com.coraltele.db.telemetry.main.entity.MonitorService;
import com.coraltele.db.telemetry.main.repository.CategoryServiceRepository;
import com.coraltele.db.telemetry.main.repository.MonitorServiceRepository;
import com.coraltele.db.telemetry.main.specification.CategoryServiceSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.categoryService.model.CategoryCodeModel;
import com.coraltele.service.telemetry.main.categoryService.model.CategoryServiceModel;
import com.coraltele.service.telemetry.main.categoryService.model.CategorySeverityModel;
import com.coraltele.service.telemetry.main.categoryService.model.ServicesCodeModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class CategoryServiceService {
    private static final Logger logger = LogManager.getLogger(CategoryServiceService.class);
    @Autowired
    CategoryServiceRepository categoryServiceRepository;
    @Autowired
    MonitorServiceRepository monitorServiceRepository;
    @Autowired
    CategoryRepository categoryRepository;

    public RequestResponse createCategoryService(CategoryServiceModel data) {
        logger.debug("create new categoryService : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            CategoryService categoryService = new CategoryService();
            categoryService.setCategoryCode(data.getCategoryCode());
            categoryService.setServiceCode(data.getServiceCode());
            categoryService.setSeverity(data.getSeverity());
            categoryService.setAlertDescription(data.getAlertDescription());
            categoryService.setDisableNotification(Boolean.valueOf(data.getDisableNotification() != false));
            if (data.getEscalationLevel1Duration() != null) {
                categoryService.setEscalationLevel1Duration(data.getEscalationLevel1Duration());
            } else {
                categoryService.setEscalationLevel1Duration(Long.valueOf(0L));
            }
            categoryService.setEscalationLevel1MailId(data.getEscalationLevel1MailId());
            categoryService.setEscalationLevel1SmsId(data.getEscalationLevel1SmsId());
            if (data.getEscalationLevel2Duration() != null) {
                categoryService.setEscalationLevel2Duration(data.getEscalationLevel2Duration());
            } else {
                categoryService.setEscalationLevel2Duration(Long.valueOf(0L));
            }
            categoryService.setEscalationLevel2MailId(data.getEscalationLevel2MailId());
            categoryService.setEscalationLevel2SmsId(data.getEscalationLevel2SmsId());
            if (data.getEscalationLevel3Duration() != null) {
                categoryService.setEscalationLevel3Duration(data.getEscalationLevel3Duration());
            } else {
                categoryService.setEscalationLevel3Duration(Long.valueOf(0L));
            }
            categoryService.setEscalationLevel3MailId(data.getEscalationLevel3MailId());
            categoryService.setEscalationLevel3SmsId(data.getEscalationLevel3SmsId());
            categoryService.setEscalationLevel0MailId(data.getEscalationLevel0MailId());
            categoryService.setEscalationLevel0SmsId(data.getEscalationLevel0SmsId());
            this.categoryServiceRepository.save((Object)categoryService);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("categoryService created successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to create categoryService");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(CategoryServiceModel data) {
        logger.debug("Update monitorService {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional categoryServiceOptional = this.categoryServiceRepository.findById(data.getId());
        if (!categoryServiceOptional.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("categoryService not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        CategoryService categoryService = (CategoryService)categoryServiceOptional.get();
        if (data.getCategoryCode() != null) {
            categoryService.setCategoryCode(data.getCategoryCode());
        }
        if (data.getServiceCode() != null) {
            categoryService.setServiceCode(data.getServiceCode());
        }
        if (data.getSeverity() != null) {
            categoryService.setSeverity(data.getSeverity());
        }
        if (data.getAlertDescription() != null) {
            categoryService.setAlertDescription(data.getAlertDescription());
        }
        if (data.getDisableNotification() != null) {
            categoryService.setDisableNotification(data.getDisableNotification());
        }
        if (data.getEscalationLevel1Duration() != null) {
            categoryService.setEscalationLevel1Duration(data.getEscalationLevel1Duration());
        } else {
            categoryService.setEscalationLevel1Duration(Long.valueOf(0L));
        }
        categoryService.setEscalationLevel1MailId(data.getEscalationLevel1MailId());
        categoryService.setEscalationLevel1SmsId(data.getEscalationLevel1SmsId());
        if (data.getEscalationLevel2Duration() != null) {
            categoryService.setEscalationLevel2Duration(data.getEscalationLevel2Duration());
        } else {
            categoryService.setEscalationLevel2Duration(Long.valueOf(0L));
        }
        categoryService.setEscalationLevel2MailId(data.getEscalationLevel2MailId());
        categoryService.setEscalationLevel2SmsId(data.getEscalationLevel2SmsId());
        if (data.getEscalationLevel3Duration() != null) {
            categoryService.setEscalationLevel3Duration(data.getEscalationLevel3Duration());
        } else {
            categoryService.setEscalationLevel3Duration(Long.valueOf(0L));
        }
        categoryService.setEscalationLevel3MailId(data.getEscalationLevel3MailId());
        categoryService.setEscalationLevel3SmsId(data.getEscalationLevel3SmsId());
        categoryService.setEscalationLevel0MailId(data.getEscalationLevel0MailId());
        categoryService.setEscalationLevel0SmsId(data.getEscalationLevel0SmsId());
        this.categoryServiceRepository.save((Object)categoryService);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("categoryService Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteCategoryServiceById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Long ids : data.getId()) {
            Optional categoryService = this.categoryServiceRepository.findById(Long.valueOf(ids));
            if (categoryService.isPresent()) {
                addValue.add(categoryService.get());
                this.categoryServiceRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getCategoryServiceByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = CategoryServiceSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.categoryServiceRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.categoryServiceRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllServiceCode() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<ServicesCodeModel> addValue = new ArrayList<ServicesCodeModel>();
        List monitorService = this.monitorServiceRepository.findAll();
        if (monitorService.isEmpty()) {
            returnValue.setMessage("List is empty");
            logger.error("unable to fetch data: ", (Object)returnValue.getMessage());
        } else {
            for (MonitorService row : monitorService) {
                ServicesCodeModel data = new ServicesCodeModel();
                data.setServiceCode(row.getCode());
                data.setServiceName(row.getServiceName());
                addValue.add(data);
            }
        }
        returnValue.setData(addValue);
        returnValue.setMessage("List of Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllCategoryCode() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<CategoryCodeModel> addValue = new ArrayList<CategoryCodeModel>();
        List category = this.categoryRepository.findAll();
        if (category.isEmpty()) {
            returnValue.setMessage("List is empty");
            logger.error("unable to fetch data: ", (Object)returnValue.getMessage());
        } else {
            for (Category row : category) {
                CategoryCodeModel data = new CategoryCodeModel();
                data.setCategoryCode(row.getCode());
                data.setCategoryName(row.getDescription());
                addValue.add(data);
            }
        }
        returnValue.setData(addValue);
        returnValue.setMessage("List of Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllSeverity() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<CategorySeverityModel> addValue = new ArrayList<CategorySeverityModel>();
        List list = this.categoryServiceRepository.findAll();
        for (CategoryService row : list) {
            CategorySeverityModel data = new CategorySeverityModel();
            data.setId(row.getId());
            data.setSeverity(row.getSeverity());
            addValue.add(data);
        }
        returnValue.setData(addValue);
        returnValue.setMessage("List of Severity");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

