/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.coralnms.imsi.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.telemetry.coralnms.imsi.model.IMSIModel;
import com.coraltele.service.telemetry.coralnms.imsi.service.IMSIService;
import com.coraltele.service.telemetry.main.userCoordinate.service.UserCoordinateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/imsi"})
@RestController
public class IMSIController {
    @Autowired
    IMSIService imsiService;
    @Autowired
    UserCoordinateService userCoordinateService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> create(@RequestBody IMSIModel data) {
        RequestResponse returnValue = this.imsiService.createData(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateById(@RequestBody IMSIModel data) {
        RequestResponse returnValue = this.imsiService.updateById(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.imsiService.deleteIMSIByExtensionNumber(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllCategoryByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.imsiService.getAllIMSIByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/emergencyList"})
    public ResponseEntity<RequestResponse> getAllEmergencyByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.userCoordinateService.getAllUserCoordinateEmergency(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

