/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.systemConfig.service;

import com.coraltele.db.telephony.pbx.repository.SystemConfigRepository;
import com.coraltele.helper.Constants;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UuidUpdateNotifier {
    @Autowired
    private SystemConfigRepository repository;
    private static final ThreadLocal<Boolean> isUpdating = ThreadLocal.withInitial(() -> false);

    @PostConstruct
    public void init() {
        Constants.updateNotifier.set(this);
    }

    public void notifyUuidChange() {
        if (((Boolean)isUpdating.get()).booleanValue()) {
            return;
        }
        try {
            isUpdating.set(true);
            this.repository.updateUUID();
        }
        finally {
            isUpdating.remove();
        }
    }
}

