/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.nodeConfiguration.service;

import com.coraltele.db.telemetry.main.repository.TelephonyDeploymentRepository;
import com.coraltele.db.telephony.pbx.entity.NodeConfiguration;
import com.coraltele.db.telephony.pbx.repository.NodeConfigurationRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.interface_model.IRLU;
import com.coraltele.model.interface_model.IServerNode;
import com.coraltele.service.pbx.controlRluServer.model.ControlRluServerModel;
import com.coraltele.service.pbx.controlRluServer.service.ControlRluServerService;
import com.coraltele.service.pbx.nodeConfiguration.model.NodeConfigurationModel;
import com.coraltele.service.pbx.nodeConfiguration.model.NodeVirtualIp;
import com.coraltele.service.pbx.nodeConfiguration.model.ServerIpListModel;
import com.coraltele.service.syncData.service.PostgresRestoreService;
import com.coraltele.service.telemetry.main.telephonyDeployment.service.TelephonyDeploymentService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NodeConfigurationService {
    private static final Logger logger = LogManager.getLogger(NodeConfigurationService.class);
    @Autowired
    NodeConfigurationRepository nodeConfigurationRepository;
    @Autowired
    ControlRluServerService controlRluServerService;
    @Autowired
    TelephonyDeploymentService telephonyDeploymentService;
    @Autowired
    TelephonyDeploymentRepository telephonyDeploymentRepository;
    @Autowired
    PostgresRestoreService restoreService;

    public List<NodeConfigurationModel> nodeIp() {
        List list = this.nodeConfigurationRepository.findAll();
        ArrayList<NodeConfigurationModel> addValue = new ArrayList<NodeConfigurationModel>();
        if (list.isEmpty() || list.size() <= 1) {
            addValue.add(new NodeConfigurationModel());
            logger.info("Data Not Found");
        } else {
            list.forEach(element -> {
                NodeConfigurationModel nodeConfiguration = NodeConfigurationModel.builder().nodeIp(element.getNodeIp()).nodeName(element.getNodeName()).build();
                addValue.add(nodeConfiguration);
            });
            logger.info("Data Found");
        }
        return addValue;
    }

    public RequestResponse customList() {
        RequestResponse returnValue = new RequestResponse();
        List rlus = this.telephonyDeploymentRepository.getRLU();
        List nodes = this.telephonyDeploymentRepository.getNodeList();
        if (nodes.isEmpty()) {
            ArrayList<NodeVirtualIp> nvIp = new ArrayList<NodeVirtualIp>();
            List nodeData = this.nodeIp();
            List virtualData = this.controlRluServerService.virtualIp();
            NodeVirtualIp nodeVirtualIp = NodeVirtualIp.builder().nodeConfiguration(nodeData).controlRluServer(virtualData).build();
            nvIp.add(nodeVirtualIp);
            returnValue.setData(nvIp);
        } else {
            ArrayList<NodeVirtualIp> nvIp = new ArrayList<NodeVirtualIp>();
            NodeVirtualIp dataToReturn = new NodeVirtualIp();
            dataToReturn.setControlRluServer(new ArrayList());
            dataToReturn.setNodeConfiguration(new ArrayList());
            for (IRLU rlu : rlus) {
                dataToReturn.getControlRluServer().add(new ControlRluServerModel(rlu.getVirtualIP(), rlu.getRLUCode()));
            }
            for (IServerNode node : nodes) {
                dataToReturn.getNodeConfiguration().add(new NodeConfigurationModel(node.getIPAddress(), node.getNodeName()));
            }
            nvIp.add(dataToReturn);
            returnValue.setData(nvIp);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Found");
        returnValue.setMessageDetail("Non paginated Data");
        return returnValue;
    }

    @PostConstruct
    public void getNodeIp() {
        Constants.NODE_IP_LIST.put("127.0.0.1", "127.0.0.1");
        Constants.NODE_IP_LIST.put("0:0:0:0:0:0:0:1", "0:0:0:0:0:0:0:1");
        this.nodeConfigurationRepository.findAll().forEach(element -> {
            logger.info("Adding node ip to valid list : {}", (Object)element.getNodeIp());
            Constants.NODE_IP_LIST.put(element.getNodeIp(), element.getNodeIp());
        });
    }

    public RequestResponse getAllDestinationServer() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<ServerIpListModel> list = new ArrayList<ServerIpListModel>();
        try {
            List ipList = this.nodeConfigurationRepository.findAll();
            if (ipList != null && !ipList.isEmpty()) {
                for (NodeConfiguration data : ipList) {
                    ServerIpListModel row = new ServerIpListModel();
                    if (!data.getServerCode().equals(this.restoreService.getServerCode())) {
                        row.setNodeIp(data.getVirtualIp());
                        row.setNodeName(data.getNodeName());
                        row.setServerType("Destination");
                        list.add(row);
                        continue;
                    }
                    row.setNodeIp(data.getVirtualIp());
                    row.setNodeName(data.getNodeName());
                    row.setServerType("Source");
                    list.add(row);
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("List of Servers");
                returnValue.setMessageDetail("Non paginated Data");
                returnValue.setData(list);
            } else {
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Data not present");
                returnValue.setMessageDetail("Empty list return");
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error while getting data");
            returnValue.setMessageDetail("Unable to find data");
            logger.error("Error on getting server list:{}", (Object)e.getMessage());
        }
        return returnValue;
    }
}

