/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.gis.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.gis.model.AreaSelectedModel;
import com.coraltele.service.gis.service.GISService;
import com.coraltele.service.telemetry.main.userCoordinate.service.UserCoordinateService;
import java.security.Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/gis"})
@RestController
public class GISController {
    private static final Logger logger = LogManager.getLogger(GISController.class);
    @Autowired
    GISService gisService;
    @Autowired
    UserCoordinateService userCoordinateService;

    @PostMapping(value={"/areaSelected"})
    public ResponseEntity<RequestResponse> areaSelected(@RequestBody AreaSelectedModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        logger.info("Dial to Area message received : {}", (Object)data.toString());
        this.userCoordinateService.dialSelected(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info("queue list successfully!");
            return ResponseEntity.ok((Object)returnValue);
        }
        logger.info("failed on getting queue list!");
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/callZone/{zone}"})
    public ResponseEntity<RequestResponse> areaSelected(@PathVariable(value="zone") String zone) {
        RequestResponse returnValue = new RequestResponse();
        logger.info("Dial to Zone received : {}", (Object)zone);
        this.gisService.dialZone(zone);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info("queue list successfully!");
            return ResponseEntity.ok((Object)returnValue);
        }
        logger.info("failed on getting queue list!");
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/zoneSelected/{id}"})
    public ResponseEntity<RequestResponse> zoneArea(@PathVariable(value="id") String id) {
        RequestResponse returnValue = new RequestResponse();
        this.userCoordinateService.callingToSelectedZone(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info("queue list successfully!");
            return ResponseEntity.ok((Object)returnValue);
        }
        logger.info("failed on getting queue list!");
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

