/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.configuration.nodeConfiguration.service;

import com.coraltele.db.telephony.main.entity.Routes;
import com.coraltele.db.telephony.main.repository.RoutesRepository;
import com.coraltele.db.telephony.main.specification.RoutesSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.configuration.nodeConfiguration.model.RoutesModel;
import com.coraltele.service.configuration.nodeConfiguration.service.WAnsService;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class RoutesService {
    private static final Logger logger = LogManager.getLogger(WAnsService.class);
    @Autowired
    private RoutesRepository routesRepo;

    public List<Routes> getList() {
        return this.routesRepo.findAll();
    }

    public RequestResponse getList(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = RoutesSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.routesRepo.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.routesRepo.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        return returnValue;
    }

    public RequestResponse register(RoutesModel data) {
        RequestResponse returnValue = new RequestResponse();
        Routes dataToSave = new Routes();
        dataToSave.setIp(data.getIp());
        dataToSave.setGateway(data.getGateway());
        dataToSave.setCidr(data.getCidr());
        dataToSave.setInterfaces(data.getInterfaces());
        dataToSave.setNodes(data.getNodes());
        this.routesRepo.save((Object)dataToSave);
        return returnValue;
    }

    public RequestResponse update(RoutesModel data) {
        RequestResponse returnValue = new RequestResponse();
        Optional currentRecord = this.routesRepo.findById((Object)data.getId());
        if (currentRecord.isPresent()) {
            Routes dataToSave = (Routes)currentRecord.get();
            dataToSave.setIp(data.getIp());
            dataToSave.setGateway(data.getGateway());
            dataToSave.setCidr(data.getCidr());
            dataToSave.setInterfaces(data.getInterfaces());
            dataToSave.setNodes(data.getNodes());
            this.routesRepo.save((Object)dataToSave);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Data updated successfully");
        } else {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Unable to find the record");
        }
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse delete(InputIdModel dataToDelete) {
        RequestResponse returnValue = new RequestResponse();
        for (Long row : dataToDelete.getId()) {
            this.routesRepo.deleteById((Object)row);
        }
        return returnValue;
    }
}

