/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.configuration.nodeConfiguration.controller;

import com.coraltele.db.telephony.main.repository.NodeClusterRepository;
import com.coraltele.db.telephony.main.repository.RoutesRepository;
import com.coraltele.db.telephony.main.repository.WAnsRepository;
import com.coraltele.helper.BashCmd;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.configuration.nodeConfiguration.model.CoralConfigurationModel;
import com.coraltele.service.configuration.nodeConfiguration.model.HostnameModel;
import com.coraltele.service.configuration.nodeConfiguration.model.IsPreviewModel;
import com.coraltele.service.configuration.nodeConfiguration.model.NodeClusterModel;
import com.coraltele.service.configuration.nodeConfiguration.model.NodeClusterModelBulk;
import com.coraltele.service.configuration.nodeConfiguration.model.UpdateNodesModel;
import com.coraltele.service.configuration.nodeConfiguration.service.NodeClusterService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RequestMapping(value={"/api/v2/configuration"})
@RestController
public class NodeClusterController {
    private static final Logger logger = LogManager.getLogger(NodeClusterController.class);
    private final ExecutorService executorService = Executors.newFixedThreadPool(1);
    private static final String CONTROLLER_NAME = "Node Cluster:";
    @Autowired
    NodeClusterRepository nodeClusterRepository;
    @Autowired
    RoutesRepository routeRepo;
    @Autowired
    WAnsRepository wanRepo;
    @Autowired
    NodeClusterService nodeClusterService;
    @Autowired
    BashCmd shellCommand;

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllNodeCluster(@RequestBody SearchRequest data) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String dataReceived = objectMapper.writeValueAsString((Object)data);
            String message = MessageFormat.format("{1} received for listing : {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            RequestResponse returnValue = this.nodeClusterService.getList(data);
            if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                message = MessageFormat.format("{1} data processed successfully for listing : {0}", CONTROLLER_NAME, dataReceived);
                logger.info(message);
                return ResponseEntity.ok((Object)returnValue);
            }
            message = MessageFormat.format("{1} unable to process data for listing: {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (JsonProcessingException e) {
            RequestResponse returnValue = new RequestResponse();
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Invalid json data");
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/register"})
    public ResponseEntity<RequestResponse> registerNodeCluster(@RequestBody NodeClusterModel data) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String dataReceived = objectMapper.writeValueAsString((Object)data);
            String message = MessageFormat.format("{1} received for registering : {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            RequestResponse returnValue = this.nodeClusterService.register(data);
            if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                message = MessageFormat.format("{1} data processed successfully for registering : {0}", CONTROLLER_NAME, dataReceived);
                logger.info(message);
                return ResponseEntity.ok((Object)returnValue);
            }
            message = MessageFormat.format("{1} unable to process data for registering: {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (JsonProcessingException e) {
            RequestResponse returnValue = new RequestResponse();
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Invalid json data");
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateNodeCluster(@RequestBody NodeClusterModel data) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String dataReceived = objectMapper.writeValueAsString((Object)data);
            String message = MessageFormat.format("{1} received for update : {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            RequestResponse returnValue = this.nodeClusterService.update(data);
            if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                message = MessageFormat.format("{1} data processed successfully for update : {0}", CONTROLLER_NAME, dataReceived);
                logger.info(message);
                return ResponseEntity.ok((Object)returnValue);
            }
            message = MessageFormat.format("{1} unable to process data for update: {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (JsonProcessingException e) {
            RequestResponse returnValue = new RequestResponse();
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Invalid json data");
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteNodeCluster(@RequestBody InputIdModel data) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String dataReceived = objectMapper.writeValueAsString((Object)data);
            String message = MessageFormat.format("{1} received for delete : {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            RequestResponse returnValue = this.nodeClusterService.delete(data);
            if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                message = MessageFormat.format("{1} data processed successfully for delete : {0}", CONTROLLER_NAME, dataReceived);
                logger.info(message);
                return ResponseEntity.ok((Object)returnValue);
            }
            message = MessageFormat.format("{1} unable to process data for delete: {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (JsonProcessingException e) {
            RequestResponse returnValue = new RequestResponse();
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Invalid json data");
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/bulkUpdate"})
    public ResponseEntity<RequestResponse> bulkUpdateNodeCluster(@RequestBody NodeClusterModelBulk data) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String dataReceived = objectMapper.writeValueAsString((Object)data);
            String message = MessageFormat.format("{1} received for bulk update : {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            RequestResponse returnValue = this.nodeClusterService.bulkUpdate(data);
            if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                message = MessageFormat.format("{1} data processed successfully for bulk update : {0}", CONTROLLER_NAME, dataReceived);
                logger.info(message);
                return ResponseEntity.ok((Object)returnValue);
            }
            message = MessageFormat.format("{1} unable to process data for bulk update: {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (JsonProcessingException e) {
            RequestResponse returnValue = new RequestResponse();
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Invalid json data");
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/publish"})
    public ResponseEntity<RequestResponse> publish(@RequestBody IsPreviewModel data) {
        String message = MessageFormat.format("{0} Publish Start", CONTROLLER_NAME);
        logger.info(message);
        RequestResponse returnValue = this.nodeClusterService.publish(data.getIsPreview());
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            message = MessageFormat.format("{0} Publish Finished", CONTROLLER_NAME);
            logger.info(message);
            return ResponseEntity.ok((Object)returnValue);
        }
        message = MessageFormat.format("{1} unable to Publish records: {0}:failed", CONTROLLER_NAME);
        logger.info(message);
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/nodes"})
    public ResponseEntity<RequestResponse> listNodes() {
        RequestResponse returnValue = this.nodeClusterService.listOfNodes();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/node"})
    public ResponseEntity<RequestResponse> updateNode(@RequestBody UpdateNodesModel data) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String dataReceived = objectMapper.writeValueAsString((Object)data);
            String message = MessageFormat.format("{1} received for update : {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            RequestResponse returnValue = this.nodeClusterService.updateNode(data);
            if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                message = MessageFormat.format("{1} data processed successfully for update : {0}", CONTROLLER_NAME, dataReceived);
                logger.info(message);
                return ResponseEntity.ok((Object)returnValue);
            }
            message = MessageFormat.format("{1} unable to process data for update node: {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (JsonProcessingException e) {
            RequestResponse returnValue = new RequestResponse();
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Invalid json data");
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/decryptClusterKey"})
    public ResponseEntity<RequestResponse> decryptClusterKey() throws Exception {
        RequestResponse returnValue = this.nodeClusterService.decryptClusterKey();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/download"})
    @ResponseBody
    public ResponseEntity<StreamingResponseBody> streamJsonFile() {
        List nodes = this.nodeClusterRepository.findAll();
        List routeNode = this.routeRepo.findAll();
        List wanNode = this.wanRepo.findAll();
        CoralConfigurationModel records = new CoralConfigurationModel();
        records.setNodes(nodes);
        records.setRoutes(routeNode);
        records.setWAns(wanNode);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        byte[] buffer = new byte[1024];
        HttpHeaders responseHeaders = new HttpHeaders();
        try {
            String jsonContent = objectMapper.writeValueAsString((Object)records);
            responseHeaders.add("Content-Type", "application/json");
            StreamingResponseBody responseStream = os -> {
                int bytesRead;
                ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonContent.getBytes());
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    os.write(buffer, 0, bytesRead);
                }
                os.flush();
                ((InputStream)inputStream).close();
            };
            logger.info("JSON file streaming request processed successfully.");
            return new ResponseEntity((Object)responseStream, (MultiValueMap)responseHeaders, HttpStatus.OK);
        }
        catch (JsonProcessingException e) {
            logger.error("Error occurred while generating JSON file: {}", (Object)e.getMessage(), (Object)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
        catch (UnknownError e) {
            logger.error("Unknown error occurred while processing JSON file streaming request: {}", (Object)e.getMessage(), (Object)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/upload"})
    public ResponseEntity<RequestResponse> uploadFile(@RequestPart(value="file") MultipartFile jsonFile) {
        String message = MessageFormat.format("{1} received file update: {0}", CONTROLLER_NAME, jsonFile.getOriginalFilename());
        logger.info(message);
        RequestResponse returnValue = this.nodeClusterService.uploadDataFromJsonFile(jsonFile);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            message = MessageFormat.format("{1} file upload successfully for update: {0}", CONTROLLER_NAME, jsonFile.getOriginalFilename());
            logger.info(message);
            return ResponseEntity.ok((Object)returnValue);
        }
        message = MessageFormat.format("{1} unable to upload json file for update node: {0}", CONTROLLER_NAME, jsonFile.getOriginalFilename());
        logger.info(message);
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/getHostname"})
    public ResponseEntity<RequestResponse> getHostname() throws IOException {
        RequestResponse returnValue = this.nodeClusterService.getHostName();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateHostname"})
    public ResponseEntity<RequestResponse> updateHostname(@RequestBody HostnameModel data) throws IOException {
        RequestResponse returnValue = this.nodeClusterService.updateHostName(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/serverReboot"})
    public ResponseEntity<RequestResponse> reboot() {
        RequestResponse response = new RequestResponse();
        response.setMessage("Reboot initiated successfully");
        logger.info(response.getMessage());
        this.executorService.execute(() -> {
            String cmd = "sleep 6 && sudo reboot";
            String returnValue = this.shellCommand.executeCommand(cmd);
            response.setMessageDetail(returnValue);
        });
        return ResponseEntity.ok((Object)response);
    }
}

