/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.configuration.fileTransfer.service;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.configuration.fileTransfer.model.FileTransferModel;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ini4j.Ini;
import org.ini4j.IniPreferences;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class FileTransferService {
    private static final Logger logger = LogManager.getLogger(FileTransferService.class);

    private static RequestResponse readProperties(FileTransferModel data) {
        String clusterConfiguration = "/etc/default/coral";
        RequestResponse returnValue = new RequestResponse();
        try {
            Ini ini = new Ini(new File(clusterConfiguration));
            IniPreferences configuration = new IniPreferences(ini);
            String key = "BACKUP";
            for (String param : configuration.node(key).keys()) {
                String[] values = configuration.node(key).get(param, "").split(",");
                if (values.length != 4) {
                    logger.error("Invalid syntax in configuration file for key: {}", (Object)param);
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("Configuration file has invalid syntax");
                    returnValue.setMessageDetail("Please check the syntax for key: " + param);
                    return returnValue;
                }
                data.setRemoteHost(param);
                data.setMethodType(values[0]);
                data.setUsername(values[1]);
                data.setPassword(values[2]);
                data.setRemoteFilePath(values[3]);
            }
        }
        catch (IOException ex) {
            logger.error("Error reading the Coral configuration file: {}", (Object)ex.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error reading the configuration file");
            returnValue.setMessageDetail("Ensure the configuration file exists and is accessible.");
            return returnValue;
        }
        catch (Exception ex) {
            logger.error("Unexpected error while reading the Coral configuration file: {}", (Object)ex.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unexpected error");
            returnValue.setMessageDetail("Please contact the administrator.");
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse transferFile(FileTransferModel data) {
        RequestResponse requestResponse;
        RequestResponse returnValue = FileTransferService.readProperties((FileTransferModel)data);
        if (returnValue.getStatus().equals((Object)Constants.Error.ERROR)) {
            return returnValue;
        }
        Session session = null;
        Channel channel = null;
        ChannelSftp channelSftp = null;
        try {
            JSch jsch = new JSch();
            session = jsch.getSession(data.getUsername(), data.getRemoteHost(), 22);
            session.setPassword(data.getPassword());
            session.setConfig("StrictHostKeyChecking", "no");
            session.connect();
            channel = session.openChannel("sftp");
            channel.connect();
            channelSftp = (ChannelSftp)channel;
            File localFile = new File(data.getLocalFilePath());
            if (!localFile.exists() || !localFile.canRead()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Selected file does not exist or cannot be read");
                returnValue.setMessageDetail("Please select a valid backup file path");
                logger.error("Local file does not exist or cannot be read: {}", (Object)localFile.getAbsolutePath());
                RequestResponse requestResponse2 = returnValue;
                return requestResponse2;
            }
            channelSftp.put(localFile.getAbsolutePath(), data.getRemoteFilePath());
            logger.info("File transfer completed successfully.");
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("File transfer completed successfully");
            RequestResponse requestResponse3 = returnValue;
            return requestResponse3;
        }
        catch (JSchException ex) {
            logger.error("SSH error during file transfer: {}", (Object)ex.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("SSH error during file transfer");
            returnValue.setMessageDetail("Please check the SSH connection details.");
            requestResponse = returnValue;
            return requestResponse;
        }
        catch (SftpException ex) {
            logger.error("SFTP error during file transfer: {}", (Object)ex.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("SFTP error during file transfer");
            returnValue.setMessageDetail("Please check the SFTP details and file paths.");
            requestResponse = returnValue;
            return requestResponse;
        }
        catch (Exception ex) {
            logger.error("Unexpected error during file transfer: {}", (Object)ex.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unexpected error");
            returnValue.setMessageDetail("Please contact the administrator.");
            requestResponse = returnValue;
            return requestResponse;
        }
        finally {
            if (channelSftp != null) {
                channelSftp.exit();
            }
            if (channel != null) {
                channel.disconnect();
            }
            if (session != null) {
                session.disconnect();
            }
        }
    }
}

