/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.helper;

import com.coraltele.helper.ChannelMessage;
import com.coraltele.helper.Constants;
import com.coraltele.helper.EventNotification;
import com.coraltele.helper.EventNotifyModel;
import com.coraltele.model.VoiceMessageModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ini4j.Ini;
import org.ini4j.Profile;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpUtils {
    private static final Logger logger = LogManager.getLogger(HttpUtils.class);
    private static final String[] IP_HEADERS = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_X_FORWARDED_FOR", "HTTP_X_FORWARDED", "HTTP_X_CLUSTER_CLIENT_IP", "HTTP_CLIENT_IP", "HTTP_FORWARDED_FOR", "HTTP_FORWARDED", "HTTP_VIA", "REMOTE_ADDR"};

    private HttpUtils() {
    }

    public static String getWebsocketAPI() {
        String returnValue = MessageFormat.format("http://{0}:8989", "127.0.0.1");
        return returnValue;
    }

    public static String getSysConfigAPI() {
        String returnValue = MessageFormat.format("http://{0}", "127.0.0.1");
        return returnValue;
    }

    public static String getRequestIp(HttpServletRequest request) {
        String xForwardedFor = request.getHeader("X-ORIG-IP");
        if (xForwardedFor != null) {
            logger.info("Request IP Address is:{},{}", (Object)xForwardedFor, (Object)xForwardedFor.split(",")[0]);
            return xForwardedFor.split(",")[0];
        }
        String fullUrl = request.getRequestURL().toString();
        if (request.getQueryString() != null) {
            fullUrl = fullUrl + "?" + request.getQueryString();
        }
        logger.warn("X-ORIG-IP header not found. Request URL: {}", (Object)fullUrl);
        return "Invalid IP";
    }

    public static String getIpHolder(HttpServletRequest request) {
        String ip = HttpUtils.getRequestIp((HttpServletRequest)request);
        if (ip.equals("127.0.0.1") || ip.equals("0:0:0:0:0:0:0:1")) {
            return "Internal";
        }
        return "External";
    }

    public static Long searchPhoneNumber(Long phoneNumber) {
        String value = "           " + phoneNumber.toString();
        value = value.substring(value.length() - 10, value.length());
        return Long.valueOf(value.trim());
    }

    public static Long searchPhoneNumber(String phoneNumber) {
        String value = "           " + phoneNumber.replace("+", "");
        value = value.substring(value.length() - 10, value.length());
        return Long.valueOf(value.trim());
    }

    public static String sendToWebSocket(ChannelMessage message) {
        String result = "";
        try {
            String url = Constants.WEB_SOCKET_URL + "/sendEvent";
            logger.info("Send event to websocket {}", (Object)url);
            HttpPost post = new HttpPost(url);
            ObjectMapper objectMapper = new ObjectMapper();
            String data = objectMapper.writeValueAsString((Object)message);
            post.addHeader("content-type", "application/json");
            StringEntity requestEntity = new StringEntity(data, ContentType.APPLICATION_JSON);
            post.setEntity((HttpEntity)requestEntity);
            try (CloseableHttpClient httpClient = HttpClients.createDefault();
                 CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
                result = EntityUtils.toString((HttpEntity)response.getEntity());
            }
        }
        catch (Exception E) {
            return null;
        }
        return result;
    }

    public static String sendNotificationToWebSocket(EventNotification message) {
        String result = "";
        String data = "";
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            data = objectMapper.writeValueAsString((Object)message);
        }
        catch (Exception e) {
            logger.error("Unable to parse the message");
        }
        try {
            String url = Constants.WEB_SOCKET_URL + "/sendUserNotification";
            logger.info("Send event to websocket {}", (Object)url);
            HttpPost post = new HttpPost(url);
            post.addHeader("content-type", "application/json");
            StringEntity requestEntity = new StringEntity(data, ContentType.APPLICATION_JSON);
            post.setEntity((HttpEntity)requestEntity);
            try (CloseableHttpClient httpClient = HttpClients.createDefault();
                 CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
                result = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            logger.error("HTTP Called : for {}", (Object)data);
        }
        catch (Exception E) {
            logger.error("Unable to send data event : {}", (Object)data, (Object)E);
        }
        return result;
    }

    public static String sendAlertToWebSocket(EventNotifyModel message) {
        String result = "";
        String data = "";
        String clusterKey = HttpUtils.getClusterKey();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            data = objectMapper.writeValueAsString((Object)message);
        }
        catch (Exception e) {
            logger.error("Unable to parse the message");
        }
        try {
            String url = Constants.PPDR_SOCKET_URL;
            System.out.println("Send event to websocket: " + url);
            HttpPost post = new HttpPost(url);
            post.addHeader("Content-Type", "application/json");
            post.addHeader("Authorization", "Cluster " + clusterKey);
            StringEntity requestEntity = new StringEntity(data, ContentType.APPLICATION_JSON);
            post.setEntity((HttpEntity)requestEntity);
            logger.info("Send event to websocket {}", (Object)url);
            try (CloseableHttpClient httpClient = HttpClients.createDefault();
                 CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
                result = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            logger.error("HTTP Called : for {}", (Object)data);
        }
        catch (Exception E) {
            logger.error("Unable to send data event : {}", (Object)data, (Object)E);
        }
        return result;
    }

    public static String sendVoiceMessagePPDR(VoiceMessageModel message) {
        String result = "";
        String data = "";
        String clusterKey = HttpUtils.getClusterKey();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            data = objectMapper.writeValueAsString((Object)message);
        }
        catch (Exception e) {
            logger.error("Unable to parse the message");
        }
        try {
            String url = "http://127.0.0.1/ppdr/api/v2/broadcast/send";
            logger.info("Send voice message to PPDR {}", (Object)url);
            HttpPost post = new HttpPost(url);
            post.addHeader("Content-Type", "application/json");
            post.addHeader("Authorization", "Cluster " + clusterKey);
            StringEntity requestEntity = new StringEntity(data, ContentType.APPLICATION_JSON);
            post.setEntity((HttpEntity)requestEntity);
            try (CloseableHttpClient httpClient = HttpClients.createDefault();
                 CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
                result = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            logger.error("HTTP Called : for {}", (Object)data);
        }
        catch (Exception E) {
            logger.error("Unable to send data event : {}", (Object)data, (Object)E);
        }
        return result;
    }

    public static String getClusterKey() {
        String clusterKey;
        block3: {
            String coralFilePath = "/etc/default/coral";
            clusterKey = "";
            try {
                Ini ini;
                File file = new File(coralFilePath);
                if (!file.exists() || !(ini = new Ini(file)).containsKey((Object)"CLUSTER")) break block3;
                Profile.Section cscfSection = (Profile.Section)ini.get((Object)"CLUSTER");
                if (cscfSection.containsKey((Object)"CLUSTER-KEY")) {
                    clusterKey = (String)cscfSection.get((Object)"CLUSTER-KEY");
                    break block3;
                }
                return "";
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
        return clusterKey;
    }
}

