/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.helper;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import org.springframework.stereotype.Component;

@Component
public class DateConverter {
    public LocalDate convertToLocalDate(LocalTime inputTime) {
        LocalTime currentTime = LocalTime.now();
        LocalDate currentDate = LocalDate.now();
        LocalDate outputDate = inputTime.isAfter(currentTime) ? currentDate : currentDate.plusDays(1L);
        return outputDate;
    }

    public Integer concatenateAndConvertToEpoch(LocalTime time, LocalDate date) {
        String dateTimeString = date.toString() + "T" + time.toString();
        Integer milliseconds = (int)LocalDateTime.parse(dateTimeString).atZone(ZoneId.systemDefault()).toEpochSecond();
        return milliseconds;
    }
}

