/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.db.billing.main.specification;

import com.coraltele.db.billing.main.entity.view.UserStatusView;
import com.coraltele.model.Filter;
import com.coraltele.model.SearchResultModel;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.jpa.domain.Specification;

public class AgentStatusSpecificationNew {
    private static final Logger logger = LogManager.getLogger(AgentStatusSpecificationNew.class);

    private AgentStatusSpecificationNew() {
    }

    public static Specification<UserStatusView> buildSpecification(SearchResultModel request, List<String> agentList) {
        return (Specification & Serializable)(root, query, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            for (Filter filter : request.getFilters()) {
                String datatype = filter.getDataType();
                String field = filter.getField();
                String operator = filter.getOperator();
                String value1 = filter.getValue1();
                String value2 = filter.getValue2();
                List value3 = filter.getValue3();
                switch (operator.toLowerCase()) {
                    case "between": {
                        LocalDate fromDate;
                        DateTimeFormatter dateFormatter;
                        if ("datetime".equalsIgnoreCase(datatype)) {
                            dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                            fromDate = LocalDate.parse(value1, dateFormatter);
                            LocalDate toDate = LocalDate.parse(value2, dateFormatter);
                            predicates.add(criteriaBuilder.between((Expression)root.get(field), (Comparable)fromDate, (Comparable)toDate));
                        }
                        if ("time".equalsIgnoreCase(datatype)) {
                            predicates.add(criteriaBuilder.between((Expression)root.get(field), (Comparable)((Object)value1), (Comparable)((Object)value2)));
                        }
                        if ("integer".equalsIgnoreCase(datatype)) {
                            Integer from = Integer.parseInt(value1);
                            Integer to = Integer.parseInt(value2);
                            predicates.add(criteriaBuilder.between((Expression)root.get(field), (Comparable)from, (Comparable)to));
                        }
                        if (!"string".equalsIgnoreCase(datatype)) break;
                        predicates.add(criteriaBuilder.between((Expression)root.get(field), (Comparable)((Object)value1), (Comparable)((Object)value2)));
                        break;
                    }
                    case "is": {
                        DateTimeFormatter dateFormatter;
                        if ("datetime".equalsIgnoreCase(datatype)) {
                            dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                            LocalDate targetDate = LocalDate.parse(value1, dateFormatter);
                            predicates.add(criteriaBuilder.equal((Expression)root.get(field), (Object)targetDate));
                        }
                        if ("time".equalsIgnoreCase(datatype)) {
                            predicates.add(criteriaBuilder.equal((Expression)root.get(field), (Object)value1));
                        }
                        if ("integer".equalsIgnoreCase(datatype) && value3 != null && !value3.isEmpty()) {
                            List intValues = value3.stream().map(Integer::parseInt).collect(Collectors.toList());
                            predicates.add(root.get(field).in(intValues));
                        }
                        if (!"string".equalsIgnoreCase(datatype) || value3 == null || value3.isEmpty()) break;
                        List lowerValues = value3.stream().map(String::toLowerCase).collect(Collectors.toList());
                        Expression fieldExpr = criteriaBuilder.lower((Expression)root.get(field));
                        predicates.add(fieldExpr.in(lowerValues));
                        break;
                    }
                    case "greaterthan": {
                        LocalDate fromDate;
                        DateTimeFormatter dateFormatter;
                        if ("datetime".equalsIgnoreCase(datatype)) {
                            dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                            fromDate = LocalDate.parse(value1, dateFormatter);
                            predicates.add(criteriaBuilder.greaterThan((Expression)root.get(field), (Comparable)fromDate));
                        }
                        if ("time".equalsIgnoreCase(datatype)) {
                            predicates.add(criteriaBuilder.greaterThan((Expression)root.get(field), (Comparable)((Object)value1)));
                        }
                        if (!"integer".equalsIgnoreCase(datatype)) break;
                        Integer intValue = Integer.parseInt(value1);
                        predicates.add(criteriaBuilder.gt((Expression)root.get(field), (Number)intValue));
                        break;
                    }
                    case "lessthan": {
                        DateTimeFormatter dateFormatter;
                        if ("datetime".equalsIgnoreCase(datatype)) {
                            dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                            LocalDate toDate = LocalDate.parse(value1, dateFormatter);
                            predicates.add(criteriaBuilder.lessThan((Expression)root.get(field), (Comparable)toDate));
                        }
                        if ("time".equalsIgnoreCase(datatype)) {
                            predicates.add(criteriaBuilder.lessThan((Expression)root.get(field), (Comparable)((Object)value1)));
                        }
                        if (!"integer".equalsIgnoreCase(datatype)) break;
                        Integer intValue = Integer.parseInt(value1);
                        predicates.add(criteriaBuilder.lt((Expression)root.get(field), (Number)intValue));
                    }
                }
            }
            if (agentList != null && !agentList.isEmpty()) {
                predicates.add(root.get("username").in((Collection)agentList));
            }
            if (!request.getSorts().isEmpty()) {
                List orders = request.getSorts().stream().map(sort -> {
                    String column = sort.getColumn();
                    Path path = root.get(column);
                    return "descending".equalsIgnoreCase(sort.getDirection()) ? criteriaBuilder.desc((Expression)path) : criteriaBuilder.asc((Expression)path);
                }).collect(Collectors.toList());
                query.orderBy(orders);
            }
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        };
    }
}

