CREATE OR REPLACE VIEW public.v_getuserinfo
 AS
 SELECT a.id AS userid,
    a.username,
    a.password,
        CASE
            WHEN a.enabled = 0::smallint THEN 'No'::text
            ELSE 'Yes'::text
        END AS enabled,
    a.description,
    a.emailid,
    a.contactno,
    b.role AS roleid,
    b.rolecode,
    a.sippass,
    a.isondemand,
    a.maxnoanswer,
    a.wrapuptime,
    a.rejectdelaytime,
    a.busydelaytime,
    a.noanswerdelaytime,
    a.calltimeout,
    a.autoans,
    a.do_not_disturb,
    a.agentshiftid,
    a.location,
    a.usergroup
   FROM m_user a
     LEFT JOIN ( SELECT a_1."user",
            string_agg(a_1.role::character varying::text, ','::text) AS role,
            string_agg(b_1.shortcode::text, ','::text) AS rolecode
           FROM m_userrole a_1
             LEFT JOIN m_role b_1 ON a_1.role = b_1.id
          GROUP BY a_1."user") b ON a.id = b."user";