CREATE OR REPLACE VIEW public.v_cdrsvoicepicker
 AS
 SELECT row_number() OVER () AS id,
    a.phonenumber,
    a.start_stamp AS startcall,
    a.answer_stamp AS answercall,
    a.end_stamp AS endcall,
    a.direction AS calldirection,
    a.cc_record_filename AS recordingfilename,
    a.duration AS callduration
   FROM ( SELECT COALESCE(channels.actuallocaluser, channels.localuser) AS phonenumber,
            to_timestamp((channels.ringepoch / 1000)::double precision) AS start_stamp,
            to_timestamp((channels.endepoch / 1000)::double precision) AS end_stamp,
                CASE
                    WHEN channels.answerepoch = '0'::bigint THEN NULL::timestamp with time zone
                    ELSE to_timestamp((channels.answerepoch / 1000)::double precision)
                END AS answer_stamp,
            'Out'::text AS direction,
            channels.recording_file AS cc_record_filename,
                CASE
                    WHEN channels.answerepoch > 0 THEN ceiling((channels.endepoch - channels.answerepoch)::double precision / 1000::double precision)
                    ELSE 0::bigint::double precision
                END AS duration
           FROM channels
          WHERE channels.recording_file IS NOT NULL
        UNION ALL
         SELECT COALESCE(channels.actualremoteuser, channels.remoteuser) AS phonenumber,
            to_timestamp((channels.ringepoch / 1000)::double precision) AS start_stamp,
            to_timestamp((channels.endepoch / 1000)::double precision) AS end_stamp,
                CASE
                    WHEN channels.answerepoch = '0'::bigint THEN NULL::timestamp with time zone
                    ELSE to_timestamp((channels.answerepoch / 1000)::double precision)
                END AS answer_stamp,
            'In'::text AS direction,
            channels.recording_file AS cc_record_filename,
                CASE
                    WHEN channels.answerepoch > 0 THEN ceiling((channels.endepoch - channels.answerepoch)::double precision / 1000::double precision)
                    ELSE 0::bigint::double precision
                END AS duration
           FROM channels
          WHERE channels.recording_file IS NOT NULL) a;