DO $$
BEGIN
    -- Check if column does not exist
    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.columns 
        WHERE table_name='channels' 
          AND column_name='dialunansweredcall'
    ) THEN
        -- Add column with default
        ALTER TABLE channels 
        ADD COLUMN dialunansweredcall BOOLEAN DEFAULT false;
    ELSE
        -- Check if default is missing
        IF NOT EXISTS (
            SELECT 1
            FROM pg_attrdef d
            JOIN pg_attribute a ON a.attrelid = d.adrelid AND a.attnum = d.adnum
            JOIN pg_class c ON c.oid = d.adrelid
            WHERE c.relname = 'channels'
              AND a.attname = 'dialunansweredcall'
              AND pg_get_expr(d.adbin, d.adrelid) = 'false'
        ) THEN
            -- Add default only if it's missing
            ALTER TABLE channels ALTER COLUMN dialunansweredcall SET DEFAULT false;
        END IF;
    END IF;
END
$$;