/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.userRouteShift.shiftTime.service;

import com.coraltele.db.users.main.entity.ShiftTime;
import com.coraltele.db.users.main.entity.UserShift;
import com.coraltele.db.users.main.repository.ShiftTimeRepository;
import com.coraltele.db.users.main.repository.UserShiftRepository;
import com.coraltele.db.users.main.specification.ShiftTimeSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.EventNotifyModel;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.user.service.UserService;
import com.coraltele.service.user.userRouteShift.shiftTime.model.ShiftTimeModel;
import java.security.Principal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ShiftTimeService {
    private static final Logger logger = LogManager.getLogger(ShiftTimeService.class);
    @Autowired
    ShiftTimeRepository shiftTimeRepository;
    @Autowired
    UserShiftRepository userShiftRepository;
    @Autowired
    UserService userService;

    public RequestResponse createShiftTime(ShiftTimeModel shiftTimeModel) {
        logger.debug("Creating new Shift time: {}", (Object)shiftTimeModel);
        RequestResponse returnValue = new RequestResponse();
        try {
            Long fromDateTimeEpoch = DateFormatUtility.toEpochSeconds((String)shiftTimeModel.getFromDateTime());
            Long toDateTimeEpoch = DateFormatUtility.toEpochSeconds((String)shiftTimeModel.getToDateTime());
            if (toDateTimeEpoch <= fromDateTimeEpoch) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Shift Time Creation Failed");
                returnValue.setMessageDetail("'To time' must be greater than 'From time'.");
                logger.warn(returnValue.getMessageDetail());
                return returnValue;
            }
            List existingShiftTimes = (List)this.shiftTimeRepository.findAll();
            boolean isOverlapping = false;
            Optional shiftTimeOptional = null;
            for (ShiftTime existingShiftTime : existingShiftTimes) {
                Long existingFromDateTime = existingShiftTime.getFromDateTime();
                Long existingToDateTime = existingShiftTime.getToDateTime();
                if (fromDateTimeEpoch < existingFromDateTime || fromDateTimeEpoch > existingToDateTime) continue;
                isOverlapping = true;
                shiftTimeOptional = this.shiftTimeRepository.findById((Object)existingShiftTime.getId());
                break;
            }
            if (!isOverlapping) {
                ShiftTime newShiftTime = new ShiftTime();
                newShiftTime.setName(shiftTimeModel.getName());
                newShiftTime.setFromDateTime(fromDateTimeEpoch);
                newShiftTime.setToDateTime(toDateTimeEpoch);
                ShiftTime savedShiftTime = (ShiftTime)this.shiftTimeRepository.save((Object)newShiftTime);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Shift time registered successfully");
                returnValue.setMessageDetail("Shift time registered successfully with ID " + savedShiftTime.getId());
                logger.info("Shift time saved: {}", (Object)returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Shift Time Creation Failed");
                returnValue.setMessageDetail("Shift time overlaps with an existing shift. " + ShiftTimeService.setShiftNameEntity((ShiftTime)((ShiftTime)shiftTimeOptional.get())));
                logger.warn(returnValue.getMessageDetail());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to create Shift time");
            returnValue.setMessageDetail("Contact the administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse deleteShiftTime(InputIdModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional shiftTime = this.shiftTimeRepository.findById((Object)ids);
            if (shiftTime.isPresent()) {
                addValue.add(shiftTime.get());
                List userShift = this.userShiftRepository.findByShiftId(ids);
                this.shiftTimeRepository.deleteAll(addValue);
                for (UserShift userShift2 : userShift) {
                    EventNotifyModel eventData = new EventNotifyModel();
                    long epoch = System.currentTimeMillis() / 1000L;
                    eventData.setReadByUser(Boolean.valueOf(false));
                    eventData.setEventData((Object)("shift ::" + userShift2.getShiftId() + "deleted for the User " + userShift2.getUserId()));
                    eventData.setEventId(Constants.EventStatus.SHIFT_DELETE_EVENT);
                    eventData.setEventSeverity(Integer.valueOf(1));
                    eventData.setEventUUID(UUID.randomUUID().toString());
                    eventData.setEventMessage("ShiftTime deleted");
                    eventData.setEventEpoch(Long.valueOf(epoch));
                    eventData.setEventSource(principal.getName());
                    eventData.setEventDestination(userShift2.getUserId());
                    this.userService.sendNotifyToSubscriber(eventData);
                }
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateShiftTime(ShiftTimeModel data) {
        logger.debug("Updating Shift Time: {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional userShiftOptional = this.shiftTimeRepository.findById((Object)data.getId());
            if (userShiftOptional.isPresent()) {
                Long updatedToDateTime;
                ShiftTime shiftTime = (ShiftTime)userShiftOptional.get();
                Long updatedFromDateTime = data.getFromDateTime() != null ? DateFormatUtility.toEpochSeconds((String)data.getFromDateTime()) : shiftTime.getFromDateTime();
                Long l = updatedToDateTime = data.getToDateTime() != null ? DateFormatUtility.toEpochSeconds((String)data.getToDateTime()) : shiftTime.getToDateTime();
                if (updatedToDateTime <= updatedFromDateTime) {
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("Shift Time Update Failed");
                    returnValue.setMessageDetail("'To time' must be greater than 'From time'.");
                    logger.warn(returnValue.getMessageDetail());
                    return returnValue;
                }
                List existingShiftTimes = (List)this.shiftTimeRepository.findAll();
                Optional shiftTimeOptional = null;
                boolean isOverlapping = false;
                for (ShiftTime existingShiftTime : existingShiftTimes) {
                    if (existingShiftTime.getId().equals(data.getId())) continue;
                    Long existingFromDateTime = existingShiftTime.getFromDateTime();
                    Long existingToDateTime = existingShiftTime.getToDateTime();
                    if (updatedFromDateTime < existingFromDateTime || updatedFromDateTime > existingToDateTime) continue;
                    isOverlapping = true;
                    shiftTimeOptional = this.shiftTimeRepository.findById((Object)existingShiftTime.getId());
                    break;
                }
                if (!isOverlapping) {
                    if (data.getName() != null) {
                        shiftTime.setName(data.getName());
                    }
                    shiftTime.setFromDateTime(updatedFromDateTime);
                    shiftTime.setToDateTime(updatedToDateTime);
                    this.shiftTimeRepository.save((Object)shiftTime);
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("Updated successfully");
                    returnValue.setMessageDetail("Shift time updated successfully");
                    logger.info(returnValue.getMessage());
                } else {
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("Shift Time Update Failed");
                    returnValue.setMessageDetail("Shift time overlaps with an existing shift. " + ShiftTimeService.setShiftNameEntity((ShiftTime)((ShiftTime)shiftTimeOptional.get())));
                    logger.warn(returnValue.getMessageDetail());
                }
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Shift time not found");
                returnValue.setMessageDetail("No Shift time found with the given ID");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to update Shift time");
            returnValue.setMessageDetail("Please contact the administrator");
            logger.error("Error while updating the Shift Time.", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getAllShiftTime() {
        List list = (List)this.shiftTimeRepository.findAll();
        ArrayList<ShiftTimeModel> userShiftModel = new ArrayList<ShiftTimeModel>();
        RequestResponse returnValue = new RequestResponse();
        long currentEpochSeconds = Instant.now().getEpochSecond();
        for (ShiftTime shiftTime : list) {
            if (currentEpochSeconds > shiftTime.getToDateTime()) continue;
            ShiftTimeModel model = new ShiftTimeModel();
            model.setId(shiftTime.getId());
            model.setName(ShiftTimeService.setShiftNameEntity((ShiftTime)shiftTime));
            model.setFromDateTime(DateFormatUtility.fromEpochSeconds((Long)shiftTime.getFromDateTime()));
            model.setToDateTime(DateFormatUtility.fromEpochSeconds((Long)shiftTime.getToDateTime()));
            model.setUuid(shiftTime.getUuid());
            userShiftModel.add(model);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("List of ShiftTime");
        returnValue.setData(userShiftModel);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public boolean isShiftTimeValid(Integer id) {
        Optional shiftTime = this.shiftTimeRepository.findById((Object)id);
        if (shiftTime.isPresent()) {
            long currentEpochSeconds = Instant.now().getEpochSecond();
            return currentEpochSeconds <= ((ShiftTime)shiftTime.get()).getToDateTime();
        }
        return false;
    }

    public ShiftTime getShiftData(Integer id) {
        Optional data = this.shiftTimeRepository.findById((Object)id);
        if (data.isPresent()) {
            return (ShiftTime)data.get();
        }
        return null;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ShiftTimeSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.shiftTimeRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.shiftTimeRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<ShiftTimeModel> entityToModelConversion(List<ShiftTime> userLocation) {
        ArrayList<ShiftTimeModel> addValue = new ArrayList<ShiftTimeModel>();
        for (ShiftTime row : userLocation) {
            ShiftTimeModel data = new ShiftTimeModel();
            data.setId(row.getId());
            data.setName(row.getName());
            data.setUuid(row.getUuid());
            data.setFromDateTime(DateFormatUtility.fromEpochSeconds((Long)row.getFromDateTime()));
            data.setToDateTime(DateFormatUtility.fromEpochSeconds((Long)row.getToDateTime()));
            addValue.add(data);
        }
        return addValue;
    }

    public String getShiftName(Integer id) {
        Optional shiftData = this.shiftTimeRepository.findById((Object)id);
        if (shiftData.isPresent()) {
            return ((ShiftTime)shiftData.get()).getName();
        }
        return "";
    }

    public static String setShiftNameEntity(ShiftTime shiftTimeModel) {
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("dd/MM/yy HH:mm");
        String formattedFromDateTime = LocalDateTime.ofEpochSecond(shiftTimeModel.getFromDateTime(), 0, ZoneId.systemDefault().getRules().getOffset(LocalDateTime.now())).format(outputFormatter);
        String formattedToDateTime = LocalDateTime.ofEpochSecond(shiftTimeModel.getToDateTime(), 0, ZoneId.systemDefault().getRules().getOffset(LocalDateTime.now())).format(outputFormatter);
        return shiftTimeModel.getName() + " (" + formattedFromDateTime + ")-(" + formattedToDateTime + ")";
    }
}

