/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.userGroup.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.user.userGroup.model.UserGroupModel;
import com.coraltele.service.user.userGroup.service.UserGroupService;
import java.security.Principal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/userGroup"})
@RestController
public class UserGroupController {
    @Autowired
    UserGroupService userGroupService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> create(@RequestBody UserGroupModel data, Principal principal) {
        RequestResponse returnValue = this.userGroupService.createData(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllUserGroupByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.userGroupService.getAllUserGroupByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getGroupWithUser(Principal principal) {
        RequestResponse returnValue = this.userGroupService.groupWithUserList(principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/local"})
    public ResponseEntity<RequestResponse> userListSelectedIP(Principal principal) {
        RequestResponse returnValue = this.userGroupService.groupWithUserListForLocal(principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/{groupId}"})
    public ResponseEntity<RequestResponse> userList(@PathVariable(value="groupId") Long groupId) {
        RequestResponse returnValue = this.userGroupService.getUserListByGroup(groupId);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll/uniqueGroup"})
    public ResponseEntity<RequestResponse> getAllUniqueGroup() {
        RequestResponse returnValue = this.userGroupService.getAllUniqueGroup();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

